/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseUtil;
import com.sleepycat.je.ForeignKeyDeleteAction;
import com.sleepycat.je.ForeignKeyNullifier;
import com.sleepycat.je.SecondaryKeyCreator;

public class SecondaryConfig
extends DatabaseConfig {
    static SecondaryConfig DEFAULT = new SecondaryConfig();
    private boolean allowPopulate;
    private SecondaryKeyCreator keyCreator;
    private Database foreignKeyDatabase;
    private ForeignKeyDeleteAction foreignKeyDeleteAction = ForeignKeyDeleteAction.ABORT;
    private ForeignKeyNullifier foreignKeyNullifier;
    private boolean immutableSecondaryKey;

    public void setKeyCreator(SecondaryKeyCreator keyCreator) {
        this.keyCreator = keyCreator;
    }

    public SecondaryKeyCreator getKeyCreator() {
        return this.keyCreator;
    }

    public void setAllowPopulate(boolean allowPopulate) {
        this.allowPopulate = allowPopulate;
    }

    public boolean getAllowPopulate() {
        return this.allowPopulate;
    }

    public void setForeignKeyDatabase(Database foreignKeyDatabase) {
        this.foreignKeyDatabase = foreignKeyDatabase;
    }

    public Database getForeignKeyDatabase() {
        return this.foreignKeyDatabase;
    }

    public void setForeignKeyDeleteAction(ForeignKeyDeleteAction foreignKeyDeleteAction) {
        DatabaseUtil.checkForNullParam(foreignKeyDeleteAction, "foreignKeyDeleteAction");
        this.foreignKeyDeleteAction = foreignKeyDeleteAction;
    }

    public ForeignKeyDeleteAction getForeignKeyDeleteAction() {
        return this.foreignKeyDeleteAction;
    }

    public void setForeignKeyNullifier(ForeignKeyNullifier foreignKeyNullifier) {
        this.foreignKeyNullifier = foreignKeyNullifier;
    }

    public ForeignKeyNullifier getForeignKeyNullifier() {
        return this.foreignKeyNullifier;
    }

    public void setImmutableSecondaryKey(boolean immutableSecondaryKey) {
        this.immutableSecondaryKey = immutableSecondaryKey;
    }

    public boolean getImmutableSecondaryKey() {
        return this.immutableSecondaryKey;
    }

    void validate(DatabaseConfig configArg) throws DatabaseException {
        boolean imskMatch;
        boolean fkdaMatch;
        super.validate(configArg);
        if (configArg == null || !(configArg instanceof SecondaryConfig)) {
            throw new DatabaseException("The SecondaryConfig argument is null.");
        }
        SecondaryConfig config = (SecondaryConfig)configArg;
        boolean kcMatch = config.getKeyCreator() != null && config.getKeyCreator().equals(this.keyCreator);
        boolean fkdMatch = config.getForeignKeyDatabase() == this.foreignKeyDatabase;
        boolean bl = fkdaMatch = config.getForeignKeyDeleteAction() == this.foreignKeyDeleteAction;
        boolean fknMatch = config.getForeignKeyNullifier() == null ? this.foreignKeyNullifier == null : config.getForeignKeyNullifier().equals(this.foreignKeyNullifier);
        boolean bl2 = imskMatch = config.getImmutableSecondaryKey() == this.immutableSecondaryKey;
        if (kcMatch && fkdMatch && fkdaMatch && fknMatch && imskMatch) {
            return;
        }
        String message = this.genSecondaryConfigMismatchMessage(config, kcMatch, fkdMatch, fkdaMatch, fknMatch, imskMatch);
        throw new DatabaseException(message);
    }

    String genSecondaryConfigMismatchMessage(DatabaseConfig config, boolean kcMatch, boolean fkdMatch, boolean fkdaMatch, boolean fknMatch, boolean imskMatch) {
        StringBuffer ret = new StringBuffer("The following SecondaryConfig parameters for the\ncached Database do not match the parameters for the\nrequested Database:\n");
        if (!kcMatch) {
            ret.append(" SecondaryKeyCreator\n");
        }
        if (!fkdMatch) {
            ret.append(" ForeignKeyDelete\n");
        }
        if (!fkdaMatch) {
            ret.append(" ForeignKeyDeleteAction\n");
        }
        if (!fknMatch) {
            ret.append(" ForeignKeyNullifier\n");
        }
        if (!imskMatch) {
            ret.append(" ImmutableSecondaryKey\n");
        }
        return ret.toString();
    }
}

