/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.LNInfo;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.tree.LN;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class FileSelector {
    private List toBeCleanedFiles = new ArrayList();
    private Set cleanedFiles = new HashSet();
    private Set checkpointedFiles = new HashSet();
    private Set fullyProcessedFiles = new HashSet();
    private Set safeToDeleteFiles = new HashSet();
    private Map pendingLNs = new HashMap();
    private boolean pendingLNsDuringCheckpoint;
    static final /* synthetic */ boolean $assertionsDisabled;

    FileSelector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List selectFilesForCleaning(UtilizationProfile profile, boolean forceCleaning, Set lowUtilizationFiles, int maxBatchFiles) throws DatabaseException {
        FileSelector fileSelector;
        while (true) {
            Long fileNum;
            if (maxBatchFiles > 0) {
                fileSelector = this;
                synchronized (fileSelector) {
                    if (this.toBeCleanedFiles.size() >= maxBatchFiles) {
                        break;
                    }
                }
            }
            if ((fileNum = profile.getBestFileForCleaning(this, forceCleaning, lowUtilizationFiles)) == null) break;
            FileSelector fileSelector2 = this;
            synchronized (fileSelector2) {
                this.toBeCleanedFiles.add(fileNum);
            }
        }
        fileSelector = this;
        synchronized (fileSelector) {
            return new ArrayList(this.toBeCleanedFiles);
        }
    }

    synchronized boolean isFileCleaningInProgress(Long file) {
        return this.toBeCleanedFiles.contains(file) || this.cleanedFiles.contains(file) || this.checkpointedFiles.contains(file) || this.fullyProcessedFiles.contains(file) || this.safeToDeleteFiles.contains(file);
    }

    synchronized void addCleanedFile(Long fileNum) {
        this.cleanedFiles.add(fileNum);
        this.toBeCleanedFiles.remove(fileNum);
    }

    synchronized Set[] getFilesAtCheckpointStart() {
        this.pendingLNsDuringCheckpoint = !this.pendingLNs.isEmpty();
        Set[] files = new Set[]{this.cleanedFiles.size() > 0 ? new HashSet(this.cleanedFiles) : null, this.fullyProcessedFiles.size() > 0 ? new HashSet(this.fullyProcessedFiles) : null};
        return files[0] != null || files[1] != null ? files : null;
    }

    synchronized void updateFilesAtCheckpointEnd(Set[] files) {
        if (files != null) {
            Set previouslyProcessedFiles;
            Set previouslyCleanedFiles = files[0];
            if (previouslyCleanedFiles != null) {
                if (this.pendingLNsDuringCheckpoint) {
                    this.checkpointedFiles.addAll(previouslyCleanedFiles);
                } else {
                    this.safeToDeleteFiles.addAll(previouslyCleanedFiles);
                }
                this.cleanedFiles.removeAll(previouslyCleanedFiles);
            }
            if ((previouslyProcessedFiles = files[1]) != null) {
                this.safeToDeleteFiles.addAll(previouslyProcessedFiles);
                this.fullyProcessedFiles.removeAll(previouslyProcessedFiles);
            }
            this.updateProcessedFiles();
        }
    }

    synchronized void addPendingLN(LN ln, DatabaseId dbId, byte[] key, byte[] dupKey) {
        if (!$assertionsDisabled && ln == null) {
            throw new AssertionError();
        }
        this.pendingLNs.put(new Long(ln.getNodeId()), new LNInfo(ln, dbId, key, dupKey));
        this.pendingLNsDuringCheckpoint = true;
    }

    synchronized LNInfo[] getPendingLNs() {
        if (this.pendingLNs.size() > 0) {
            LNInfo[] lns = new LNInfo[this.pendingLNs.size()];
            this.pendingLNs.values().toArray(lns);
            return lns;
        }
        return null;
    }

    synchronized void removePendingLN(long nodeId) {
        this.pendingLNs.remove(new Long(nodeId));
        this.updateProcessedFiles();
    }

    synchronized Set copySafeToDeleteFiles() {
        if (this.safeToDeleteFiles.size() == 0) {
            return null;
        }
        return new HashSet(this.safeToDeleteFiles);
    }

    synchronized void removeDeletedFile(Long fileNum) {
        this.safeToDeleteFiles.remove(fileNum);
    }

    private void updateProcessedFiles() {
        if (this.pendingLNs.isEmpty()) {
            this.fullyProcessedFiles.addAll(this.checkpointedFiles);
            this.checkpointedFiles.clear();
        }
    }

    static {
        $assertionsDisabled = !FileSelector.class.desiredAssertionStatus();
    }
}

