/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LogBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;

class LogBufferPool {
    private static final String DEBUG_NAME;
    private EnvironmentImpl envImpl = null;
    private int logBufferSize;
    private LinkedList bufferPool;
    private LogBuffer currentWriteBuffer;
    private FileManager fileManager;
    private long nNotResident = 0L;
    private long nCacheMiss = 0L;
    private boolean runInMemory;
    private Latch bufferPoolLatch;
    static final /* synthetic */ boolean $assertionsDisabled;

    LogBufferPool(FileManager fileManager, EnvironmentImpl envImpl) throws DatabaseException {
        this.fileManager = fileManager;
        this.envImpl = envImpl;
        this.bufferPoolLatch = new Latch(DEBUG_NAME + "_FullLatch", envImpl);
        DbConfigManager configManager = envImpl.getConfigManager();
        this.runInMemory = configManager.getBoolean(EnvironmentParams.LOG_MEMORY_ONLY);
        this.reset(configManager);
        this.currentWriteBuffer = (LogBuffer)this.bufferPool.getFirst();
    }

    void reset(DbConfigManager configManager) throws DatabaseException {
        if (this.runInMemory && this.bufferPool != null) {
            return;
        }
        int numBuffers = configManager.getInt(EnvironmentParams.NUM_LOG_BUFFERS);
        long logBufferBudget = this.envImpl.getMemoryBudget().getLogBufferBudget();
        int newBufferSize = (int)logBufferBudget / numBuffers;
        LinkedList<LogBuffer> newPool = new LinkedList<LogBuffer>();
        if (this.runInMemory) {
            numBuffers = 1;
        }
        for (int i = 0; i < numBuffers; ++i) {
            newPool.add(new LogBuffer(newBufferSize, this.envImpl));
        }
        this.bufferPoolLatch.acquire();
        this.bufferPool = newPool;
        this.logBufferSize = newBufferSize;
        this.bufferPoolLatch.release();
    }

    ByteBuffer getWriteBuffer(int sizeNeeded, boolean flippedFile) throws IOException, DatabaseException {
        if (!this.currentWriteBuffer.hasRoom(sizeNeeded) || flippedFile) {
            this.writeBufferToFile(sizeNeeded);
        }
        if (flippedFile && !this.runInMemory) {
            this.fileManager.syncLogEndAndFinishFile();
        }
        return this.currentWriteBuffer.getDataBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeBufferToFile(int sizeNeeded) throws IOException, DatabaseException {
        int bufferSize = this.logBufferSize > sizeNeeded ? this.logBufferSize : sizeNeeded;
        ByteBuffer currentByteBuffer = this.currentWriteBuffer.getDataBuffer();
        int savePosition = currentByteBuffer.position();
        int saveLimit = currentByteBuffer.limit();
        currentByteBuffer.flip();
        if (this.runInMemory) {
            this.bufferPoolLatch.acquire();
            this.currentWriteBuffer = new LogBuffer(bufferSize, this.envImpl);
            this.bufferPool.add(this.currentWriteBuffer);
            this.bufferPoolLatch.release();
        } else {
            try {
                this.fileManager.writeLogBuffer(this.currentWriteBuffer);
                this.currentWriteBuffer.getDataBuffer().rewind();
                LogBuffer nextToUse = null;
                try {
                    this.bufferPoolLatch.acquire();
                    Iterator iter = this.bufferPool.iterator();
                    nextToUse = (LogBuffer)iter.next();
                    boolean done = this.bufferPool.remove(nextToUse);
                    if (!$assertionsDisabled && !done) {
                        throw new AssertionError();
                    }
                    nextToUse.reinit();
                    this.bufferPool.add(nextToUse);
                    this.currentWriteBuffer = nextToUse;
                }
                finally {
                    this.bufferPoolLatch.releaseIfOwner();
                }
            }
            catch (DatabaseException DE) {
                currentByteBuffer.position(savePosition);
                currentByteBuffer.limit(saveLimit);
                throw DE;
            }
        }
    }

    void writeCompleted(long lsn, boolean flushRequired) throws DatabaseException, IOException {
        this.currentWriteBuffer.registerLsn(lsn);
        if (flushRequired) {
            this.writeBufferToFile(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LogBuffer getReadBuffer(long lsn) throws DatabaseException {
        LogBuffer foundBuffer = null;
        this.bufferPoolLatch.acquire();
        try {
            ++this.nNotResident;
            Iterator iter = this.bufferPool.iterator();
            while (iter.hasNext()) {
                LogBuffer l = (LogBuffer)iter.next();
                if (!l.containsLsn(lsn)) continue;
                foundBuffer = l;
                break;
            }
            if (foundBuffer == null && this.currentWriteBuffer.containsLsn(lsn)) {
                foundBuffer = this.currentWriteBuffer;
            }
            if (foundBuffer == null) {
                ++this.nCacheMiss;
            }
        }
        finally {
            this.bufferPoolLatch.releaseIfOwner();
        }
        if (foundBuffer == null) {
            return null;
        }
        return foundBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadStats(StatsConfig config, EnvironmentStats stats) throws DatabaseException {
        stats.setNCacheMiss(this.nCacheMiss);
        stats.setNNotResident(this.nNotResident);
        if (config.getClear()) {
            this.nCacheMiss = 0L;
            this.nNotResident = 0L;
        }
        this.bufferPoolLatch.acquire();
        long bufferBytes = 0L;
        int nLogBuffers = 0;
        try {
            Iterator iter = this.bufferPool.iterator();
            while (iter.hasNext()) {
                LogBuffer l = (LogBuffer)iter.next();
                ++nLogBuffers;
                bufferBytes += (long)l.getCapacity();
            }
        }
        finally {
            this.bufferPoolLatch.release();
        }
        stats.setNLogBuffers(nLogBuffers);
        stats.setBufferBytes(bufferBytes);
    }

    static {
        $assertionsDisabled = !LogBufferPool.class.desiredAssertionStatus();
        DEBUG_NAME = LogBufferPool.class.getName();
    }
}

