/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogFileNotFoundException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

public final class ChildReference
implements LogWritable,
LogReadable {
    private Node target;
    private long lsn;
    private byte[] key;
    private byte state;
    private static final byte KNOWN_DELETED_BIT = 1;
    private static final byte CLEAR_KNOWN_DELETED_BIT = -2;
    private static final byte DIRTY_BIT = 2;
    private static final byte CLEAR_DIRTY_BIT = -3;
    private static final byte PENDING_DELETED_BIT = 8;
    private static final byte CLEAR_PENDING_DELETED_BIT = -9;
    static final /* synthetic */ boolean $assertionsDisabled;

    ChildReference() {
        this.init(null, Key.EMPTY_KEY, -1L, 0);
    }

    public ChildReference(Node target, byte[] key, long lsn) {
        this.init(target, key, lsn, 2);
    }

    public ChildReference(Node target, byte[] key, long lsn, byte existingState) {
        this.init(target, key, lsn, existingState | 2);
    }

    ChildReference(byte[] key, long lsn, boolean knownDeleted) {
        this.init(null, key, lsn, (knownDeleted ? 1 : 0) | 2);
    }

    private void init(Node target, byte[] key, long lsn, int state) {
        this.target = target;
        this.key = key;
        this.lsn = lsn;
        this.state = (byte)state;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] key) {
        this.key = key;
        this.state = (byte)(this.state | 2);
    }

    public Node fetchTarget(DatabaseImpl database, IN in) throws DatabaseException {
        if (this.target == null) {
            if (this.lsn == -1L) {
                if (!this.isKnownDeleted()) {
                    throw new DatabaseException(IN.makeFetchErrorMsg("NULL_LSN without KnownDeleted", in, this.lsn, this.state));
                }
            } else {
                try {
                    EnvironmentImpl env = database.getDbEnvironment();
                    Node node = (Node)env.getLogManager().get(this.lsn);
                    node.postFetchInit(database, this.lsn);
                    this.target = node;
                    if (in != null) {
                        in.updateMemorySize(null, this.target);
                    }
                }
                catch (LogFileNotFoundException LNFE) {
                    if (!this.isKnownDeleted() && !this.isPendingDeleted()) {
                        throw new DatabaseException(IN.makeFetchErrorMsg(LNFE.toString(), in, this.lsn, this.state), LNFE);
                    }
                }
                catch (Exception e) {
                    throw new DatabaseException(IN.makeFetchErrorMsg(e.toString(), in, this.lsn, this.state), e);
                }
            }
        }
        return this.target;
    }

    byte getState() {
        return this.state;
    }

    public Node getTarget() {
        return this.target;
    }

    public void setTarget(Node target) {
        this.target = target;
    }

    public void clearTarget() {
        this.target = null;
    }

    public long getLsn() {
        return this.lsn;
    }

    public void setLsn(long lsn) {
        this.lsn = lsn;
        this.state = (byte)(this.state | 2);
    }

    private boolean isPendingDeleted() {
        return (this.state & 8) != 0;
    }

    void setPendingDeleted(int idx) {
        this.state = (byte)(this.state | 8);
        this.state = (byte)(this.state | 2);
    }

    void clearPendingDeleted(int idx) {
        this.state = (byte)(this.state & 0xFFFFFFF7);
        this.state = (byte)(this.state | 2);
    }

    public boolean isKnownDeleted() {
        return (this.state & 1) != 0;
    }

    void setKnownDeleted() {
        this.state = (byte)(this.state | 1);
        this.state = (byte)(this.state | 2);
    }

    void clearKnownDeleted() {
        this.state = (byte)(this.state & 0xFFFFFFFE);
        this.state = (byte)(this.state | 2);
    }

    private boolean isDirty() {
        return (this.state & 2) != 0;
    }

    public int getLogSize() {
        return LogUtils.getByteArrayLogSize(this.key) + LogUtils.getLongLogSize() + 1;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeByteArray(logBuffer, this.key);
        if (!$assertionsDisabled && this.lsn == -1L) {
            throw new AssertionError();
        }
        LogUtils.writeLong(logBuffer, this.lsn);
        logBuffer.put(this.state);
        this.state = (byte)(this.state & 0xFFFFFFFD);
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryTypeVersion) {
        this.key = LogUtils.readByteArray(itemBuffer);
        this.lsn = LogUtils.readLong(itemBuffer);
        this.state = itemBuffer.get();
        this.state = (byte)(this.state & 0xFFFFFFFD);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<ref knownDeleted=\"").append(this.isKnownDeleted());
        sb.append("\" pendingDeleted=\"").append(this.isPendingDeleted());
        sb.append("\">");
        sb.append(Key.dumpString(this.key, 0));
        sb.append(DbLsn.toString(this.lsn));
        sb.append("</ref>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    String dumpString(int nspaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        if (this.lsn == -1L) {
            sb.append(TreeUtils.indent(nspaces));
            sb.append("<lsn/>");
        } else {
            sb.append(DbLsn.dumpString(this.lsn, nspaces));
        }
        sb.append('\n');
        if (this.key == null) {
            sb.append(TreeUtils.indent(nspaces));
            sb.append("<key/>");
        } else {
            sb.append(Key.dumpString(this.key, nspaces));
        }
        sb.append('\n');
        if (this.target == null) {
            sb.append(TreeUtils.indent(nspaces));
            sb.append("<target/>");
        } else {
            sb.append(this.target.dumpString(nspaces, true));
        }
        sb.append('\n');
        sb.append(TreeUtils.indent(nspaces));
        sb.append("<knownDeleted val=\"");
        sb.append(this.isKnownDeleted()).append("\"/>");
        sb.append("<dirty val=\"").append(this.isDirty()).append("\"/>");
        return sb.toString();
    }

    public String toString() {
        return this.dumpString(0, false);
    }

    static {
        $assertionsDisabled = !ChildReference.class.desiredAssertionStatus();
    }
}

