/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BitMap {
    private static final int SEGMENT_SIZE = 16;
    private static final int SEGMENT_MASK = 65535;
    private Map bitSegments = new HashMap();

    public void set(long index) throws IndexOutOfBoundsException {
        if (index < 0L) {
            throw new IndexOutOfBoundsException(index + " is negative.");
        }
        BitSet bitset = this.getBitSet(index, true);
        int useIndex = this.getIntIndex(index);
        bitset.set(useIndex);
    }

    public boolean get(long index) throws IndexOutOfBoundsException {
        if (index < 0L) {
            throw new IndexOutOfBoundsException(index + " is negative.");
        }
        BitSet bitset = this.getBitSet(index, false);
        if (bitset == null) {
            return false;
        }
        int useIndex = this.getIntIndex(index);
        return bitset.get(useIndex);
    }

    private BitSet getBitSet(long index, boolean allowCreate) {
        Long segmentId = new Long(index >> 16);
        BitSet bitset = (BitSet)this.bitSegments.get(segmentId);
        if (allowCreate && bitset == null) {
            bitset = new BitSet();
            this.bitSegments.put(segmentId, bitset);
        }
        return bitset;
    }

    private int getIntIndex(long index) {
        return (int)(index & 0xFFFFL);
    }

    int getNumSegments() {
        return this.bitSegments.size();
    }

    int cardinality() {
        int count = 0;
        Iterator iter = this.bitSegments.values().iterator();
        while (iter.hasNext()) {
            BitSet b = (BitSet)iter.next();
            count += b.cardinality();
        }
        return count;
    }
}

