/*-
* See the file LICENSE for redistribution information.
*
* Copyright (c) 2002-2005
*      Sleepycat Software.  All rights reserved.
*
* $Id: LockInfo.java,v 1.20 2005/06/10 03:15:08 linda Exp $
*/

package com.sleepycat.je.txn;

// Uncomment to add trace info.
// import com.sleepycat.je.utilint.Tracer;   

/**
 * LockInfo is a class that embodies information about a lock instance.  The
 * holding thread and the locktype are all contained in the object.
 *
 * It's possible to modify this file to add detailed information to help
 * understand deadlock messages. Uncommenting the lines marked "Uncomment to
 * add trace info" will add stacktrace information to lock timeout messages
 * that will show where the lock was taken. Obtaining this information requires
 * modifying this file and recompiling JE with the "ant jar" command because
 * the exception field and saving the exception data take extra memory, and we
 * don't want to incur this cost in the normal case for this very commonly used
 * class. Note that the new je.jar file will be in <jeHome>/build/lib/je.jar.
 */
public class LockInfo implements Cloneable {
    private Locker locker;
    private LockType lockType;

    // Uncomment to add trace info.
    // private Exception traceException;

    /**
     * Construct a new LockInfo.
     */
    LockInfo(Locker locker,
	     LockType lockType) {
	this.locker = locker;
	this.lockType = lockType;

        // Uncomment to add trace info.
        // traceException = new Exception();
    }

    /**
     * Change this lockInfo over to the prescribed locker.
     */
    void setLocker(Locker locker) {
	this.locker = locker;
    }

    /**
     * @return The transaction associated with this Lock.
     */
    Locker getLocker() {
	return locker;
    }

    /**
     * @return The LockType associated with this Lock.
     */
    void setLockType(LockType lockType) {
	this.lockType = lockType;
    }

    /**
     * @return The LockType associated with this Lock.
     */
    LockType getLockType() {
	return lockType;
    }

    public Object clone() 
        throws CloneNotSupportedException {

        return super.clone();
    }

    /** 
     * Debugging
     */
    public void dump() {
	System.out.println(this);
    }

    public String toString() {
	return "<LockInfo locker=\"" + locker.toString() + "\" " +
            "type=\"" + lockType.toString() + "\"/>"
            // Uncomment to add trace info
            //	  "type=\"" + lockType.toString() + "\"/>" +
            //    " lock taken at: " + Tracer.getStackTrace(traceException)
            ;
    }
}
