;;; Builds new GUI and Console Lispwork images
;;; Used by make-images.sh
;;;
;;; Copyright (c) 2002 by Kevin M. Rosenberg
;;; License: GPL-2


(in-package "CL-USER")
(load-all-patches) ; Make sure all Lispworks patches are loaded

(defconstant +site-config-file+
  #P"/usr/lib/lispworks/lib/4-2-0-0/config/configure.lisp")
   
(when (probe-file +site-config-file+)
  (load +site-config-file+))
   
(handler-case
 (let ((import-file (environment-variable "CLC_IMPORT_FILE")))
   (when (and import-file
	      (plusp (length import-file)))
     (load import-file)))
 (error (e)
	(ignore-errors (format t "~&Error making image: ~A~%" e))
	(finish-output)
	(quit :status 1)))

(save-image #P"/usr/lib/lispworks/lw-gui.new"
	    :environment t)

(compile (defun lw-installer-restart ()
	   #+unix (capi:ensure-motif-libraries)
	   (mp:initialize-multiprocessing)))

(save-image #P"/usr/lib/lispworks/lw-console.new"
	    :restart-function 'lw-installer-restart 
	    :environment nil
	    :multiprocessing nil
	    #+win32 :console #+win32 t)

(quit :status 0)



   
