/* WrappedButterflyFactory.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.factories.graphs.standard;

import org.grinvin.Embedding;
import org.grinvin.Graph;
import org.grinvin.Vertex;
import org.grinvin.factories.FactoryParameterException;
import org.grinvin.factories.graphs.AbstractGraphFactory;


/**
 * Factory for wrapped butterflies of given dimension.
 */
public class WrappedButterflyFactory extends AbstractGraphFactory {
    
    //
    @Override
    protected void createGraph(Graph graph, Embedding embedding) {
        int r = ((Integer)values[0]).intValue(); //r = dimension
	int rows = 1 << r;
        int order = rows*r;
	Vertex[] vertices = new Vertex[order];
        embedding.setDimension(2);
	for(int i = 0; i < r; i++)
	    for(int j = 0; j < rows; j++){
		double[] coords = new double[2];
		coords[0] = i*2.0/(r-1) - 1;
		coords[1] = j*2.0/(rows-1) - 1;
		vertices[i*rows + j] = graph.addNewVertex(null);
		embedding.setCoordinates(vertices[i*rows + j], coords);
	    }

	for(int i = 0; i < r; i++){
	    int mask = 1 << (r-1-i);
	    for(int j = 0; j < rows; j++){
		graph.addNewEdge(vertices[i*rows + j], vertices[((i+1)%r)*rows + j], null);
		graph.addNewEdge(vertices[i*rows + j], vertices[((i+1)%r)*rows + (j^mask)], null);
	    }
	}
    }
    
    //
    @Override
    protected void checkParameters(Object[] values) throws FactoryParameterException {
        super.checkParameters(values);
        int dimension = ((Integer)values[0]).intValue();
        if (dimension < 2 || dimension > 13)
            throw new FactoryParameterException("Dimension should be between 2 and 13.");
    }
}
