/* Tree.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants.computers.simple;

import org.grinvin.graphs.GraphBundleView;
import org.grinvin.invariants.computers.AbstractInvariantComputer;
import org.grinvin.invariants.values.BooleanValue;

/**
 * Computes whether the graph is a tree. This uses the following theorem:
 * a connected graph with <i>n</i> vertices is a tree if and only if it 
 * has <i>n-1</i> edges.
 */
public class Tree extends AbstractInvariantComputer {
    
    public BooleanValue compute(GraphBundleView bundle) {
        //first we check if the graph is connected
        int[][] distanceMatrix = bundle.distanceMatrix();
        int n = distanceMatrix.length;
        if (n > 0)
            for (int i=1; i < n; i++)
                for (int j=0; j < i; j++)
                    if (distanceMatrix[i][j] == 0)
                        return new BooleanValue(false, this);
        //check if number of vertices - 1 equals number of edges
        return new BooleanValue(n - 1 == bundle.getGraph().getNumberOfEdges(), this);
    }
    
    public String getInvariantId() {
        return "org.grinvin.invariants.Tree";
    }
}
