/* LongestInducedPath.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants.computers.standard;

import java.util.Arrays;

import org.grinvin.graphs.GraphBundleView;
import org.grinvin.invariants.computers.AbstractInvariantComputer;
import org.grinvin.invariants.values.IntegerValue;

/**
 * computes the longest induced path of the graph.
 */
public class LongestInducedPath extends AbstractInvariantComputer {
    
    public IntegerValue compute(GraphBundleView bundle) {
        int[][] adjlist = bundle.adjacencyList();
        int n = adjlist.length;
        
        /*
        for(int i = 0; i<n; i++)
            System.out.println(i + " " + Arrays.toString(adjlist[i]));
         */
        
        boolean[] currentPath = new boolean[n];
        Arrays.fill(currentPath, false);
        int longestInducedPath=0;
        for(int i = 0; i < n; i++)
            longestInducedPath = longestInducedPath(adjlist, i, i, 0, currentPath, longestInducedPath);
        
        return new IntegerValue(longestInducedPath, this);
    }
    
    private int longestInducedPath(int[][] adjlist, int startVertex, int currentVertex, int depth, boolean[] currentPath, int maximum){
        if(maximum == adjlist.length)
            return maximum;
        if(maximum<depth)
            maximum=depth;
        currentPath[currentVertex] = true;
        /*
        System.out.println("Start vertex: " + startVertex);
        System.out.println("Current vertex: " + currentVertex);
        System.out.println("Current path: " + Arrays.toString(currentPath));
        System.out.println("Depth: " + depth);
        System.out.println("Maximum: " + maximum);
        System.out.println();
        /**/
        for(int nextVertex : adjlist[currentVertex]){
            boolean goodNextVertex = !currentPath[nextVertex]; //prevent returning
            for(int neighbor : adjlist[nextVertex])
                goodNextVertex = goodNextVertex && (neighbor == currentVertex || !currentPath[neighbor]);
            if(goodNextVertex)
                maximum = longestInducedPath(adjlist, startVertex, nextVertex, depth+1, currentPath, maximum);
        }
        currentPath[currentVertex] = false;
        return maximum;
    }
    
    public String getInvariantId() {
        return "org.grinvin.invariants.LongestInducedPath";
    }
}
