package jdepend.framework;

import java.io.*;

/**
 * The <code>FileManagerTest</code> is a <code>TestCase</code> 
 * for the <code>FileManager</code> class.
 *
 * @author <b>Mike Clark</b> (mike@clarkware.com)
 * @author Clarkware Consulting, Inc.
 */
 
public class FileManagerTest extends JDependTestCase {
	
	private FileManager fileManager;

	public FileManagerTest(String name) {
		super(name);
	}

	protected void setUp() {
		super.setUp();
		fileManager = new FileManager();
        fileManager.acceptInnerClasses(false);
	}

	protected void tearDown() {
		super.tearDown();
	}
	
	public void testEmptyFileManager() {
		assertEquals(0, fileManager.extractFiles().size());
	}
	
    public void testAddClassesDirectory() throws IOException {
        fileManager.addDirectory(getClassesDir());
        assertEquals(38, fileManager.extractFiles().size());
    }
	
    public void testAddNonExistentDirectory() {
	
        try {
            fileManager.addDirectory(getSrcDir() + "junk");
            fail("Non-existent directory: Should raise IOException");
        } catch(IOException success)  {
        }
    }
		
    public void testAddInvalidDirectory() {
	
        try {
            fileManager.addDirectory(getSrcDir() + "JDepend.java");
            fail("Invalid directory: Should raise IOException");
        } catch(IOException success)  {
        }
    }
	    
    public void testClassFileAccept() throws IOException {

        File f = new File(getClassesDir() +
            "jdepend" + File.separator + 
            "framework" + File.separator + "JDepend.class");

        assertEquals(true, new FileManager().acceptClassFile(f));
    }
    
    public void testAcceptNonExistentClassFile() {
		
        File f = new File(getClassesDir() + "JDepend.class");
		
        assertEquals(false, new FileManager().acceptClassFile(f));
    }
	
    public void testAcceptInvalidClassFile() {
	
        String filename = getHomeDir() + "build.xml";
		
        File f = new File(filename);
		
        assertEquals(false, new FileManager().acceptClassFile(f));
    }

	public static void main(String args[]) {
		junit.textui.TestRunner.run(FileManagerTest.class);
	}
}
