/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

class CharacterData {
    static final char[][][] charMap;
    static final char[] X;
    static final char[] Y;
    static final int[] A;

    CharacterData() {
    }

    static int getProperties(char c) {
        return A[Y[X[c >> 5] << 4 | c >> 1 & 0xF] | c & '\u0001'];
    }

    static int getType(char c) {
        return CharacterData.getProperties(c) & 0x1F;
    }

    static boolean isLowerCase(char c) {
        return CharacterData.getType(c) == 2;
    }

    static boolean isUpperCase(char c) {
        return CharacterData.getType(c) == 1;
    }

    static boolean isTitleCase(char c) {
        return CharacterData.getType(c) == 3;
    }

    static boolean isDigit(char c) {
        return CharacterData.getType(c) == 9;
    }

    static boolean isDefined(char c) {
        return CharacterData.getType(c) != 0;
    }

    static boolean isLetter(char c) {
        return (62 >> CharacterData.getType(c) & 1) != 0;
    }

    static boolean isLetterOrDigit(char c) {
        return (574 >> CharacterData.getType(c) & 1) != 0;
    }

    static boolean isSpaceChar(char c) {
        return (28672 >> CharacterData.getType(c) & 1) != 0;
    }

    static boolean isJavaIdentifierStart(char c) {
        return (CharacterData.getProperties(c) & 0x7000) >= 20480;
    }

    static boolean isJavaIdentifierPart(char c) {
        return (CharacterData.getProperties(c) & 0x3000) != 0;
    }

    static boolean isUnicodeIdentifierStart(char c) {
        return (CharacterData.getProperties(c) & 0x7000) == 28672;
    }

    static boolean isUnicodeIdentifierPart(char c) {
        return (CharacterData.getProperties(c) & 0x1000) != 0;
    }

    static boolean isIdentifierIgnorable(char c) {
        return (CharacterData.getProperties(c) & 0x7000) == 4096;
    }

    static char toLowerCase(char n) {
        int n2 = n;
        int n3 = CharacterData.getProperties((char)n);
        if ((n3 & 0x20000) != 0) {
            if ((n3 & 0x7FC0000) == 133955584) {
                switch (n) {
                    case 8486: {
                        n2 = 969;
                        break;
                    }
                    case 8490: {
                        n2 = 107;
                        break;
                    }
                    case 8491: {
                        n2 = 229;
                        break;
                    }
                    case 8072: {
                        n2 = 8064;
                        break;
                    }
                    case 8073: {
                        n2 = 8065;
                        break;
                    }
                    case 8074: {
                        n2 = 8066;
                        break;
                    }
                    case 8075: {
                        n2 = 8067;
                        break;
                    }
                    case 8076: {
                        n2 = 8068;
                        break;
                    }
                    case 8077: {
                        n2 = 8069;
                        break;
                    }
                    case 8078: {
                        n2 = 8070;
                        break;
                    }
                    case 8079: {
                        n2 = 8071;
                        break;
                    }
                    case 8088: {
                        n2 = 8080;
                        break;
                    }
                    case 8089: {
                        n2 = 8081;
                        break;
                    }
                    case 8090: {
                        n2 = 8082;
                        break;
                    }
                    case 8091: {
                        n2 = 8083;
                        break;
                    }
                    case 8092: {
                        n2 = 8084;
                        break;
                    }
                    case 8093: {
                        n2 = 8085;
                        break;
                    }
                    case 8094: {
                        n2 = 8086;
                        break;
                    }
                    case 8095: {
                        n2 = 8087;
                        break;
                    }
                    case 8104: {
                        n2 = 8096;
                        break;
                    }
                    case 8105: {
                        n2 = 8097;
                        break;
                    }
                    case 8106: {
                        n2 = 8098;
                        break;
                    }
                    case 8107: {
                        n2 = 8099;
                        break;
                    }
                    case 8108: {
                        n2 = 8100;
                        break;
                    }
                    case 8109: {
                        n2 = 8101;
                        break;
                    }
                    case 8110: {
                        n2 = 8102;
                        break;
                    }
                    case 8111: {
                        n2 = 8103;
                        break;
                    }
                    case 8124: {
                        n2 = 8115;
                        break;
                    }
                    case 8140: {
                        n2 = 8131;
                        break;
                    }
                    case 8188: {
                        n2 = 8179;
                    }
                }
            } else {
                int n4 = n3 << 5 >> 23;
                n2 = (char)(n + n4);
            }
        }
        return (char)n2;
    }

    static char toUpperCase(char n) {
        int n2 = n;
        int n3 = CharacterData.getProperties((char)n);
        if ((n3 & 0x10000) != 0) {
            if ((n3 & 0x7FC0000) == 133955584) {
                switch (n) {
                    case 181: {
                        n2 = 924;
                        break;
                    }
                    case 383: {
                        n2 = 83;
                        break;
                    }
                    case 8126: {
                        n2 = 921;
                        break;
                    }
                    case 8064: {
                        n2 = 8072;
                        break;
                    }
                    case 8065: {
                        n2 = 8073;
                        break;
                    }
                    case 8066: {
                        n2 = 8074;
                        break;
                    }
                    case 8067: {
                        n2 = 8075;
                        break;
                    }
                    case 8068: {
                        n2 = 8076;
                        break;
                    }
                    case 8069: {
                        n2 = 8077;
                        break;
                    }
                    case 8070: {
                        n2 = 8078;
                        break;
                    }
                    case 8071: {
                        n2 = 8079;
                        break;
                    }
                    case 8080: {
                        n2 = 8088;
                        break;
                    }
                    case 8081: {
                        n2 = 8089;
                        break;
                    }
                    case 8082: {
                        n2 = 8090;
                        break;
                    }
                    case 8083: {
                        n2 = 8091;
                        break;
                    }
                    case 8084: {
                        n2 = 8092;
                        break;
                    }
                    case 8085: {
                        n2 = 8093;
                        break;
                    }
                    case 8086: {
                        n2 = 8094;
                        break;
                    }
                    case 8087: {
                        n2 = 8095;
                        break;
                    }
                    case 8096: {
                        n2 = 8104;
                        break;
                    }
                    case 8097: {
                        n2 = 8105;
                        break;
                    }
                    case 8098: {
                        n2 = 8106;
                        break;
                    }
                    case 8099: {
                        n2 = 8107;
                        break;
                    }
                    case 8100: {
                        n2 = 8108;
                        break;
                    }
                    case 8101: {
                        n2 = 8109;
                        break;
                    }
                    case 8102: {
                        n2 = 8110;
                        break;
                    }
                    case 8103: {
                        n2 = 8111;
                        break;
                    }
                    case 8115: {
                        n2 = 8124;
                        break;
                    }
                    case 8131: {
                        n2 = 8140;
                        break;
                    }
                    case 8179: {
                        n2 = 8188;
                    }
                }
            } else {
                int n4 = n3 << 5 >> 23;
                n2 = (char)(n - n4);
            }
        }
        return (char)n2;
    }

    static char toTitleCase(char c) {
        char c2 = c;
        int n = CharacterData.getProperties(c);
        if ((n & 0x8000) != 0) {
            if ((n & 0x10000) == 0) {
                c2 = (char)(c + '\u0001');
            } else if ((n & 0x20000) == 0) {
                c2 = (char)(c - '\u0001');
            }
        } else if ((n & 0x10000) != 0) {
            c2 = CharacterData.toUpperCase(c);
        }
        return c2;
    }

    static int digit(char c, int n) {
        int n2 = -1;
        if (n >= 2 && n <= 36) {
            int n3 = CharacterData.getProperties(c);
            int n4 = n3 & 0x1F;
            if (n4 == 9) {
                n2 = c + ((n3 & 0x3E0) >> 5) & 0x1F;
            } else if ((n3 & 0xC00) == 3072) {
                n2 = (c + ((n3 & 0x3E0) >> 5) & 0x1F) + 10;
            }
        }
        return n2 < n ? n2 : -1;
    }

    static int getNumericValue(char c) {
        int n = CharacterData.getProperties(c);
        int n2 = -1;
        block0 : switch (n & 0xC00) {
            default: {
                n2 = -1;
                break;
            }
            case 1024: {
                n2 = c + ((n & 0x3E0) >> 5) & 0x1F;
                break;
            }
            case 2048: {
                switch (c) {
                    case '\u0bf1': {
                        n2 = 100;
                        break block0;
                    }
                    case '\u0bf2': {
                        n2 = 1000;
                        break block0;
                    }
                    case '\u1375': {
                        n2 = 40;
                        break block0;
                    }
                    case '\u1376': {
                        n2 = 50;
                        break block0;
                    }
                    case '\u1377': {
                        n2 = 60;
                        break block0;
                    }
                    case '\u1378': {
                        n2 = 70;
                        break block0;
                    }
                    case '\u1379': {
                        n2 = 80;
                        break block0;
                    }
                    case '\u137a': {
                        n2 = 90;
                        break block0;
                    }
                    case '\u137b': {
                        n2 = 100;
                        break block0;
                    }
                    case '\u137c': {
                        n2 = 10000;
                        break block0;
                    }
                    case '\u215f': {
                        n2 = 1;
                        break block0;
                    }
                    case '\u216c': {
                        n2 = 50;
                        break block0;
                    }
                    case '\u216d': {
                        n2 = 100;
                        break block0;
                    }
                    case '\u216e': {
                        n2 = 500;
                        break block0;
                    }
                    case '\u216f': {
                        n2 = 1000;
                        break block0;
                    }
                    case '\u217c': {
                        n2 = 50;
                        break block0;
                    }
                    case '\u217d': {
                        n2 = 100;
                        break block0;
                    }
                    case '\u217e': {
                        n2 = 500;
                        break block0;
                    }
                    case '\u217f': {
                        n2 = 1000;
                        break block0;
                    }
                    case '\u2180': {
                        n2 = 1000;
                        break block0;
                    }
                    case '\u2181': {
                        n2 = 5000;
                        break block0;
                    }
                    case '\u2182': {
                        n2 = 10000;
                        break block0;
                    }
                }
                n2 = -2;
                break;
            }
            case 3072: {
                n2 = (c + ((n & 0x3E0) >> 5) & 0x1F) + 10;
            }
        }
        return n2;
    }

    static boolean isWhitespace(char c) {
        return (CharacterData.getProperties(c) & 0x7000) == 16384;
    }

    static byte getDirectionality(char c) {
        int n = CharacterData.getProperties(c);
        int n2 = (n & 0x78000000) >> 27;
        if (n2 == 15) {
            switch (c) {
                case '\u202a': {
                    n2 = 14;
                    break;
                }
                case '\u202b': {
                    n2 = 16;
                    break;
                }
                case '\u202c': {
                    n2 = 18;
                    break;
                }
                case '\u202d': {
                    n2 = 15;
                    break;
                }
                case '\u202e': {
                    n2 = 17;
                    break;
                }
                default: {
                    n2 = -1;
                }
            }
        }
        return (byte)n2;
    }

    static boolean isMirrored(char c) {
        return (CharacterData.getProperties(c) & Integer.MIN_VALUE) != 0;
    }

    static char toUpperCaseEx(char n) {
        int n2 = n;
        int n3 = CharacterData.getProperties((char)n);
        if ((n3 & 0x10000) != 0) {
            if ((n3 & 0x7FC0000) != 133955584) {
                int n4 = n3 << 5 >> 23;
                n2 = (char)(n - n4);
            } else {
                switch (n) {
                    case 181: {
                        n2 = 924;
                        break;
                    }
                    case 383: {
                        n2 = 83;
                        break;
                    }
                    case 8126: {
                        n2 = 921;
                        break;
                    }
                    default: {
                        n2 = 65535;
                    }
                }
            }
        }
        return (char)n2;
    }

    public static native void setArrays();

    static {
        X = new char[2048];
        Y = new char[3856];
        A = new int[678];
        charMap = new char[102][2][3];
        CharacterData.setArrays();
    }
}

