/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.connector.rmi.iiop;

import java.rmi.RemoteException;

import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.rmi.PortableRemoteObject;

import mx4j.tools.adaptor.rmi.RemoteAdaptor;
import mx4j.tools.connector.rmi.RMIConnector;

/**
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.1 $
 */
public class IIOPConnector extends RMIConnector
{
	protected RemoteAdaptor narrow(Object object)
	{
		return (RemoteAdaptor)PortableRemoteObject.narrow(object, RemoteAdaptor.class);
	}

	protected NotificationListener createRemoteNotificationListener(NotificationListener listener) throws RemoteException
	{
		IIOPRemoteNotificationListenerSupport rnl = new IIOPRemoteNotificationListenerSupport(listener);
		rnl.export();
		return rnl;
	}

	protected NotificationFilter createRemoteNotificationFilter(NotificationFilter filter) throws RemoteException
	{
		IIOPRemoteNotificationFilterSupport rnf = new IIOPRemoteNotificationFilterSupport(filter);
		rnf.export();
		return rnf;
	}
}
