/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Taskdef
extends Task {
    private String name;
    private String value;
    private Path classpath;

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public void execute() throws BuildException {
        if (this.name == null || this.value == null) {
            String msg = "name or classname attributes of taskdef element are undefined";
            throw new BuildException(msg);
        }
        try {
            ClassLoader loader = null;
            if (this.classpath != null) {
                AntClassLoader al = new AntClassLoader(this.project, this.classpath, false);
                al.addSystemPackageRoot("org.apache.tools.ant");
                loader = al;
            } else {
                loader = this.getClass().getClassLoader();
            }
            Class<?> taskClass = null;
            taskClass = loader != null ? loader.loadClass(this.value) : Class.forName(this.value);
            this.project.addTaskDefinition(this.name, taskClass);
        }
        catch (ClassNotFoundException cnfe) {
            String msg = "taskdef class " + this.value + " cannot be found";
            throw new BuildException(msg, cnfe, this.location);
        }
        catch (NoClassDefFoundError ncdfe) {
            String msg = "taskdef class " + this.value + " cannot be found";
            throw new BuildException(msg, ncdfe, this.location);
        }
    }

    public String getClassname() {
        return this.value;
    }

    public void setClassname(String v) {
        this.value = v;
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setName(String name) {
        this.name = name;
    }
}

