// Copyright (c) 1999,2000,2001,2004  INRIA Sophia-Antipolis (France).
// All rights reserved.
//
// This file is part of CGAL (www.cgal.org); you may redistribute it under
// the terms of the Q Public License version 1.0.
// See the file LICENSE.QPL distributed with CGAL.
//
// Licensees holding a valid commercial license may use this file in
// accordance with the commercial license agreement provided with the software.
//
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// $Source: /opt/cvs/multisdfDIST/CGAL-3.1/include/CGAL/Arithmetic_filter/predicates/compare_quadratic.h,v $
// $Revision: 1.1.1.1 $ $Date: 2010/03/05 22:18:41 $
// $Name:  $
//
// Author(s)     : Sylvain Pion <Sylvain.Pion@sophia.inria.fr>
//                 Menelaos Karavelas <mkaravel@cse.nd.edu>

// This file is automatically generated by
// scripts/filtered_predicates_generator.pl

// MK: January 19, 2004
// This file was originally automatically generated by
// scripts/filtered_predicates_generator.pl
// Modifications have been made on top of it.

#ifndef CGAL_ARITHMETIC_FILTER_COMPARE_QUADRATIC_H
#define CGAL_ARITHMETIC_FILTER_COMPARE_QUADRATIC_H

#include <CGAL/Profile_counter.h>

CGAL_BEGIN_NAMESPACE

template < class CGAL_IA_CT, class CGAL_IA_ET, bool CGAL_IA_PROTECTED,
           class CGAL_IA_CACHE >
/* inline */
Comparison_result
sqrt_compare_l1_l2(
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c2)
{
  try
  {
#ifdef CGAL_PROFILE
    static Profile_counter calls("IA sqrt_compare_l1_l2 calls");
    ++calls;
#endif
    Protect_FPU_rounding<CGAL_IA_PROTECTED> Protection;
    return sqrt_compare_l1_l2(
		a1.interval(),
		b1.interval(),
		c1.interval(),
		a2.interval(),
		b2.interval(),
		c2.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
#ifdef CGAL_PROFILE
    static Profile_counter failures("IA sqrt_compare_l1_l2 failures");
    ++failures;
#endif
    Protect_FPU_rounding<!CGAL_IA_PROTECTED> Protection(CGAL_FE_TONEAREST);
    return sqrt_compare_l1_l2(
		a1.exact(),
		b1.exact(),
		c1.exact(),
		a2.exact(),
		b2.exact(),
		c2.exact());
  }
}

template < class CGAL_IA_CT, class CGAL_IA_ET, bool CGAL_IA_PROTECTED,
           class CGAL_IA_CACHE >
/* inline */
Comparison_result
sqrt_compare_l1_r2(
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c2)
{
  try
  {
#ifdef CGAL_PROFILE
    static Profile_counter calls("IA sqrt_compare_l1_r2 calls");
    ++calls;
#endif
    Protect_FPU_rounding<CGAL_IA_PROTECTED> Protection;
    return sqrt_compare_l1_r2(
		a1.interval(),
		b1.interval(),
		c1.interval(),
		a2.interval(),
		b2.interval(),
		c2.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
#ifdef CGAL_PROFILE
    static Profile_counter failures("IA sqrt_compare_l1_r2 failures");
    ++failures;
#endif
    Protect_FPU_rounding<!CGAL_IA_PROTECTED> Protection(CGAL_FE_TONEAREST);
    return sqrt_compare_l1_r2(
		a1.exact(),
		b1.exact(),
		c1.exact(),
		a2.exact(),
		b2.exact(),
		c2.exact());
  }
}

template < class CGAL_IA_CT, class CGAL_IA_ET, bool CGAL_IA_PROTECTED,
           class CGAL_IA_CACHE >
/* inline */
Comparison_result
sqrt_compare_r1_l2(
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c2)
{
  try
  {
#ifdef CGAL_PROFILE
    static Profile_counter calls("IA sqrt_compare_r1_l2 calls");
    ++calls;
#endif
    Protect_FPU_rounding<CGAL_IA_PROTECTED> Protection;
    return sqrt_compare_r1_l2(
		a1.interval(),
		b1.interval(),
		c1.interval(),
		a2.interval(),
		b2.interval(),
		c2.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
#ifdef CGAL_PROFILE
    static Profile_counter failures("IA sqrt_compare_r1_l2 failures");
    ++failures;
#endif
    Protect_FPU_rounding<!CGAL_IA_PROTECTED> Protection(CGAL_FE_TONEAREST);
    return sqrt_compare_r1_l2(
		a1.exact(),
		b1.exact(),
		c1.exact(),
		a2.exact(),
		b2.exact(),
		c2.exact());
  }
}

template < class CGAL_IA_CT, class CGAL_IA_ET, bool CGAL_IA_PROTECTED,
           class CGAL_IA_CACHE >
/* inline */
Comparison_result
sqrt_compare_r1_r2(
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c2)
{
  try
  {
#ifdef CGAL_PROFILE
    static Profile_counter calls("IA sqrt_compare_r1_r2 calls");
    ++calls;
#endif
    Protect_FPU_rounding<CGAL_IA_PROTECTED> Protection;
    return sqrt_compare_r1_r2(
		a1.interval(),
		b1.interval(),
		c1.interval(),
		a2.interval(),
		b2.interval(),
		c2.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
#ifdef CGAL_PROFILE
    static Profile_counter failures("IA sqrt_compare_r1_r2 failures");
    ++failures;
#endif
    Protect_FPU_rounding<!CGAL_IA_PROTECTED> Protection(CGAL_FE_TONEAREST);
    return sqrt_compare_r1_r2(
		a1.exact(),
		b1.exact(),
		c1.exact(),
		a2.exact(),
		b2.exact(),
		c2.exact());
  }
}

template < class CGAL_IA_CT, class CGAL_IA_ET, bool CGAL_IA_PROTECTED,
           class CGAL_IA_CACHE >
/* inline */
Comparison_result
dfmt_compare_l1_l2(
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c2)
{
  try
  {
#ifdef CGAL_PROFILE
    static Profile_counter calls("IA dfmt_compare_l1_l2 calls");
    ++calls;
#endif
    Protect_FPU_rounding<CGAL_IA_PROTECTED> Protection;
    return dfmt_compare_l1_l2(
		a1.interval(),
		b1.interval(),
		c1.interval(),
		a2.interval(),
		b2.interval(),
		c2.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
#ifdef CGAL_PROFILE
    static Profile_counter failures("IA dfmt_compare_l1_l2 failures");
    ++failures;
#endif
    Protect_FPU_rounding<!CGAL_IA_PROTECTED> Protection(CGAL_FE_TONEAREST);
    return dfmt_compare_l1_l2(
		a1.exact(),
		b1.exact(),
		c1.exact(),
		a2.exact(),
		b2.exact(),
		c2.exact());
  }
}

template < class CGAL_IA_CT, class CGAL_IA_ET, bool CGAL_IA_PROTECTED,
           class CGAL_IA_CACHE >
/* inline */
Comparison_result
dfmt_compare_l1_r2(
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c2)
{
  try
  {
#ifdef CGAL_PROFILE
    static Profile_counter calls("IA dfmt_compare_l1_r2 calls");
    ++calls;
#endif
    Protect_FPU_rounding<CGAL_IA_PROTECTED> Protection;
    return dfmt_compare_l1_r2(
		a1.interval(),
		b1.interval(),
		c1.interval(),
		a2.interval(),
		b2.interval(),
		c2.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
#ifdef CGAL_PROFILE
    static Profile_counter failures("IA dfmt_compare_l1_r2 failures");
    ++failures;
#endif
    Protect_FPU_rounding<!CGAL_IA_PROTECTED> Protection(CGAL_FE_TONEAREST);
    return dfmt_compare_l1_r2(
		a1.exact(),
		b1.exact(),
		c1.exact(),
		a2.exact(),
		b2.exact(),
		c2.exact());
  }
}

template < class CGAL_IA_CT, class CGAL_IA_ET, bool CGAL_IA_PROTECTED,
           class CGAL_IA_CACHE >
/* inline */
Comparison_result
dfmt_compare_r1_l2(
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c2)
{
  try
  {
#ifdef CGAL_PROFILE
    static Profile_counter calls("IA dfmt_compare_r1_l2 calls");
    ++calls;
#endif
    Protect_FPU_rounding<CGAL_IA_PROTECTED> Protection;
    return dfmt_compare_r1_l2(
		a1.interval(),
		b1.interval(),
		c1.interval(),
		a2.interval(),
		b2.interval(),
		c2.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
#ifdef CGAL_PROFILE
    static Profile_counter failures("IA dfmt_compare_r1_l2 failures");
    ++failures;
#endif
    Protect_FPU_rounding<!CGAL_IA_PROTECTED> Protection(CGAL_FE_TONEAREST);
    return dfmt_compare_r1_l2(
		a1.exact(),
		b1.exact(),
		c1.exact(),
		a2.exact(),
		b2.exact(),
		c2.exact());
  }
}

template < class CGAL_IA_CT, class CGAL_IA_ET, bool CGAL_IA_PROTECTED,
           class CGAL_IA_CACHE >
/* inline */
Comparison_result
dfmt_compare_r1_r2(
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c2)
{
  try
  {
#ifdef CGAL_PROFILE
    static Profile_counter calls("IA dfmt_compare_r1_r2 calls");
    ++calls;
#endif
    Protect_FPU_rounding<CGAL_IA_PROTECTED> Protection;
    return dfmt_compare_r1_r2(
		a1.interval(),
		b1.interval(),
		c1.interval(),
		a2.interval(),
		b2.interval(),
		c2.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
#ifdef CGAL_PROFILE
    static Profile_counter failures("IA dfmt_compare_r1_r2 failures");
    ++failures;
#endif
    Protect_FPU_rounding<!CGAL_IA_PROTECTED> Protection(CGAL_FE_TONEAREST);
    return dfmt_compare_r1_r2(
		a1.exact(),
		b1.exact(),
		c1.exact(),
		a2.exact(),
		b2.exact(),
		c2.exact());
  }
}

template < class CGAL_IA_CT, class CGAL_IA_ET, bool CGAL_IA_PROTECTED,
           class CGAL_IA_CACHE >
/* inline */
Comparison_result
ke_compare_l1_l2(
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c2)
{
  try
  {
#ifdef CGAL_PROFILE
    static Profile_counter calls("IA ke_compare_l1_l2 calls");
    ++calls;
#endif
    Protect_FPU_rounding<CGAL_IA_PROTECTED> Protection;
    return ke_compare_l1_l2(
		a1.interval(),
		b1.interval(),
		c1.interval(),
		a2.interval(),
		b2.interval(),
		c2.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
#ifdef CGAL_PROFILE
    static Profile_counter failures("IA ke_compare_l1_l2 failures");
    ++failures;
#endif
    Protect_FPU_rounding<!CGAL_IA_PROTECTED> Protection(CGAL_FE_TONEAREST);
    return ke_compare_l1_l2(
		a1.exact(),
		b1.exact(),
		c1.exact(),
		a2.exact(),
		b2.exact(),
		c2.exact());
  }
}

template < class CGAL_IA_CT, class CGAL_IA_ET, bool CGAL_IA_PROTECTED,
           class CGAL_IA_CACHE >
/* inline */
Comparison_result
ke_compare_l1_r2(
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c2)
{
  try
  {
#ifdef CGAL_PROFILE
    static Profile_counter calls("IA ke_compare_l1_r2 calls");
    ++calls;
#endif
    Protect_FPU_rounding<CGAL_IA_PROTECTED> Protection;
    return ke_compare_l1_r2(
		a1.interval(),
		b1.interval(),
		c1.interval(),
		a2.interval(),
		b2.interval(),
		c2.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
#ifdef CGAL_PROFILE
    static Profile_counter failures("IA ke_compare_l1_r2 failures");
    ++failures;
#endif
    Protect_FPU_rounding<!CGAL_IA_PROTECTED> Protection(CGAL_FE_TONEAREST);
    return ke_compare_l1_r2(
		a1.exact(),
		b1.exact(),
		c1.exact(),
		a2.exact(),
		b2.exact(),
		c2.exact());
  }
}

template < class CGAL_IA_CT, class CGAL_IA_ET, bool CGAL_IA_PROTECTED,
           class CGAL_IA_CACHE >
/* inline */
Comparison_result
ke_compare_r1_l2(
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c2)
{
  try
  {
#ifdef CGAL_PROFILE
    static Profile_counter calls("IA ke_compare_r1_l2 calls");
    ++calls;
#endif
    Protect_FPU_rounding<CGAL_IA_PROTECTED> Protection;
    return ke_compare_r1_l2(
		a1.interval(),
		b1.interval(),
		c1.interval(),
		a2.interval(),
		b2.interval(),
		c2.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
#ifdef CGAL_PROFILE
    static Profile_counter failures("IA ke_compare_r1_l2 failures");
    ++failures;
#endif
    Protect_FPU_rounding<!CGAL_IA_PROTECTED> Protection(CGAL_FE_TONEAREST);
    return ke_compare_r1_l2(
		a1.exact(),
		b1.exact(),
		c1.exact(),
		a2.exact(),
		b2.exact(),
		c2.exact());
  }
}

template < class CGAL_IA_CT, class CGAL_IA_ET, bool CGAL_IA_PROTECTED,
           class CGAL_IA_CACHE >
/* inline */
Comparison_result
ke_compare_r1_r2(
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c1,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &a2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &b2,
    const Filtered_exact <CGAL_IA_CT, CGAL_IA_ET, Dynamic,
    CGAL_IA_PROTECTED, CGAL_IA_CACHE> &c2)
{
  try
  {
#ifdef CGAL_PROFILE
    static Profile_counter calls("IA ke_compare_r1_r2 calls");
    ++calls;
#endif
    Protect_FPU_rounding<CGAL_IA_PROTECTED> Protection;
    return ke_compare_r1_r2(
		a1.interval(),
		b1.interval(),
		c1.interval(),
		a2.interval(),
		b2.interval(),
		c2.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
#ifdef CGAL_PROFILE
    static Profile_counter failures("IA ke_compare_r1_r2 failures");
    ++failures;
#endif
    Protect_FPU_rounding<!CGAL_IA_PROTECTED> Protection(CGAL_FE_TONEAREST);
    return ke_compare_r1_r2(
		a1.exact(),
		b1.exact(),
		c1.exact(),
		a2.exact(),
		b2.exact(),
		c2.exact());
  }
}

CGAL_END_NAMESPACE

#endif // CGAL_ARITHMETIC_FILTER_COMPARE_QUADRATIC_H
