########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Wednesday 29 August 2007 12:22:14 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/blurgausian/blurgaussian_net.py,v 1.12 2007/10/08 20:20:32 vareille Exp $
#
# $Id: blurgaussian_net.py,v 1.12 2007/10/08 20:20:32 vareille Exp $
#

from traceback import print_exc
## loading libraries ##
from MolKit.VisionInterface.MolKitNodes import molkitlib
masterNet.getEditor().addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

from Volume.VisionInterface.VolumeNodes import vollib
masterNet.getEditor().addLibraryInstance(vollib,"Volume.VisionInterface.VolumeNodes", "vollib")

from DejaVu.VisionInterface.DejaVuNodes import vizlib
masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

try:
    ## saving node Read Molecule ##
    from MolKit.VisionInterface.MolKitNodes import ReadMolecule
    Read_Molecule_0 = ReadMolecule(constrkw = {}, name='Read Molecule', library=molkitlib)
    masterNet.addNode(Read_Molecule_0,76,3)
    Read_Molecule_0.inputPortByName['filename'].widget.set("nomegav1AS.pdb", run=False)
    apply(Read_Molecule_0.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore ReadMolecule named Read Molecule in network masterNet"
    print_exc()
    Read_Molecule_0=None

try:
    ## saving node Lines Macro ##
    from MolKit.VisionInterface.MolKitNodes import LinesMacro
    Lines_Macro_1 = LinesMacro(constrkw = {}, name='Lines Macro', library=molkitlib)
    masterNet.addNode(Lines_Macro_1,282,160)
    IndexedPolylines_7 = Lines_Macro_1.macroNetwork.nodes[5]
    IndexedPolylines_7.inputPortByName['name'].widget.set("", run=False)

    ## saving connections for network Lines Macro ##
    Lines_Macro_1.macroNetwork.freeze()
    input_Ports_2 = Lines_Macro_1.macroNetwork.ipNode
    if input_Ports_2 is not None and IndexedPolylines_7 is not None:
        try:
            Lines_Macro_1.macroNetwork.connectNodes(
                input_Ports_2, IndexedPolylines_7, "new", "parent", blocking=True)
        except:
            print "WARNING: failed to restore connection between input_Ports_2 and IndexedPolylines_7 in network Lines_Macro_1.macroNetwork"
    Lines_Macro_1.macroNetwork.unfreeze()

    ## modifying MacroOutputNode dynamic ports
    output_Ports_3 = Lines_Macro_1.macroNetwork.opNode
    output_Ports_3.inputPorts[1].configure(singleConnection=True)
    Lines_Macro_1.shrink()
except:
    print "WARNING: failed to restore LinesMacro named Lines Macro in network masterNet"
    print_exc()
    Lines_Macro_1=None

try:
    ## saving node Viewer ##
    from DejaVu.VisionInterface.DejaVuNodes import Viewer
    Viewer_8 = Viewer(constrkw = {}, name='Viewer', library=vizlib)
    masterNet.addNode(Viewer_8,74,303)
    ##
    ## Saving State for Viewer
    Viewer_8.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 538, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 669, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 544, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -416.07000785495495], 'd2cutH': 255, 'far': 1054.140030968699, 'd1off': 4, 'lookFrom': [0.0, 0.0, 416.07000785495495], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'rooty': 162, 'd1scale': 0.012999999999999999}
    apply(Viewer_8.vi.cameras[0].Set, (), state)

    state = {'end': 527.07001548434948, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 305.07000785495495, 'mode': 'GL_LINEAR'}
    apply(Viewer_8.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [35.941928863525391, 40.323932647705078, 153.80587387084961], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': False, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [0.89451080729999988, 0.89451080729999988, 0.89451080729999988], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-35.941928863525391, -40.323932647705078, -153.80587387084961], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': False, 'lineWidth': 1, 'inheritXform': 0}
    apply(Viewer_8.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Viewer_8.vi.rootObject:
        from opengltk.OpenGL import GL
        state = {'opacity': [1.0], 'binding': [10.0, 10.0, 10.0, 10.0, 10.0, 10.0], 'shininess': [50.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[1.0, 1.0, 1.0, 1.0]]}
        apply(Viewer_8.vi.rootObject.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Viewer_8.vi.rootObject:
        Viewer_8.vi.rootObject.clipP = []
        Viewer_8.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore Viewer named Viewer in network masterNet"
    print_exc()
    Viewer_8=None

try:
    ## saving node Select Nodes ##
    from MolKit.VisionInterface.MolKitNodes import NodeSelector
    Select_Nodes_9 = NodeSelector(constrkw = {}, name='Select Nodes', library=molkitlib)
    masterNet.addNode(Select_Nodes_9,2,111)
except:
    print "WARNING: failed to restore NodeSelector named Select Nodes in network masterNet"
    print_exc()
    Select_Nodes_9=None

try:
    ## saving node Gaussians Mask ##
    from Volume.VisionInterface.VolumeNodes import GaussiansMask
    Gaussians_Mask_10 = GaussiansMask(constrkw = {}, name='Gaussians Mask', library=vollib)
    masterNet.addNode(Gaussians_Mask_10,2,173)
    Gaussians_Mask_10.inputPortByName['apix'].widget.set(3.0, run=False)
    Gaussians_Mask_10.inputPortByName['res'].widget.set(3.0, run=False)
except:
    print "WARNING: failed to restore GaussiansMask named Gaussians Mask in network masterNet"
    print_exc()
    Gaussians_Mask_10=None

try:
    ## saving node Grid3DBB ##
    from Volume.VisionInterface.VolumeNodes import BoundingBox
    Grid3DBB_11 = BoundingBox(constrkw = {}, name='Grid3DBB', library=vollib)
    masterNet.addNode(Grid3DBB_11,113,160)
    Grid3DBB_11.inputPortByName['name'].widget.set("", run=False)
except:
    print "WARNING: failed to restore BoundingBox named Grid3DBB in network masterNet"
    print_exc()
    Grid3DBB_11=None

try:
    ## saving node Isocontour ##
    from Volume.VisionInterface.VolumeNodes import Isocontour
    Isocontour_12 = Isocontour(constrkw = {}, name='Isocontour', library=vollib)
    masterNet.addNode(Isocontour_12,2,234)
    apply(Isocontour_12.inputPortByName['isovalue'].widget.configure, (), {'max': 10.722731590270996, 'min': -0.17188772559165955})
    Isocontour_12.inputPortByName['isovalue'].widget.set(5.33950792832, run=False)
except:
    print "WARNING: failed to restore Isocontour named Isocontour in network masterNet"
    print_exc()
    Isocontour_12=None

try:
    ## saving node indexedPolygons ##
    from DejaVu.VisionInterface.GeometryNodes import IndexedPolygonsNE
    indexedPolygons_13 = IndexedPolygonsNE(constrkw = {}, name='indexedPolygons', library=vizlib)
    masterNet.addNode(indexedPolygons_13,179,252)
    indexedPolygons_13.inputPortByName['name'].widget.set("", run=False)
except:
    print "WARNING: failed to restore IndexedPolygonsNE named indexedPolygons in network masterNet"
    print_exc()
    indexedPolygons_13=None

masterNet.run()
masterNet.freeze()

## saving connections for network blurgaussian ##
if Read_Molecule_0 is not None and Lines_Macro_1 is not None:
    try:
        masterNet.connectNodes(
            Read_Molecule_0, Lines_Macro_1, "MolSets", "BondsByDist_molecules", blocking=True)
    except:
        print "WARNING: failed to restore connection between Read_Molecule_0 and Lines_Macro_1 in network masterNet"
if Lines_Macro_1 is not None and Viewer_8 is not None:
    try:
        masterNet.connectNodes(
            Lines_Macro_1, Viewer_8, "IndexedPolylines_indexedPolylines", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between Lines_Macro_1 and Viewer_8 in network masterNet"
if Read_Molecule_0 is not None and Select_Nodes_9 is not None:
    try:
        masterNet.connectNodes(
            Read_Molecule_0, Select_Nodes_9, "MolSets", "nodes", blocking=True)
    except:
        print "WARNING: failed to restore connection between Read_Molecule_0 and Select_Nodes_9 in network masterNet"
if Select_Nodes_9 is not None and Gaussians_Mask_10 is not None:
    try:
        masterNet.connectNodes(
            Select_Nodes_9, Gaussians_Mask_10, "nodes", "atoms", blocking=True)
    except:
        print "WARNING: failed to restore connection between Select_Nodes_9 and Gaussians_Mask_10 in network masterNet"
if Gaussians_Mask_10 is not None and Grid3DBB_11 is not None:
    try:
        masterNet.connectNodes(
            Gaussians_Mask_10, Grid3DBB_11, "maskGrid", "grid", blocking=True)
    except:
        print "WARNING: failed to restore connection between Gaussians_Mask_10 and Grid3DBB_11 in network masterNet"
if Isocontour_12 is not None and indexedPolygons_13 is not None:
    try:
        masterNet.connectNodes(
            Isocontour_12, indexedPolygons_13, "normals", "vnormals", blocking=True)
    except:
        print "WARNING: failed to restore connection between Isocontour_12 and indexedPolygons_13 in network masterNet"
if Isocontour_12 is not None and indexedPolygons_13 is not None:
    try:
        masterNet.connectNodes(
            Isocontour_12, indexedPolygons_13, "indices", "indices", blocking=True)
    except:
        print "WARNING: failed to restore connection between Isocontour_12 and indexedPolygons_13 in network masterNet"
if Isocontour_12 is not None and indexedPolygons_13 is not None:
    try:
        masterNet.connectNodes(
            Isocontour_12, indexedPolygons_13, "coords", "coords", blocking=True)
    except:
        print "WARNING: failed to restore connection between Isocontour_12 and indexedPolygons_13 in network masterNet"
if Gaussians_Mask_10 is not None and Isocontour_12 is not None:
    try:
        masterNet.connectNodes(
            Gaussians_Mask_10, Isocontour_12, "maskGrid", "grid3D", blocking=True)
    except:
        print "WARNING: failed to restore connection between Gaussians_Mask_10 and Isocontour_12 in network masterNet"
if indexedPolygons_13 is not None and Viewer_8 is not None:
    try:
        masterNet.connectNodes(
            indexedPolygons_13, Viewer_8, "indexedPolygons", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between indexedPolygons_13 and Viewer_8 in network masterNet"
if Grid3DBB_11 is not None and Viewer_8 is not None:
    try:
        masterNet.connectNodes(
            Grid3DBB_11, Viewer_8, "Grid3DBB", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between Grid3DBB_11 and Viewer_8 in network masterNet"
if Grid3DBB_11 is not None and indexedPolygons_13 is not None:
    try:
        masterNet.connectNodes(
            Grid3DBB_11, indexedPolygons_13, "Grid3DBB", "parent", blocking=True)
    except:
        print "WARNING: failed to restore connection between Grid3DBB_11 and indexedPolygons_13 in network masterNet"
if Grid3DBB_11 is not None and Lines_Macro_1 is not None:
    try:
        masterNet.connectNodes(
            Grid3DBB_11, Lines_Macro_1, "Grid3DBB", "IndexedPolylines_parent", blocking=True)
    except:
        print "WARNING: failed to restore connection between Grid3DBB_11 and Lines_Macro_1 in network masterNet"
masterNet.unfreeze()


def loadSavedStates_Viewer_8(self=Viewer_8, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## Object root|Grid3DBB
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'line', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'Grid3DBB', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': 0, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|Grid3DBB')
    if obj:
        apply(obj.Set, (), state)

    ## Material for Grid3DBB
    if obj:
        from opengltk.OpenGL import GL
        state = {'shininess': [50.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'binding': [10.0, 12.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for Grid3DBB

    ## Clipping Planes for Grid3DBB
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for Grid3DBB

    ## Object root|Grid3DBB|IndexedPolylines
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'IndexedPolylines', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': 0, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|Grid3DBB|IndexedPolylines')
    if obj:
        apply(obj.Set, (), state)

    ## Material for IndexedPolylines
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for IndexedPolylines

    ## Clipping Planes for IndexedPolylines
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for IndexedPolylines

    ## Object root|Grid3DBB|indexedPolygons
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 1, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'indexedPolygons', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': 0, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|Grid3DBB|indexedPolygons')
    if obj:
        apply(obj.Set, (), state)

    ## Material for indexedPolygons
    if obj:
        from opengltk.OpenGL import GL
        state = {'opacity': [0.8769230842590332], 'binding': [10.0, 10, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'shininess': [50.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[1.0, 0.58342665433883667, 0.1268940269947052, 0.8769230842590332]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for indexedPolygons

    ## Clipping Planes for indexedPolygons
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for indexedPolygons

    ## End Object root|Grid3DBB|indexedPolygons

    ##
    ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 538, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 544, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -416.07000785495495], 'd2cutH': 255, 'far': 1054.140030968699, 'd1off': 4, 'lookFrom': [0.0, 0.0, 416.07000785495495], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'd1scale': 0.012999999999999999}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 527.07001548434948, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 305.07000785495495, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [35.941928863525391, 40.323932647705078, 153.80587387084961], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': False, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [0.89451080729999988, 0.89451080729999988, 0.89451080729999988], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-35.941928863525391, -40.323932647705078, -153.80587387084961], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': False, 'lineWidth': 1, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        from opengltk.OpenGL import GL
        state = {'opacity': [1.0], 'binding': [10.0, 10.0, 10.0, 10.0, 10.0, 10.0], 'shininess': [50.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[1.0, 1.0, 1.0, 1.0]]}
        apply(self.vi.rootObject.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Viewer_8.restoreStates_cb = Viewer_8.restoreStatesFirstRun = loadSavedStates_Viewer_8
Viewer_8.menu.add_separator()
Viewer_8.menu.add_command(label='Restore states', command=Viewer_8.restoreStates_cb)

#masterNet.run()
