########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Wednesday 29 August 2007 12:57:32 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/cartoon/cartoon3_net.py,v 1.5 2007/08/29 20:37:16 vareille Exp $
#
# $Id: cartoon3_net.py,v 1.5 2007/08/29 20:37:16 vareille Exp $
#

from traceback import print_exc
## loading libraries ##
from Vision.PILNodes import imagelib
masterNet.getEditor().addLibraryInstance(imagelib,"Vision.PILNodes", "imagelib")

from Vision.StandardNodes import stdlib
masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node Filelist ##
    from Vision.StandardNodes import Filelist
    Filelist_0 = Filelist(constrkw = {}, name='Filelist', library=stdlib)
    masterNet.addNode(Filelist_0,30,12)
    Filelist_0.inputPortByName['match_str'].widget.set("cartoonMovie/*.png", run=False)
    code = """def doit(self, match_str):
    import glob
    values = glob.glob(match_str)
    values.sort()
    self.outputData(filelist=values)
"""
    Filelist_0.configure(function=code)
except:
    print "WARNING: failed to restore Filelist named Filelist in network masterNet"
    print_exc()
    Filelist_0=None

try:
    ## saving node iterate ##
    from Vision.StandardNodes import Iterate
    iterate_1 = Iterate(constrkw = {}, name='iterate', library=stdlib)
    masterNet.addNode(iterate_1,17,188)
except:
    print "WARNING: failed to restore Iterate named iterate in network masterNet"
    print_exc()
    iterate_1=None

try:
    ## saving node Read Image ##
    from Vision.PILNodes import ReadImage
    Read_Image_2 = ReadImage(constrkw = {}, name='Read Image', library=imagelib)
    masterNet.addNode(Read_Image_2,16,247)
    apply(Read_Image_2.inputPortByName['filename'].configure, (), {'datatype': 'string', 'originalDatatype': 'str'})
    Read_Image_2.inputPortByName['filename'].widget.set("", run=False)
    Read_Image_2.inputPortByName['filename'].unbindWidget()
except:
    print "WARNING: failed to restore ReadImage named Read Image in network masterNet"
    print_exc()
    Read_Image_2=None

try:
    ## saving node Scale ##
    from Vision.PILNodes import ResizeImage
    Scale_3 = ResizeImage(constrkw = {}, name='Scale', library=imagelib)
    masterNet.addNode(Scale_3,15,296)
except:
    print "WARNING: failed to restore ResizeImage named Scale in network masterNet"
    print_exc()
    Scale_3=None

try:
    ## saving node Show Image ##
    from Vision.PILNodes import ShowImage
    Show_Image_4 = ShowImage(constrkw = {}, name='Show Image', library=imagelib)
    masterNet.addNode(Show_Image_4,16,352)
except:
    print "WARNING: failed to restore ShowImage named Show Image in network masterNet"
    print_exc()
    Show_Image_4=None

try:
    ## saving node call method ##
    from Vision.StandardNodes import CallMethod
    call_method_5 = CallMethod(constrkw = {}, name='call method', library=stdlib)
    masterNet.addNode(call_method_5,55,100)
    call_method_5.inputPortByName['signature'].widget.set("sort", run=False)
    apply(call_method_5.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore CallMethod named call method in network masterNet"
    print_exc()
    call_method_5=None

masterNet.run()
masterNet.freeze()

## saving connections for network cartoon3 ##
if iterate_1 is not None and Read_Image_2 is not None:
    try:
        masterNet.connectNodes(
            iterate_1, Read_Image_2, "oneItem", "filename", blocking=True)
    except:
        print "WARNING: failed to restore connection between iterate_1 and Read_Image_2 in network masterNet"
if Read_Image_2 is not None and Scale_3 is not None:
    try:
        masterNet.connectNodes(
            Read_Image_2, Scale_3, "image", "image", blocking=True)
    except:
        print "WARNING: failed to restore connection between Read_Image_2 and Scale_3 in network masterNet"
if Scale_3 is not None and Show_Image_4 is not None:
    try:
        masterNet.connectNodes(
            Scale_3, Show_Image_4, "scaledImage", "image", blocking=True)
    except:
        print "WARNING: failed to restore connection between Scale_3 and Show_Image_4 in network masterNet"
if Filelist_0 is not None and call_method_5 is not None:
    try:
        masterNet.connectNodes(
            Filelist_0, call_method_5, "filelist", "objects", blocking=True)
    except:
        print "WARNING: failed to restore connection between Filelist_0 and call_method_5 in network masterNet"
if call_method_5 is not None and iterate_1 is not None:
    try:
        masterNet.connectNodes(
            call_method_5, iterate_1, "objects", "listToLoopOver", blocking=True)
    except:
        print "WARNING: failed to restore connection between call_method_5 and iterate_1 in network masterNet"
masterNet.unfreeze()

#masterNet.run()
