#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Wednesday 29 August 2007 12:40:31 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/mol2plv/mol2plv_net.py,v 1.18 2007/11/13 23:23:43 vareille Exp $
#
# $Id: mol2plv_net.py,v 1.18 2007/11/13 23:23:43 vareille Exp $
#


if __name__=='__main__':
    from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
    masterNet = launchVisionToRunNetworkAsApplication()
    import os
    masterNet.filename = os.path.abspath(__file__)

from traceback import print_exc
masterNet.createUserPanel('MyApp' ,width=186, height=90)
## loading libraries ##
from MolKit.VisionInterface.MolKitNodes import molkitlib
masterNet.getEditor().addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

from Vision.PILNodes import imagelib
masterNet.getEditor().addLibraryInstance(imagelib,"Vision.PILNodes", "imagelib")

from Vision.StandardNodes import stdlib
masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

from symserv.VisionInterface.SymservNodes import symlib
masterNet.getEditor().addLibraryInstance(symlib,"symserv.VisionInterface.SymservNodes", "symlib")

from DejaVu.VisionInterface.DejaVuNodes import vizlib
masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

try:
    ## saving node Lines Macro ##
    from MolKit.VisionInterface.MolKitNodes import LinesMacro
    Lines_Macro_0 = LinesMacro(constrkw = {}, name='Lines Macro', library=molkitlib)
    masterNet.addNode(Lines_Macro_0,16,116)
    input_Ports_1 = Lines_Macro_0.macroNetwork.ipNode
    input_Ports_1.move(455, 6)
    output_Ports_2 = Lines_Macro_0.macroNetwork.opNode
    output_Ports_2.move(252, 370)
    Select_Nodes_4 = Lines_Macro_0.macroNetwork.nodes[3]
    Select_Nodes_4.inputPortByName['selectionString'].widget.set("CA,C,N", run=False)
    code = """def doit(self, molecules,  nodeType,         selectionString=None):
    elemType, setType = self.levels[nodeType]
    result = setType([])
    for mol in molecules:
        selnodes = setType(mol.findType(elemType))
        if selectionString:
            selnodes = selnodes.get(selectionString)
        result = result + selnodes
    if len(result):
        result.sort()
        #print 'result' ,dir(result)
        self.outputData(nodes=result)
"""
    Select_Nodes_4.configure(function=code)
    apply(Select_Nodes_4.configure, (), {'expanded': True})
    IndexedPolylines_6 = Lines_Macro_0.macroNetwork.nodes[5]
    IndexedPolylines_6.inputPortByName['name'].widget.set("", run=False)
    from MolKit.VisionInterface.MolKitNodes import AtomsProperty
    Extract_Atom_Property_7 = AtomsProperty(constrkw = {}, name='Extract Atom Property', library=molkitlib)
    Lines_Macro_0.macroNetwork.addNode(Extract_Atom_Property_7,70,239)
    Extract_Atom_Property_7.inputPortByName['propertyName'].widget.set("coords[0]", run=False)
    apply(Extract_Atom_Property_7.configure, (), {'expanded': True})
    from DejaVu.VisionInterface.DejaVuNodes import ColorMapNE
    Color_Map_8 = ColorMapNE(constrkw = {}, name='Color Map', library=vizlib)
    Lines_Macro_0.macroNetwork.addNode(Color_Map_8,289,207)

    ## saving connections for network Lines Macro ##
    Lines_Macro_0.macroNetwork.freeze()
    if Select_Nodes_4 is not None and Extract_Atom_Property_7 is not None:
        try:
            Lines_Macro_0.macroNetwork.connectNodes(
                Select_Nodes_4, Extract_Atom_Property_7, "nodes", "atoms", blocking=True)
        except:
            print "WARNING: failed to restore connection between Select_Nodes_4 and Extract_Atom_Property_7 in network Lines_Macro_0.macroNetwork"
    if Extract_Atom_Property_7 is not None and Color_Map_8 is not None:
        try:
            Lines_Macro_0.macroNetwork.connectNodes(
                Extract_Atom_Property_7, Color_Map_8, "propertyValues", "values", blocking=True)
        except:
            print "WARNING: failed to restore connection between Extract_Atom_Property_7 and Color_Map_8 in network Lines_Macro_0.macroNetwork"
    if Color_Map_8 is not None and IndexedPolylines_6 is not None:
        try:
            Lines_Macro_0.macroNetwork.connectNodes(
                Color_Map_8, IndexedPolylines_6, "mappedColors", "colors", blocking=True)
        except:
            print "WARNING: failed to restore connection between Color_Map_8 and IndexedPolylines_6 in network Lines_Macro_0.macroNetwork"
    input_Ports_1 = Lines_Macro_0.macroNetwork.ipNode
    if input_Ports_1 is not None and IndexedPolylines_6 is not None:
        try:
            Lines_Macro_0.macroNetwork.connectNodes(
                input_Ports_1, IndexedPolylines_6, "new", "instanceMatrices", blocking=True)
        except:
            print "WARNING: failed to restore connection between input_Ports_1 and IndexedPolylines_6 in network Lines_Macro_0.macroNetwork"
    output_Ports_2 = Lines_Macro_0.macroNetwork.opNode
    if Color_Map_8 is not None and output_Ports_2 is not None:
        try:
            Lines_Macro_0.macroNetwork.connectNodes(
                Color_Map_8, output_Ports_2, "legend", "new", blocking=True)
        except:
            print "WARNING: failed to restore connection between Color_Map_8 and output_Ports_2 in network Lines_Macro_0.macroNetwork"
    Lines_Macro_0.macroNetwork.unfreeze()

    ## modifying MacroOutputNode dynamic ports
    output_Ports_2.inputPorts[1].configure(singleConnection=True)
    Lines_Macro_0.shrink()
except:
    print "WARNING: failed to restore LinesMacro named Lines Macro in network masterNet"
    print_exc()
    Lines_Macro_0=None

try:
    ## saving node Read Molecule ##
    from MolKit.VisionInterface.MolKitNodes import ReadMolecule
    Read_Molecule_9 = ReadMolecule(constrkw = {}, name='Read Molecule', library=molkitlib)
    masterNet.addNode(Read_Molecule_9,16,10)
    Read_Molecule_9.inputPortByName['filename'].widget.set("2plv.pdb", run=False)
    apply(Read_Molecule_9.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore ReadMolecule named Read Molecule in network masterNet"
    print_exc()
    Read_Molecule_9=None

try:
    ## saving node Viewer ##
    from DejaVu.VisionInterface.DejaVuNodes import Viewer
    Viewer_10 = Viewer(constrkw = {}, name='Viewer', library=vizlib)
    masterNet.addNode(Viewer_10,48,183)
    ##
    ## Saving State for Viewer
    Viewer_10.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 669, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -30.0], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 30.0], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'rooty': 226, 'd1scale': 0.012999999999999999}
    apply(Viewer_10.vi.cameras[0].Set, (), state)

    state = {'end': 40, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 25, 'mode': 'GL_LINEAR'}
    apply(Viewer_10.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [-0.20121839642524719, -0.90416216850280762, -0.3768315315246582, 0.0, -0.75205570459365845, -0.10389401018619537, 0.6508597731590271, 0.0, -0.62763327360153198, 0.41436323523521423, -0.65907490253448486, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [0.029604684561491013, 0.029604684561491013, 0.029604684561491013], 'lighting': False, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-0.043005123734474182, -0.0085970098152756691, 0.074012324213981628], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(Viewer_10.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Viewer_10.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Viewer_10.vi.rootObject:
        Viewer_10.vi.rootObject.clipP = []
        Viewer_10.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore Viewer named Viewer in network masterNet"
    print_exc()
    Viewer_10=None

try:
    ## saving node Icosahedral1 ##
    from symserv.VisionInterface.SymservNodes import Icos1
    Icosahedral1_11 = Icos1(constrkw = {}, name='Icosahedral1', library=symlib)
    masterNet.addNode(Icosahedral1_11,116,131)
    Icosahedral1_11.macroNetwork.deleteConnection(Icosahedral1_11.macroNetwork.nodes[2], 'outMatrices', Icosahedral1_11.macroNetwork.nodes[3], 'matrices')
    input_Ports_12 = Icosahedral1_11.macroNetwork.ipNode
    input_Ports_12.move(103, 16)
    output_Ports_13 = Icosahedral1_11.macroNetwork.opNode
    output_Ports_13.move(120, 370)
    from symserv.VisionInterface.SymservNodes import SymTransNE
    Translate_20 = SymTransNE(constrkw = {}, name='Translate', library=symlib)
    Icosahedral1_11.macroNetwork.addNode(Translate_20,103,107)
    apply(Translate_20.inputPortByName['length'].configure, (), {'datatype': 'int', 'originalDatatype': 'None', 'height': 8})
    Translate_20.inputPortByName['vector'].widget.set([0.0, 0.52504568096145199, 0.85107404666322961], run=False)
    Translate_20.inputPortByName['length'].widget.set(422.694666667, run=False)
    Translate_20.inputPortByName['length'].unbindWidget()

    ## saving connections for network Icosahedral1 ##
    Icosahedral1_11.macroNetwork.freeze()
    _3_fold_15 = Icosahedral1_11.macroNetwork.nodes[3]
    if Translate_20 is not None and _3_fold_15 is not None:
        try:
            Icosahedral1_11.macroNetwork.connectNodes(
                Translate_20, _3_fold_15, "outMatrices", "matrices", blocking=True)
        except:
            print "WARNING: failed to restore connection between Translate_20 and _3_fold_15 in network Icosahedral1_11.macroNetwork"
    _5_fold_14 = Icosahedral1_11.macroNetwork.nodes[2]
    if _5_fold_14 is not None and Translate_20 is not None:
        try:
            Icosahedral1_11.macroNetwork.connectNodes(
                _5_fold_14, Translate_20, "outMatrices", "matrices", blocking=True)
        except:
            print "WARNING: failed to restore connection between _5_fold_14 and Translate_20 in network Icosahedral1_11.macroNetwork"
    input_Ports_12 = Icosahedral1_11.macroNetwork.ipNode
    if input_Ports_12 is not None and Translate_20 is not None:
        try:
            Icosahedral1_11.macroNetwork.connectNodes(
                input_Ports_12, Translate_20, "new", "length", blocking=True)
        except:
            print "WARNING: failed to restore connection between input_Ports_12 and Translate_20 in network Icosahedral1_11.macroNetwork"
    Icosahedral1_11.macroNetwork.unfreeze()

    ## modifying MacroOutputNode dynamic ports
    output_Ports_13 = Icosahedral1_11.macroNetwork.opNode
    output_Ports_13.inputPorts[1].configure(singleConnection=True)
    Icosahedral1_11.shrink()
except:
    print "WARNING: failed to restore Icos1 named Icosahedral1 in network masterNet"
    print_exc()
    Icosahedral1_11=None

try:
    ## saving node Save Image ##
    from Vision.PILNodes import SaveImage
    Save_Image_21 = SaveImage(constrkw = {}, name='Save Image', library=imagelib)
    masterNet.addNode(Save_Image_21,113,352)
    apply(Save_Image_21.inputPortByName['filename'].configure, (), {'datatype': 'string', 'originalDatatype': 'str'})
    Save_Image_21.inputPortByName['filename'].widget.set("", run=False)
    Save_Image_21.inputPortByName['filename'].unbindWidget()
except:
    print "WARNING: failed to restore SaveImage named Save Image in network masterNet"
    print_exc()
    Save_Image_21=None

try:
    ## saving node Grab Image ##
    from Vision.PILNodes import GetFrontBuffer
    Grab_Image_22 = GetFrontBuffer(constrkw = {}, name='Grab Image', library=imagelib)
    masterNet.addNode(Grab_Image_22,65,238)
except:
    print "WARNING: failed to restore GetFrontBuffer named Grab Image in network masterNet"
    print_exc()
    Grab_Image_22=None

try:
    ## saving node Filename ##
    from Vision.StandardNodes import Filename
    Filename_23 = Filename(constrkw = {}, name='Filename', library=stdlib)
    masterNet.addNode(Filename_23,130,223)
    Filename_23.inputPortByName['format'].widget.set("../outputfiles/file%03d.png", run=False)
except:
    print "WARNING: failed to restore Filename named Filename in network masterNet"
    print_exc()
    Filename_23=None

try:
    ## saving node iterate ##
    from Vision.StandardNodes import Iterate
    iterate_24 = Iterate(constrkw = {}, name='iterate', library=stdlib)
    masterNet.addNode(iterate_24,184,73)
except:
    print "WARNING: failed to restore Iterate named iterate in network masterNet"
    print_exc()
    iterate_24=None

try:
    ## saving node range ##
    from Vision.StandardNodes import Range
    range_25 = Range(constrkw = {}, name='range', library=stdlib)
    masterNet.addNode(range_25,184,23)
    range_25.inputPortByName['toInd'].widget.set(99, run=False)
except:
    print "WARNING: failed to restore Range named range in network masterNet"
    print_exc()
    range_25=None

masterNet.run()
masterNet.freeze()

## saving connections for network mol2plv ##
if Lines_Macro_0 is not None and Viewer_10 is not None:
    try:
        masterNet.connectNodes(
            Lines_Macro_0, Viewer_10, "IndexedPolylines_indexedPolylines", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between Lines_Macro_0 and Viewer_10 in network masterNet"
if Read_Molecule_9 is not None and Lines_Macro_0 is not None:
    try:
        masterNet.connectNodes(
            Read_Molecule_9, Lines_Macro_0, "MolSets", "BondsByDist_molecules", blocking=True)
    except:
        print "WARNING: failed to restore connection between Read_Molecule_9 and Lines_Macro_0 in network masterNet"
if Icosahedral1_11 is not None and Lines_Macro_0 is not None:
    try:
        masterNet.connectNodes(
            Icosahedral1_11, Lines_Macro_0, "Merge_outMatrices", "IndexedPolylines_instanceMatrices", blocking=True)
    except:
        print "WARNING: failed to restore connection between Icosahedral1_11 and Lines_Macro_0 in network masterNet"
if Lines_Macro_0 is not None and Viewer_10 is not None:
    try:
        masterNet.connectNodes(
            Lines_Macro_0, Viewer_10, "Color Map_legend", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between Lines_Macro_0 and Viewer_10 in network masterNet"
if Grab_Image_22 is not None and Save_Image_21 is not None:
    try:
        masterNet.connectNodes(
            Grab_Image_22, Save_Image_21, "image", "image", blocking=True)
    except:
        print "WARNING: failed to restore connection between Grab_Image_22 and Save_Image_21 in network masterNet"
if Filename_23 is not None and Save_Image_21 is not None:
    try:
        masterNet.connectNodes(
            Filename_23, Save_Image_21, "filename", "filename", blocking=True)
    except:
        print "WARNING: failed to restore connection between Filename_23 and Save_Image_21 in network masterNet"
if Viewer_10 is not None and Grab_Image_22 is not None:
    try:
        masterNet.connectNodes(
            Viewer_10, Grab_Image_22, "dejaVuViewer", "viewer", blocking=True)
    except:
        print "WARNING: failed to restore connection between Viewer_10 and Grab_Image_22 in network masterNet"
if iterate_24 is not None and Icosahedral1_11 is not None:
    try:
        masterNet.connectNodes(
            iterate_24, Icosahedral1_11, "oneItem", "Translate_length", blocking=True)
    except:
        print "WARNING: failed to restore connection between iterate_24 and Icosahedral1_11 in network masterNet"
if range_25 is not None and iterate_24 is not None:
    try:
        masterNet.connectNodes(
            range_25, iterate_24, "data", "listToLoopOver", blocking=True)
    except:
        print "WARNING: failed to restore connection between range_25 and iterate_24 in network masterNet"
if iterate_24 is not None and Filename_23 is not None:
    try:
        masterNet.connectNodes(
            iterate_24, Filename_23, "iter", "number", blocking=True)
    except:
        print "WARNING: failed to restore connection between iterate_24 and Filename_23 in network masterNet"
masterNet.unfreeze()


def loadSavedStates_Viewer_10(self=Viewer_10, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## Object root|cmap
    state = {'needsRedoDpyListOnResize': True, 'name': 'cmap', 'replace': False, 'visible': 1, 'immediateRendering': False, 'listed': True, 'anchor': [1, 0], 'position': [1, 0], 'protected': False, 'transparent': True, 'pickable': True, 'size': [12, 120]}
    obj = self.vi.FindObjectByName('root|cmap')
    if obj:
        apply(obj.Set, (), state)

    ## Object root|IndexedPolylines
    ## End Object root|IndexedPolylines

    ##
    ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -30.0], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 30.0], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'd1scale': 0.012999999999999999}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 40, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 25, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [-0.20121839642524719, -0.90416216850280762, -0.3768315315246582, 0.0, -0.75205570459365845, -0.10389401018619537, 0.6508597731590271, 0.0, -0.62763327360153198, 0.41436323523521423, -0.65907490253448486, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [0.029604684561491013, 0.029604684561491013, 0.029604684561491013], 'lighting': False, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-0.043005123734474182, -0.0085970098152756691, 0.074012324213981628], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Viewer_10.restoreStates_cb = Viewer_10.restoreStatesFirstRun = loadSavedStates_Viewer_10
Viewer_10.menu.add_separator()
Viewer_10.menu.add_command(label='Restore states', command=Viewer_10.restoreStates_cb)

#masterNet.run()

if __name__=='__main__':
    mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
