########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Wednesday 29 August 2007 13:10:18 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/runningsurface/runningsurface_pmvnet.py,v 1.12 2007/10/08 20:20:32 vareille Exp $
#
# $Id: runningsurface_pmvnet.py,v 1.12 2007/10/08 20:20:32 vareille Exp $
#

from traceback import print_exc
## loading libraries ##
from Pmv.VisionInterface.PmvNodes import pmvlib
masterNet.getEditor().addLibraryInstance(pmvlib,"Pmv.VisionInterface.PmvNodes", "pmvlib")

from MolKit.VisionInterface.MolKitNodes import molkitlib
masterNet.getEditor().addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

from DejaVu.VisionInterface.DejaVuNodes import vizlib
masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

from Vision.StandardNodes import stdlib
masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node Select Nodes ##
    from MolKit.VisionInterface.MolKitNodes import NodeSelector
    Select_Nodes_0 = NodeSelector(constrkw = {}, name='Select Nodes', library=molkitlib)
    masterNet.addNode(Select_Nodes_0,32,146)
    apply(Select_Nodes_0.outputPortByName['nodes'].configure, (), {'datatype': 'ResidueSet'})
    Select_Nodes_0.inputPortByName['nodeType'].widget.set("Residue", run=False)
except:
    print "WARNING: failed to restore NodeSelector named Select Nodes in network masterNet"
    print_exc()
    Select_Nodes_0=None

try:
    ## saving node sub ##
    from Vision.StandardNodes import Operator2
    sub_1 = Operator2(constrkw = {}, name='sub', library=stdlib)
    masterNet.addNode(sub_1,319,133)
    sub_1.inputPortByName['operation'].widget.set("sub", run=False)
    apply(sub_1.configure, (), {'expanded': False})
except:
    print "WARNING: failed to restore Operator2 named sub in network masterNet"
    print_exc()
    sub_1=None

try:
    ## saving node Pmv ##
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_2 = PmvNode(vf=masterNet.editor.vf, constrkw = {'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    masterNet.addNode(Pmv_2,14,383)
    Pmv_2.inputPortByName['cmdName'].widget.set("", run=False)
    Pmv_2.inputPortByName['molecule'].widget.set("", run=False)
except:
    print "WARNING: failed to restore PmvNode named Pmv in network masterNet"
    print_exc()
    Pmv_2=None

try:
    ## saving node Choose Cmd ##
    from Pmv.VisionInterface.PmvNodes import PmvChooseCommand
    Choose_Cmd_3 = PmvChooseCommand(constrkw = {}, name='Choose Cmd', library=pmvlib)
    masterNet.addNode(Choose_Cmd_3,16,442)
    Choose_Cmd_3.inputPortByName['cmdName'].widget.set("computeMSMS", run=False)
except:
    print "WARNING: failed to restore PmvChooseCommand named Choose Cmd in network masterNet"
    print_exc()
    Choose_Cmd_3=None

try:
    ## saving node Run computeMSMS ##
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    Run_computeMSMS_4 = PmvRunCommand(sortedArgNames=['topCommand', 'setupUndo', 'log', 'density', 'pRadius', 'perMol', 'redraw', 'display', 'surfName'], command=masterNet.editor.vf.computeMSMS, namedArgs={'topCommand': True, 'setupUndo': True, 'log': True, 'density': 1.0, 'pRadius': 1.5, 'perMol': True, 'redraw': True, 'display': True, 'surfName': 'MSMS-MOL'}, posArgsNames=['nodes'], constrkw = {'sortedArgNames': "['topCommand', 'setupUndo', 'log', 'density', 'pRadius', 'perMol', 'redraw', 'display', 'surfName']", 'command': 'masterNet.editor.vf.computeMSMS', 'namedArgs': "{'topCommand': True, 'setupUndo': True, 'log': True, 'density': 1.0, 'pRadius': 1.5, 'perMol': True, 'redraw': True, 'display': True, 'surfName': 'MSMS-MOL'}", 'posArgsNames': "['nodes']"}, name='Run computeMSMS', library=pmvlib)
    masterNet.addNode(Run_computeMSMS_4,77,552)
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'nodes', 'cast': True, 'datatype': 'ResidueSet', 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': '#f64e70'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'topCommand', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'setupUndo', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'log', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'density', 'cast': True, 'datatype': 'float', 'balloon': 'Defaults to1.0', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'green'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'pRadius', 'cast': True, 'datatype': 'float', 'balloon': 'Defaults to1.5', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'green'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'perMol', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'redraw', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'display', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_computeMSMS_4.addInputPort, (), {'singleConnection': True, 'name': 'surfName', 'cast': True, 'datatype': 'string', 'balloon': 'Defaults toMSMS-MOL', 'required': False, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(Run_computeMSMS_4.inputPortByName['topCommand'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 1, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 1}, 'labelCfg': {'text': 'topCommand'}, 'class': 'NECheckButton'}})
    apply(Run_computeMSMS_4.inputPortByName['setupUndo'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 3, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 3}, 'labelCfg': {'text': 'setupUndo'}, 'class': 'NECheckButton'}})
    apply(Run_computeMSMS_4.inputPortByName['log'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 5, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 5}, 'labelCfg': {'text': 'log'}, 'class': 'NECheckButton'}})
    apply(Run_computeMSMS_4.inputPortByName['density'].createWidget, (), {'descr':{'initialValue': 1.0, 'labelGridCfg': {'column': 0, 'row': 7, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 7}, 'labelCfg': {'text': 'density'}, 'class': 'NEDial', 'oneTurn': 1}})
    Run_computeMSMS_4.inputPortByName['density'].widget.set(3.0, run=False)
    apply(Run_computeMSMS_4.inputPortByName['pRadius'].createWidget, (), {'descr':{'initialValue': 1.5, 'labelGridCfg': {'column': 0, 'row': 9, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 9}, 'labelCfg': {'text': 'pRadius'}, 'class': 'NEDial', 'oneTurn': 1}})
    apply(Run_computeMSMS_4.inputPortByName['perMol'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 11, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 11}, 'labelCfg': {'text': 'perMol'}, 'class': 'NECheckButton'}})
    Run_computeMSMS_4.inputPortByName['perMol'].widget.set(0, run=False)
    apply(Run_computeMSMS_4.inputPortByName['redraw'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 13, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 13}, 'labelCfg': {'text': 'redraw'}, 'class': 'NECheckButton'}})
    apply(Run_computeMSMS_4.inputPortByName['display'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 15, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 15}, 'labelCfg': {'text': 'display'}, 'class': 'NECheckButton'}})
except:
    print "WARNING: failed to restore PmvRunCommand named Run computeMSMS in network masterNet"
    print_exc()
    Run_computeMSMS_4=None

try:
    ## saving node Filename ##
    from Vision.StandardNodes import Filename
    Filename_5 = Filename(constrkw = {}, name='Filename', library=stdlib)
    masterNet.addNode(Filename_5,189,434)
except:
    print "WARNING: failed to restore Filename named Filename in network masterNet"
    print_exc()
    Filename_5=None

try:
    ## saving node len ##
    from Vision.StandardNodes import Len
    len_6 = Len(constrkw = {}, name='len', library=stdlib)
    masterNet.addNode(len_6,143,76)
    apply(len_6.inputPortByName['in1'].configure, (), {'datatype': 'ResidueSet', 'originalDatatype': 'None'})
except:
    print "WARNING: failed to restore Len named len in network masterNet"
    print_exc()
    len_6=None

try:
    ## saving node range ##
    from Vision.StandardNodes import Range
    range_7 = Range(constrkw = {}, name='range', library=stdlib)
    masterNet.addNode(range_7,175,147)
    range_7.inputPortByName['toInd'].unbindWidget()
    range_7.inputPortByName['step'].widget.set(3, run=False)
    range_7.inputPortByName['step'].unbindWidget()
except:
    print "WARNING: failed to restore Range named range in network masterNet"
    print_exc()
    range_7=None

try:
    ## saving node add ##
    from Vision.StandardNodes import Operator2
    add_8 = Operator2(constrkw = {}, name='add', library=stdlib)
    masterNet.addNode(add_8,259,315)
    apply(add_8.inputPortByName['data1'].configure, (), {'datatype': 'int', 'originalDatatype': 'None'})
    apply(add_8.inputPortByName['data2'].configure, (), {'datatype': 'int', 'originalDatatype': 'None'})
    add_8.inputPortByName['operation'].widget.set("add", run=False)
    apply(add_8.configure, (), {'expanded': False})
except:
    print "WARNING: failed to restore Operator2 named add in network masterNet"
    print_exc()
    add_8=None

try:
    ## saving node Stepsize ##
    from Vision.StandardNodes import DialIntNE
    Stepsize_9 = DialIntNE(constrkw = {}, name='Stepsize', library=stdlib)
    masterNet.addNode(Stepsize_9,227,12)
    Stepsize_9.inputPortByName['dial'].widget.set(5, run=False)
except:
    print "WARNING: failed to restore DialIntNE named Stepsize in network masterNet"
    print_exc()
    Stepsize_9=None

try:
    ## saving node Slice ##
    from Vision.StandardNodes import Slice
    Slice_10 = Slice(constrkw = {}, name='Slice', library=stdlib)
    masterNet.addNode(Slice_10,76,336)
    apply(Slice_10.inputPortByName['data'].configure, (), {'datatype': 'ResidueSet', 'originalDatatype': 'None'})
    apply(Slice_10.outputPortByName['data'].configure, (), {'datatype': 'ResidueSet'})
    Slice_10.inputPortByName['fromInd'].unbindWidget()
    Slice_10.inputPortByName['toInd'].unbindWidget()
except:
    print "WARNING: failed to restore Slice named Slice in network masterNet"
    print_exc()
    Slice_10=None

try:
    ## saving node iterate ##
    from Vision.StandardNodes import Iterate
    iterate_11 = Iterate(constrkw = {}, name='iterate', library=stdlib)
    masterNet.addNode(iterate_11,170,235)
    apply(iterate_11.configure, (), {'specialPortsVisible': True})
    apply(iterate_11.configure, (), {'specialPortsVisible': True})
except:
    print "WARNING: failed to restore Iterate named iterate in network masterNet"
    print_exc()
    iterate_11=None

try:
    ## saving node overlap ##
    from Vision.StandardNodes import DialIntNE
    overlap_12 = DialIntNE(constrkw = {}, name='overlap', library=stdlib)
    masterNet.addNode(overlap_12,348,9)
    overlap_12.inputPortByName['dial'].widget.set(1, run=False)
except:
    print "WARNING: failed to restore DialIntNE named overlap in network masterNet"
    print_exc()
    overlap_12=None

try:
    ## saving node Pmv Viewer ##
    from Pmv.VisionInterface.PmvNodes import PmvViewer
    Pmv_Viewer_13 = PmvViewer(viewer=masterNet.editor.vf.GUI.VIEWER, constrkw = {'viewer': 'masterNet.editor.vf.GUI.VIEWER'}, name='Pmv Viewer', library=pmvlib)
    masterNet.addNode(Pmv_Viewer_13,434,20)
    ##
    ## Saving State for Viewer
    Pmv_Viewer_13.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 27, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 624, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -162.25584411621094], 'd2cutH': 255, 'far': 411.05302559328948, 'd1off': 4, 'lookFrom': [0.0, 0.0, 162.25584411621094], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'rooty': 122, 'd1scale': 0.012999999999999999}
    apply(Pmv_Viewer_13.vi.cameras[0].Set, (), state)

    state = {'end': 205.52651279664474, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 118.98517977706905, 'mode': 'GL_LINEAR'}
    apply(Pmv_Viewer_13.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [29.905378341674805, 16.498878479003906, 56.405982971191406], 'rotation': [0.38596192002296448, -0.83629798889160156, 0.38940849900245667, 0.0, 0.35673466324806213, 0.52458041906356812, 0.77301734685897827, 0.0, -0.85074895620346069, -0.15943977236747742, 0.50080454349517822, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-29.90538215637207, -16.498876571655273, -56.405982971191406], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(Pmv_Viewer_13.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Pmv_Viewer_13.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Pmv_Viewer_13.vi.rootObject:
        Pmv_Viewer_13.vi.rootObject.clipP = []
        Pmv_Viewer_13.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore PmvViewer named Pmv Viewer in network masterNet"
    print_exc()
    Pmv_Viewer_13=None

try:
    ## saving node file00000054.png ##
    from DejaVu.VisionInterface.DejaVuNodes import SelectMultipleGeometry
    file00000054_png_14 = SelectMultipleGeometry(constrkw = {}, name='file00000054.png', library=vizlib)
    masterNet.addNode(file00000054_png_14,422,316)
    apply(file00000054_png_14.configure, (), {'specialPortsVisible': True})
    file00000054_png_14.inputPortByName['name'].widget.set("file0000", run=False)
    apply(file00000054_png_14.configure, (), {'specialPortsVisible': True, 'expanded': True})
except:
    print "WARNING: failed to restore SelectMultipleGeometry named file00000054.png in network masterNet"
    print_exc()
    file00000054_png_14=None

try:
    ## saving node TF_1 ##
    from DejaVu.VisionInterface.DejaVuNodes import SelectGeometry
    TF_1_15 = SelectGeometry(constrkw = {}, name='TF_1', library=vizlib)
    masterNet.addNode(TF_1_15,567,43)
    TF_1_15.inputPortByName['geomName'].widget.set("", run=False)
    apply(TF_1_15.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore SelectGeometry named TF_1 in network masterNet"
    print_exc()
    TF_1_15=None

try:
    ## saving node Reparent Geom ##
    from DejaVu.VisionInterface.DejaVuNodes import ReparentGeom
    Reparent_Geom_16 = ReparentGeom(constrkw = {}, name='Reparent Geom', library=vizlib)
    masterNet.addNode(Reparent_Geom_16,596,474)
except:
    print "WARNING: failed to restore ReparentGeom named Reparent Geom in network masterNet"
    print_exc()
    Reparent_Geom_16=None

try:
    ## saving node Pmv Viewer ##
    from Pmv.VisionInterface.PmvNodes import PmvViewer
    Pmv_Viewer_17 = PmvViewer(viewer=masterNet.editor.vf.GUI.VIEWER, constrkw = {'viewer': 'masterNet.editor.vf.GUI.VIEWER'}, name='Pmv Viewer', library=pmvlib)
    masterNet.addNode(Pmv_Viewer_17,883,408)
    ##
    ## Saving State for Viewer
    Pmv_Viewer_17.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 27, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 624, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -162.25584411621094], 'd2cutH': 255, 'far': 411.05302559328948, 'd1off': 4, 'lookFrom': [0.0, 0.0, 162.25584411621094], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'rooty': 122, 'd1scale': 0.012999999999999999}
    apply(Pmv_Viewer_17.vi.cameras[0].Set, (), state)

    state = {'end': 205.52651279664474, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 118.98517977706905, 'mode': 'GL_LINEAR'}
    apply(Pmv_Viewer_17.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [29.905378341674805, 16.498878479003906, 56.405982971191406], 'rotation': [0.38596192002296448, -0.83629798889160156, 0.38940849900245667, 0.0, 0.35673466324806213, 0.52458041906356812, 0.77301734685897827, 0.0, -0.85074895620346069, -0.15943977236747742, 0.50080454349517822, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-29.90538215637207, -16.498876571655273, -56.405982971191406], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(Pmv_Viewer_17.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Pmv_Viewer_17.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Pmv_Viewer_17.vi.rootObject:
        Pmv_Viewer_17.vi.rootObject.clipP = []
        Pmv_Viewer_17.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore PmvViewer named Pmv Viewer in network masterNet"
    print_exc()
    Pmv_Viewer_17=None

try:
    ## saving node geomContainer ##
    from DejaVu.VisionInterface.GeometryNodes import GeomContainer
    geomContainer_18 = GeomContainer(constrkw = {}, name='geomContainer', library=vizlib)
    masterNet.addNode(geomContainer_18,748,323)
    geomContainer_18.inputPortByName['name'].widget.set("", run=False)
except:
    print "WARNING: failed to restore GeomContainer named geomContainer in network masterNet"
    print_exc()
    geomContainer_18=None

try:
    ## saving node tf_1 ##
    import os
    from mglutil.util.relpath import rel2abs
    lRelFileName = 'tf_1.pdb'
    lNetworkDir = os.path.dirname(os.path.abspath(masterNet.filename))
    lAbsFileName = rel2abs(lRelFileName, lNetworkDir)
    mol = masterNet.editor.vf.loadMoleculeIfNeeded(lAbsFileName)
    assert mol
    from Pmv.VisionInterface.PmvNodes import PmvMolecule
    tf_1_19 = PmvMolecule(molecule=masterNet.editor.vf.expandNodes("tf_1")[0], constrkw = {'molecule': 'masterNet.editor.vf.expandNodes("tf_1")[0]'}, name='tf_1', library=pmvlib)
    masterNet.addNode(tf_1_19,24,74)
except:
    print "WARNING: failed to restore PmvMolecule named tf_1 in network masterNet"
    print_exc()
    tf_1_19=None

masterNet.run()
masterNet.freeze()

## saving connections for network runningsurface ##
if Pmv_2 is not None and Choose_Cmd_3 is not None:
    try:
        masterNet.connectNodes(
            Pmv_2, Choose_Cmd_3, "PMV", "viewer", blocking=True)
    except:
        print "WARNING: failed to restore connection between Pmv_2 and Choose_Cmd_3 in network masterNet"
if Choose_Cmd_3 is not None and Run_computeMSMS_4 is not None:
    try:
        masterNet.connectNodes(
            Choose_Cmd_3, Run_computeMSMS_4, "cmd", "command", blocking=True)
    except:
        print "WARNING: failed to restore connection between Choose_Cmd_3 and Run_computeMSMS_4 in network masterNet"
if Filename_5 is not None and Run_computeMSMS_4 is not None:
    try:
        masterNet.connectNodes(
            Filename_5, Run_computeMSMS_4, "filename", "surfName", blocking=True)
    except:
        print "WARNING: failed to restore connection between Filename_5 and Run_computeMSMS_4 in network masterNet"
if Select_Nodes_0 is not None and len_6 is not None:
    try:
        masterNet.connectNodes(
            Select_Nodes_0, len_6, "nodes", "in1", blocking=True)
    except:
        print "WARNING: failed to restore connection between Select_Nodes_0 and len_6 in network masterNet"
if len_6 is not None and range_7 is not None:
    try:
        masterNet.connectNodes(
            len_6, range_7, "length", "toInd", blocking=True)
    except:
        print "WARNING: failed to restore connection between len_6 and range_7 in network masterNet"
if add_8 is not None and Slice_10 is not None:
    try:
        masterNet.connectNodes(
            add_8, Slice_10, "result", "toInd", blocking=True)
    except:
        print "WARNING: failed to restore connection between add_8 and Slice_10 in network masterNet"
if iterate_11 is not None and Slice_10 is not None:
    try:
        masterNet.connectNodes(
            iterate_11, Slice_10, "oneItem", "fromInd", blocking=True)
    except:
        print "WARNING: failed to restore connection between iterate_11 and Slice_10 in network masterNet"
if Select_Nodes_0 is not None and Slice_10 is not None:
    try:
        masterNet.connectNodes(
            Select_Nodes_0, Slice_10, "nodes", "data", blocking=True)
    except:
        print "WARNING: failed to restore connection between Select_Nodes_0 and Slice_10 in network masterNet"
if Slice_10 is not None and Run_computeMSMS_4 is not None:
    try:
        masterNet.connectNodes(
            Slice_10, Run_computeMSMS_4, "data", "nodes", blocking=True)
    except:
        print "WARNING: failed to restore connection between Slice_10 and Run_computeMSMS_4 in network masterNet"
if iterate_11 is not None and Filename_5 is not None:
    try:
        masterNet.connectNodes(
            iterate_11, Filename_5, "oneItem", "number", blocking=True)
    except:
        print "WARNING: failed to restore connection between iterate_11 and Filename_5 in network masterNet"
if Stepsize_9 is not None and sub_1 is not None:
    try:
        masterNet.connectNodes(
            Stepsize_9, sub_1, "value", "data1", blocking=True)
    except:
        print "WARNING: failed to restore connection between Stepsize_9 and sub_1 in network masterNet"
if overlap_12 is not None and sub_1 is not None:
    try:
        masterNet.connectNodes(
            overlap_12, sub_1, "value", "data2", blocking=True)
    except:
        print "WARNING: failed to restore connection between overlap_12 and sub_1 in network masterNet"
if sub_1 is not None and range_7 is not None:
    try:
        masterNet.connectNodes(
            sub_1, range_7, "result", "step", blocking=True)
    except:
        print "WARNING: failed to restore connection between sub_1 and range_7 in network masterNet"
if range_7 is not None and iterate_11 is not None:
    try:
        masterNet.connectNodes(
            range_7, iterate_11, "data", "listToLoopOver", blocking=True)
    except:
        print "WARNING: failed to restore connection between range_7 and iterate_11 in network masterNet"
if iterate_11 is not None and add_8 is not None:
    try:
        masterNet.connectNodes(
            iterate_11, add_8, "oneItem", "data1", blocking=True)
    except:
        print "WARNING: failed to restore connection between iterate_11 and add_8 in network masterNet"
if Stepsize_9 is not None and add_8 is not None:
    try:
        masterNet.connectNodes(
            Stepsize_9, add_8, "value", "data2", blocking=True)
    except:
        print "WARNING: failed to restore connection between Stepsize_9 and add_8 in network masterNet"
if Pmv_Viewer_13 is not None and file00000054_png_14 is not None:
    try:
        masterNet.connectNodes(
            Pmv_Viewer_13, file00000054_png_14, "dejaVuViewer", "viewer", blocking=True)
    except:
        print "WARNING: failed to restore connection between Pmv_Viewer_13 and file00000054_png_14 in network masterNet"
if iterate_11 is not None and file00000054_png_14 is not None:
    try:
        masterNet.specialConnectNodes(
            iterate_11, file00000054_png_14, "trigger", "runNode", blocking=True)
    except:
        print "WARNING: failed to restore connection between iterate_11 and file00000054_png_14 in network masterNet"
if Pmv_Viewer_13 is not None and TF_1_15 is not None:
    try:
        masterNet.connectNodes(
            Pmv_Viewer_13, TF_1_15, "dejaVuViewer", "viewer", blocking=True)
    except:
        print "WARNING: failed to restore connection between Pmv_Viewer_13 and TF_1_15 in network masterNet"
if file00000054_png_14 is not None and Reparent_Geom_16 is not None:
    try:
        masterNet.connectNodes(
            file00000054_png_14, Reparent_Geom_16, "geomList", "geoms", blocking=True)
    except:
        print "WARNING: failed to restore connection between file00000054_png_14 and Reparent_Geom_16 in network masterNet"
if TF_1_15 is not None and file00000054_png_14 is not None:
    try:
        masterNet.connectNodes(
            TF_1_15, file00000054_png_14, "geometry", "searchedParent", blocking=True)
    except:
        print "WARNING: failed to restore connection between TF_1_15 and file00000054_png_14 in network masterNet"
if geomContainer_18 is not None and Pmv_Viewer_17 is not None:
    try:
        masterNet.connectNodes(
            geomContainer_18, Pmv_Viewer_17, "geomContainer", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between geomContainer_18 and Pmv_Viewer_17 in network masterNet"
if TF_1_15 is not None and geomContainer_18 is not None:
    try:
        masterNet.connectNodes(
            TF_1_15, geomContainer_18, "geometry", "parent", blocking=True)
    except:
        print "WARNING: failed to restore connection between TF_1_15 and geomContainer_18 in network masterNet"
if geomContainer_18 is not None and Reparent_Geom_16 is not None:
    try:
        masterNet.connectNodes(
            geomContainer_18, Reparent_Geom_16, "geomContainer", "parent", blocking=True)
    except:
        print "WARNING: failed to restore connection between geomContainer_18 and Reparent_Geom_16 in network masterNet"
if tf_1_19 is not None and Select_Nodes_0 is not None:
    try:
        masterNet.connectNodes(
            tf_1_19, Select_Nodes_0, "Molecule", "nodes", blocking=True)
    except:
        print "WARNING: failed to restore connection between tf_1_19 and Select_Nodes_0 in network masterNet"
masterNet.unfreeze()


def loadSavedStates_Pmv_Viewer_13(self=Pmv_Viewer_13, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## Object root|misc
    ## Object root|CoarseAPBSbox
    ## Object root|FineAPBSbox
    ## Object root|tf_1
    ## Object root|misc|addBondsGeom
    ## Object root|misc|edit_geoms
    ## Object root|misc|measure_geoms
    ## Object root|misc|selectInSphereGeoms
    ## Object root|tf_1|selection
    ## Object root|tf_1|lines
    ## Object root|tf_1|AtomLabels
    ## Object root|tf_1|ResidueLabels
    ## Object root|tf_1|ChainLabels
    ## Object root|tf_1|ProteinLabels
    ## Object root|tf_1|sticks
    ## Object root|tf_1|balls
    ## Object root|tf_1|cpk
    ## Object root|tf_1|CAsticks
    ## Object root|tf_1|CAballs
    ## Object root|tf_1|file00000000.png
    ## Object root|tf_1|file00000004.png
    ## Object root|tf_1|file00000008.png
    ## Object root|tf_1|file00000012.png
    ## Object root|tf_1|file00000016.png
    ## Object root|tf_1|file00000020.png
    ## Object root|tf_1|file00000024.png
    ## Object root|tf_1|file00000028.png
    ## Object root|tf_1|file00000032.png
    ## Object root|tf_1|file00000036.png
    ## Object root|tf_1|file00000040.png
    ## Object root|tf_1|file00000044.png
    ## Object root|tf_1|file00000048.png
    ## Object root|tf_1|file00000052.png
    ## Object root|tf_1|file00000056.png
    ## Object root|tf_1|file00000060.png
    ## Object root|tf_1|file00000064.png
    ## Object root|tf_1|file00000068.png
    ## Object root|tf_1|file00000072.png
    ## Object root|tf_1|file00000076.png
    ## Object root|tf_1|file00000080.png
    ## Object root|tf_1|file00000084.png
    ## Object root|tf_1|file00000088.png
    ## Object root|tf_1|file00000092.png
    ## Object root|tf_1|file00000096.png
    ## Object root|tf_1|file00000100.png
    ## Object root|tf_1|file00000104.png
    ## Object root|tf_1|file00000108.png
    ## Object root|tf_1|file00000112.png
    ## Object root|tf_1|file00000116.png
    ## Object root|tf_1|file00000120.png
    ## Object root|tf_1|file00000124.png
    ## Object root|tf_1|file00000128.png
    ## Object root|tf_1|file00000132.png
    ## Object root|tf_1|file00000136.png
    ## Object root|tf_1|file00000140.png
    ## Object root|tf_1|file00000144.png
    ## Object root|tf_1|file00000148.png
    ## Object root|tf_1|file00000152.png
    ## Object root|tf_1|file00000156.png
    ## Object root|tf_1|file00000160.png
    ## Object root|tf_1|file00000164.png
    ## Object root|tf_1|file00000168.png
    ## Object root|tf_1|file00000172.png
    ## Object root|tf_1|file00000176.png
    ## Object root|tf_1|file00000180.png
    ## Object root|tf_1|file00000184.png
    ## Object root|tf_1|file00000188.png
    ## Object root|tf_1|file00000192.png
    ## Object root|misc|addBondsGeom|addBondsSpheres
    ## Object root|misc|edit_geoms|editAtomTypeSphere
    ## Object root|misc|edit_geoms|editAtomChargeSphere
    ## Object root|misc|measure_geoms|measureDistGeomCtrl
    ## Object root|misc|measure_geoms|measureDistGeom
    ## Object root|misc|measure_geoms|measureAngleGeom
    ## Object root|misc|measure_geoms|measureTorsionGeom
    ## Object root|misc|selectInSphereGeoms|SelSphReg_selSph
    ## Object root|misc|selectInSphereGeoms|SelSphReg_cenCross
    ## Object root|tf_1|lines|bonded
    ## Object root|tf_1|lines|nobnds
    ## Object root|tf_1|lines|bondorder
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distLine
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distLabel
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distSpheres
    ## Object root|misc|measure_geoms|measureDistGeom|distLine
    ## Object root|misc|measure_geoms|measureDistGeom|distLabel
    ## Object root|misc|measure_geoms|measureDistGeom|distSpheres
    ## Object root|misc|measure_geoms|measureAngleGeom|angleLine
    ## Object root|misc|measure_geoms|measureAngleGeom|angleLabel
    ## Object root|misc|measure_geoms|measureAngleGeom|angleSpheres
    ## Object root|misc|measure_geoms|measureAngleGeom|angles
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionLine
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionLabel
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionSpheres
    ## End Object root|misc|measure_geoms|measureTorsionGeom|torsionSpheres

    ##
    ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 624, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -162.25584411621094], 'd2cutH': 255, 'far': 411.05302559328948, 'd1off': 4, 'lookFrom': [0.0, 0.0, 162.25584411621094], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'd1scale': 0.012999999999999999}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 205.52651279664474, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 118.98517977706905, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [29.905378341674805, 16.498878479003906, 56.405982971191406], 'rotation': [0.38596192002296448, -0.83629798889160156, 0.38940849900245667, 0.0, 0.35673466324806213, 0.52458041906356812, 0.77301734685897827, 0.0, -0.85074895620346069, -0.15943977236747742, 0.50080454349517822, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-29.90538215637207, -16.498876571655273, -56.405982971191406], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Pmv_Viewer_13.restoreStates_cb = Pmv_Viewer_13.restoreStatesFirstRun = loadSavedStates_Pmv_Viewer_13
Pmv_Viewer_13.menu.add_separator()
Pmv_Viewer_13.menu.add_command(label='Restore states', command=Pmv_Viewer_13.restoreStates_cb)


def loadSavedStates_Pmv_Viewer_17(self=Pmv_Viewer_17, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## Object root|misc
    ## Object root|CoarseAPBSbox
    ## Object root|FineAPBSbox
    ## Object root|tf_1
    ## Object root|misc|addBondsGeom
    ## Object root|misc|edit_geoms
    ## Object root|misc|measure_geoms
    ## Object root|misc|selectInSphereGeoms
    ## Object root|tf_1|selection
    ## Object root|tf_1|lines
    ## Object root|tf_1|AtomLabels
    ## Object root|tf_1|ResidueLabels
    ## Object root|tf_1|ChainLabels
    ## Object root|tf_1|ProteinLabels
    ## Object root|tf_1|sticks
    ## Object root|tf_1|balls
    ## Object root|tf_1|cpk
    ## Object root|tf_1|CAsticks
    ## Object root|tf_1|CAballs
    ## Object root|tf_1|file00000000.png
    ## Object root|tf_1|file00000004.png
    ## Object root|tf_1|file00000008.png
    ## Object root|tf_1|file00000012.png
    ## Object root|tf_1|file00000016.png
    ## Object root|tf_1|file00000020.png
    ## Object root|tf_1|file00000024.png
    ## Object root|tf_1|file00000028.png
    ## Object root|tf_1|file00000032.png
    ## Object root|tf_1|file00000036.png
    ## Object root|tf_1|file00000040.png
    ## Object root|tf_1|file00000044.png
    ## Object root|tf_1|file00000048.png
    ## Object root|tf_1|file00000052.png
    ## Object root|tf_1|file00000056.png
    ## Object root|tf_1|file00000060.png
    ## Object root|tf_1|file00000064.png
    ## Object root|tf_1|file00000068.png
    ## Object root|tf_1|file00000072.png
    ## Object root|tf_1|file00000076.png
    ## Object root|tf_1|file00000080.png
    ## Object root|tf_1|file00000084.png
    ## Object root|tf_1|file00000088.png
    ## Object root|tf_1|file00000092.png
    ## Object root|tf_1|file00000096.png
    ## Object root|tf_1|file00000100.png
    ## Object root|tf_1|file00000104.png
    ## Object root|tf_1|file00000108.png
    ## Object root|tf_1|file00000112.png
    ## Object root|tf_1|file00000116.png
    ## Object root|tf_1|file00000120.png
    ## Object root|tf_1|file00000124.png
    ## Object root|tf_1|file00000128.png
    ## Object root|tf_1|file00000132.png
    ## Object root|tf_1|file00000136.png
    ## Object root|tf_1|file00000140.png
    ## Object root|tf_1|file00000144.png
    ## Object root|tf_1|file00000148.png
    ## Object root|tf_1|file00000152.png
    ## Object root|tf_1|file00000156.png
    ## Object root|tf_1|file00000160.png
    ## Object root|tf_1|file00000164.png
    ## Object root|tf_1|file00000168.png
    ## Object root|tf_1|file00000172.png
    ## Object root|tf_1|file00000176.png
    ## Object root|tf_1|file00000180.png
    ## Object root|tf_1|file00000184.png
    ## Object root|tf_1|file00000188.png
    ## Object root|tf_1|file00000192.png
    ## Object root|misc|addBondsGeom|addBondsSpheres
    ## Object root|misc|edit_geoms|editAtomTypeSphere
    ## Object root|misc|edit_geoms|editAtomChargeSphere
    ## Object root|misc|measure_geoms|measureDistGeomCtrl
    ## Object root|misc|measure_geoms|measureDistGeom
    ## Object root|misc|measure_geoms|measureAngleGeom
    ## Object root|misc|measure_geoms|measureTorsionGeom
    ## Object root|misc|selectInSphereGeoms|SelSphReg_selSph
    ## Object root|misc|selectInSphereGeoms|SelSphReg_cenCross
    ## Object root|tf_1|lines|bonded
    ## Object root|tf_1|lines|nobnds
    ## Object root|tf_1|lines|bondorder
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distLine
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distLabel
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distSpheres
    ## Object root|misc|measure_geoms|measureDistGeom|distLine
    ## Object root|misc|measure_geoms|measureDistGeom|distLabel
    ## Object root|misc|measure_geoms|measureDistGeom|distSpheres
    ## Object root|misc|measure_geoms|measureAngleGeom|angleLine
    ## Object root|misc|measure_geoms|measureAngleGeom|angleLabel
    ## Object root|misc|measure_geoms|measureAngleGeom|angleSpheres
    ## Object root|misc|measure_geoms|measureAngleGeom|angles
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionLine
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionLabel
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionSpheres
    ## End Object root|misc|measure_geoms|measureTorsionGeom|torsionSpheres

    ##
    ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 624, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -162.25584411621094], 'd2cutH': 255, 'far': 411.05302559328948, 'd1off': 4, 'lookFrom': [0.0, 0.0, 162.25584411621094], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'd1scale': 0.012999999999999999}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 205.52651279664474, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 118.98517977706905, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [29.905378341674805, 16.498878479003906, 56.405982971191406], 'rotation': [0.38596192002296448, -0.83629798889160156, 0.38940849900245667, 0.0, 0.35673466324806213, 0.52458041906356812, 0.77301734685897827, 0.0, -0.85074895620346069, -0.15943977236747742, 0.50080454349517822, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-29.90538215637207, -16.498876571655273, -56.405982971191406], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Pmv_Viewer_17.restoreStates_cb = Pmv_Viewer_17.restoreStatesFirstRun = loadSavedStates_Pmv_Viewer_17
Pmv_Viewer_17.menu.add_separator()
Pmv_Viewer_17.menu.add_command(label='Restore states', command=Pmv_Viewer_17.restoreStates_cb)

#masterNet.run()
