#!/bin/bash
gtk1=no
gtk2=no
geckosdk=yes
MOZ=`which mozilla`
MOZHOME=`grep MOZILLA_FIVE_HOME= ${MOZ} | awk  -F \" '{ print $2 }'`
if [ -z ${MOZHOME} ]; then MOZHOME=`grep moz_libdir= ${MOZ} | awk  -F \" '{ print $2 }'`; fi
if [ -z ${MOZHOME} ]; then MOZHOME=`grep moz_libdir= ${MOZ} | nawk  -F \= '{ print $2 }'`; fi
if [ -z ${MOZHOME} ]; then echo "Can't find MOZILLA HOME. Please install manually"; exit 1; fi
if [ `ldd ${MOZHOME}/mozilla-bin | grep gtk-x11 | wc -l` != 0 ]; then gtk2=yes; fi
if [ `ldd ${MOZHOME}/mozilla-bin | grep gtk-1 | wc -l` != 0 ]; then gtk1=yes; fi
pkg-config --exists mozilla-plugin
if [ $? == 0 ]; then geckosdk=no; fi

echo "Run configure with the following options"
echo ""
echo -n "./configure"
if [ $gtk1 == yes ]; then echo -n " --enable-gtk1"; fi
if [ $gtk2 == no -a $gtk1 == no ]; then echo -n " --enable-x"; fi
if [ $geckosdk == yes ]; then echo " --with-gecko-sdk={path to gecko sdk}"; echo ; echo "You need to install the gecko-sdk"; fi
echo 



