<?php
/**
 * An OpenSearch system for suggesting program names from the firefox toolbar
 *
 * @url         $URL: http://svn.mythtv.org/svn/branches/release-0-21-fixes/mythplugins/mythweb/modules/tv/opensearch.php $
 * @date        $Date: 2007-12-31 14:38:38 -0600 (Mon, 31 Dec 2007) $
 * @version     $Revision: 15274 $
 * @author      $Author: xris $
 * @license     GPL
 *
 * @package     MythWeb
 * @subpackage  TV
 *
/**/

// Requesting information about the search query itself
    if ($_REQUEST['type'] == 'xml') {
        header("Content-Type: application/xml");
        echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
?>
<OpenSearchDescription xmlns="http://a9.com/-/spec/opensearch/1.1/">
    <ShortName>MythTV</ShortName>
    <Description>Search MythTV</Description>
    <Url type="application/x-suggestions+json"
         method="GET"
         template="http://<?php echo $_SERVER['SERVER_NAME'], root?>tv/opensearch?type=suggest&amp;search={searchTerms}">
    </Url>
    <Url type="text/html"
         method="GET"
         template="http://<?php echo $_SERVER['SERVER_NAME'], root?>tv/search/?type=q&amp;search=Search&amp;s={searchTerms}">
    </Url>
    <Image height="16" width="16" type="image/png">http://<?php echo $_SERVER['SERVER_NAME'], skin_url ?>img/favicon.ico</Image>
</OpenSearchDescription>
<?php
    }

// Requesting a search suggestion
    elseif ($_REQUEST['type'] == 'suggest') {
    // Error notification
        if (!isset($_REQUEST['search'])) {
            echo "ERROR: Must have a search term";
            exit;
        }
    // Do a basic query for similar program titles
        $matches = $db->query_list('SELECT DISTINCT title
                                      FROM program
                                     WHERE title LIKE ?
                                  ORDER BY title
                                     LIMIT 10',
                                   $_REQUEST['search'].'%');
    // Print the list of found suggestions
        $comma = false;
        echo '["', addslashes($_REQUEST['search']), '",[';
        foreach ($matches as $match) {
            if ($comma)
                echo ',';
            else
                $comma = true;
            echo '"', addslashes($match),'"';
        }
        echo ']]';
    }

// Done
    exit;

