/* ============================================================
 * File  : harvester.h
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : 2004-03-08
 * Description : harvester scans url for streams
 *
 * Copyright 2003 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#include <iostream>
#include <qobject.h>
#include <qptrlist.h>
#include <qfile.h>
#include <qstring.h>


using namespace std;

bool readTextFile(QString fileName, QString *data);

//------------------------------------------------------------------

class NewUrl : public QObject
{
  public:
    NewUrl(QString& nUrl, QString& nName, QString& nDescr);

    QString url;
    QString name;
    QString descr;
    QString handler;

    // must add meta node fields here (name, content, viewer)
};

typedef QPtrList<NewUrl> UrlList;

//------------------------------------------------------------------

class Parser : public QObject
{

  public:
    Parser();
    ~Parser();
    
    UrlList* parse(QString &data);
    
    QString *source;

  private:
    void run();
    UrlList list;
};




