/* ============================================================
 * File  : configelements.cpp
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : 2003-12-22
 * Description :
 *
 *
 * Copyright 2003 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// development snapshot, many todo's

#include <iostream>
#include <qlayout.h>
#include <qcursor.h>
#include <qregexp.h>

#include "configelements.h"

using namespace std;

// ---------------------------------------------------

CurrentStream::CurrentStream(QString url, QString name, QString descr, QString handler) : QObject()
{
   this->url   = url;
   this->name  = name;
   this->descr = descr;
   this->handler = handler;
}

CurrentStream::~CurrentStream() {}

// ---------------------------------------------------

ConfigButton::ConfigButton( const QString& text, QWidget * parent )
            : QPushButton( text, parent )
{
    setEnabled(false);
    QFontMetrics metric( font() );
    int maxHeight = metric.height() + 2;
    setMaximumHeight(maxHeight);
}


// ---------------------------------------------------

FolderItem::FolderItem(QListView* parent, QString folderName)
          : QListViewItem(parent, folderName)
{
  folder = folderName;
}


StationItem::StationItem(QListViewItem* parent, QString name)
           : QListViewItem(parent, name)
{
}


RepositoryItem::RepositoryItem(QListView* parent, StreamStorage::AccessType stype)
              : QListViewItem(parent, "")
{
   type   = stype;
}

// ------------------- Edit group box --------------------

EditGroup::EditGroup(char* title, QWidget* parent) : QVGroupBox(title, parent)
{
    myParent = parent;
    setPalette(parent->palette());
    setFont(parent->font());
    setBackgroundOrigin(QWidget::WindowOrigin);
    setInsideMargin(4);
    setInsideSpacing(1);
    
    linkedItem = 0;
}

void EditGroup::buildGroup(int boxes)
{
    QFontMetrics metric( font() );
    int maxHeight = metric.height();

    MythLineEdit *tmp;
     
    setTitle( boxIdleTitle );
    QLabel *lab;
    boxCount = boxes;

    for ( int i = 0; i < boxes; i++ )
    {
      lab = new QLabel( "", this, "label" + QString::number(i) );
      lab->setBackgroundOrigin(QWidget::WindowOrigin);
      lab->setMaximumHeight(maxHeight);
      tmp = new MythLineEdit(this, "edit" + QString::number(i));
      tmp->setPopupPosition(VK_POSTOPDIALOG);
    }
    
   // QHBoxLayout *hbox = new QHBoxLayout(this, 5);

    updateButton = new ConfigButton("&Update", this);
    removeButton = new ConfigButton("&Remove", this);

  //  hbox->addWidget(updateButton, 1);
  //  hbox->addWidget(removeButton, 1);
    
    removeButton->setEnabled(false);

    connect(updateButton, SIGNAL(clicked()), this, SLOT(slotUpdateClicked()));
    connect(removeButton, SIGNAL(clicked()), this, SLOT(slotRemoveClicked()));

    setStatus(idle);
}

EditGroup::~EditGroup()
{

}

QLabel* EditGroup::getLabel(QString name)
{
   return dynamic_cast<QLabel*>( child(name, "QLabel", false) );
}

MythLineEdit* EditGroup::getLineEdit(QString name)
{
   return dynamic_cast<MythLineEdit*>( child(name, "MythLineEdit", false) );
}

void EditGroup::setStatus(Status stat)
{
  status = stat;
  if (stat == add)
  {
    setTitle(boxAddTitle);
    removeButton->setEnabled(false);
    updateButton->setEnabled(true);
    updateButton->setText("&Add");
    linkedItem = 0;
  }

  if (stat == edit)
  {
    setTitle(boxEditTitle);
    removeButton->setEnabled(true);
    updateButton->setEnabled(true);
    updateButton->setText("&Update");
  }

  if (stat == idle)
  {
    setTitle(boxIdleTitle);
    removeButton->setEnabled(false);
    updateButton->setEnabled(false);
    updateButton->setText("&Add");
    for ( int i = 0; i < boxCount; i++ )
    {
      MythLineEdit *box = getLineEdit("edit" + QString::number(i));
      if (box)
        box->setText("");
    }
    setTitle(boxIdleTitle);
    linkedItem = 0;
  }

}

void EditGroup::slotUpdateClicked()
{
    commitFields();
}

void EditGroup::slotRemoveClicked()
{
    removeLinked();
}


