/* ============================================================
 * File  : streamconfig.cpp
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : 2003-12-22
 * Description : mythtv compatibility parts copied from mythnews
 *               plugin source, mythnews copyright Renchi Raju
 *
 * Copyright 2003 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// development snapshot, many todo's

#ifndef CONFIGELEMENTS_H
#define CONFIGELEMENTS_H

#include <qdialog.h>
#include <qlistview.h>

#ifdef MYTHTV
#include <mythtv/mythwidgets.h>
#include <mythtv/virtualkeyboard.h>
#else
#include <qlineedit.h>
#endif

#include <qlabel.h>
#include <qvgroupbox.h>
#include <qpushbutton.h>
#include <qtabwidget.h>

#include "streamstorage.h"
#include "configelements.h"

// storage caller identifiers
    static const int ident_streambrowser = 101;
    static const int ident_streamconfig  = 102;
    static const int ident_storageconfig = 103;
    static const int ident_storagegroup  = 104;
    static const int ident_recorder      = 105;


// storage value indexes
    static const int r_selected  = 0;
    static const int r_type      = 1;
    static const int r_name      = 2;

    static const int r_file_file = 3;

    static const int r_db_host   = 3;
    static const int r_db_port   = 4;
    static const int r_db_db     = 5;
    static const int r_db_table  = 6;
    static const int r_db_login  = 7;
    static const int r_db_pass   = 8;

    static const int r_web_url   = 3;
    static const int r_web_login = 4;
    static const int r_web_pass  = 5;

// storage value count
    static const unsigned int r_count_file = 4;
    static const unsigned int r_count_db   = 9;
    static const unsigned int r_count_web  = 6;

// stream value indexes
    static const unsigned int s_folder  = 0;
    static const unsigned int s_name    = 1;
    static const unsigned int s_url     = 2;
    static const unsigned int s_descr   = 3;
    static const unsigned int s_handler = 4;

enum Command       
{              
    nada = 0,
    previtem,
    nextitem,
    prevfolder,
    nextfolder,
    selectitem,
    escape,
    end,
    dump,
    fullscreen,
    pauseitem,
    record,
    stoprecord,
    stopallrecord,
    voldn,
    volup,
    mute,
    forwardstream,
    rewindstream,
    mark,
    storemarked,
    inspect,
    avdec,   // A/V sync slow audio
    avinc    // A/V sync slow video
};    

class CurrentStream : public QObject
{
  Q_OBJECT
  
  public:
    CurrentStream(QString url, QString name, QString descr, QString handler);
    ~CurrentStream();
    
    QString url;
    QString name;
    QString descr;
    QString handler;
};

// ---------------------------------------------------

class ConfigButton : public QPushButton
{
  public:
    ConfigButton( const QString& text, QWidget * parent );
};

// ---------------------------------------------------

class FolderItem : public QListViewItem
{
  public:
    FolderItem(QListView* parent, QString folderName);

    QString folder;
};


// ---------------------------------------------------

class StationItem : public QListViewItem
{
  public:
    StationItem(QListViewItem* parent, QString name);

    QString folder;
    QString name;
    QString url;
    QString descr;
    QString handler;
};


// ---------------------------------------------------

class RepositoryItem : public QListViewItem
{
  public:
    RepositoryItem(QListView* parent, StreamStorage::AccessType stype);

    StreamStorage::AccessType type;
    ValueList values;
};

class EditGroup : public QVGroupBox
{
    Q_OBJECT

  public:
    enum Status
    {
        add = 0,
        edit,
        idle
    };

    EditGroup(char* title, QWidget* parent);
    ~EditGroup();

    void buildGroup(int boxes);
    void setStatus(Status stat);
    QLabel* getLabel(QString name);
    MythLineEdit* getLineEdit(QString name);

    int boxCount;

  private slots:
    void slotUpdateClicked();
    void slotRemoveClicked();

  protected:
    QString boxAddTitle;
    QString boxEditTitle;
    QString boxIdleTitle;

    virtual void initFields(QListViewItem* item) = 0;
    virtual void removeLinked() = 0;
    virtual void commitFields() = 0;

    QWidget* myParent;

    QListViewItem *linkedItem;

    ConfigButton *removeButton;
    ConfigButton *updateButton;

    Status status;
};

#endif /* CONFIGELEMENTS_H */
