/* ============================================================
 * File  : streamconfig.cpp
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : 2003-12-22
 * Description : mythtv compatibility parts copied from mythnews
 *               plugin source, mythnews copyright Renchi Raju
 *
 * Copyright 2003 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// development snapshot, many todo's

#ifndef STREAMCONFIG_H
#define STREAMCONFIG_H

#include <qdialog.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qvgroupbox.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qcombobox.h>
#include <qapplication.h>

#include "streamstorage.h"
#include "configelements.h"
#include "storageconfig.h" // for main widget

#ifdef MYTHTV
#include <mythtv/mythdialogs.h>
#include <mythtv/mythwidgets.h>
#endif

class StreamConfig;
class StreamEditGroup;

#ifdef MYTHTV
typedef MythDialog BaseWidget;
typedef MythMainWindow BaseParent;
#else
typedef QWidget BaseWidget;
typedef QWidget BaseParent;
#endif

class StorageGroup : public QVGroupBox
{
    Q_OBJECT

  public:
    StorageGroup(char* title, QWidget* parent, ReposStorage *storageStorage, StreamStorage *streamStorage);
    ~StorageGroup();

  public slots:
    void slotLoadClicked();
    void slotOverwriteClicked();

    void slotStreamStorageEvent(int ident, int eventType, bool error);

    void slotStorageEvent(int ident, int eventType, bool error);
    void slotRecordInserted(ChangedRecord *rec);
    void slotRecordUpdated(ChangedRecord *rec);
    void slotRecordRemoved(ChangedRecord *rec);

    void slotBoxActivated(const QString& selectedText);

  private:
    QWidget       *myParent;
    ReposStorage *storages;
    StreamStorage *streams;

    QComboBox *storageBox;
    QString activeStorage;
    bool rollback;
    QString rollbackReason;

    QLabel *loadedStorageLabel;
    QLabel *syncLabel;

    ConfigButton *loadButton;
    ConfigButton *overwriteButton;

    // Helpers
    bool getStorageValuesByName(ValueList& values, const QString& storageName);

    // GUI
    void buildGroup();
    void synchronized(bool sync); // sync=false: new storage is selected but contents not loaded
    void fillStorageBox();
    void reportMessage(const QString& message, bool bad);
};

class Readme : public BaseWidget
{
  Q_OBJECT

  public:
    Readme(BaseParent *parent, const char *name);
};

/*
class StreamSettings : public BaseWidget
{
  Q_OBJECT

  public:
    StreamSettings(BaseParent *parent, const char *name);
};
*/

// main widget
class StreamTunedConfig : public QTabWidget
{
    Q_OBJECT

  public:
    StreamTunedConfig( QWidget *parent, const char *name = 0, StreamStorage *storage = 0,
                        ReposStorage *storageBin = 0 );
    ~StreamTunedConfig();

  private:
    StreamConfig *streamConfig;
    StorageConfig *storageConfig;
};


// stream tab
class StreamConfig : public BaseWidget
{
    Q_OBJECT

  public:
    StreamConfig( BaseParent *parent, const char *name = 0, StreamStorage *storage = 0,
                  ReposStorage *storageBin = 0 );
    ~StreamConfig();

    StationItem* initStation(const QString& folder, const QString& name,
                             const QString& url, const QString& descr, const QString& handler);
    void updateStation(StationItem* station, const QString& folder, const QString& name,
                       const QString& url, const QString& descr, const QString& handler);
    void createStation(const QString& folder, const QString& name,
                       const QString& url, const QString& descr, const QString& handler);
    void removeStation(StationItem* station);

    void reportMessage(const QString& error, bool bad);


  private:
    bool getStationsFromDB();
    void loadDefaultStations();
    void setupView();
    void assignFolder(StationItem* station, const QString& folder);

    FolderItem* getFolderItem(QString folder);
    StationItem* getStationItem(FolderItem* folder, QString station);
    FolderItem* forceFolder(const QString& folder);

    StreamStorage *streamStorage;
    ReposStorage *storageStorage;

    QListView       *m_leftView;
    StreamEditGroup *streamEditGroup;
    StorageGroup    *storageGroup;

    MythLineEdit* m_folderEdit;
    MythLineEdit* m_nameEdit;
    MythLineEdit* m_urlEdit;
    MythLineEdit* m_descrEdit;
    QLabel*    errorLabel;

  public slots:
    void slotRecordInserted(ChangedRecord *rec);
    void slotRecordUpdated(ChangedRecord *rec);
    void slotRecordRemoved(ChangedRecord *rec);
    void slotStorageEvent(int ident, int eventType, bool error);

  private slots:
    void itemSelected(QListViewItem *item);
};


#endif /* STREAMCONFIG_H */
