/* ============================================================
 * File  : streamstatus.h
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : 2003-12-22
 * Description : av stream handling
 *
 * Copyright 2003 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// development snapshot, many todo's

#ifndef STREAMSTATUS_H
#define STREAMSTATUS_H

#include <iostream>

#include <qnetwork.h>
#include <qdatetime.h>
#include <qpainter.h>
#include <qdir.h>
#include <qtimer.h>
#include <qprocess.h>
#include <qstringlist.h>
#include <qdict.h>
#include <qwidget.h>

#include "playerencap.h"
#include "configelements.h"

class VideoContainer : public QWidget
{
  Q_OBJECT

  public:
     VideoContainer(QWidget *parent, const char *name, WFlags f);
     QString getVidWindowId();
     int getMyWindowId();

};

class StreamStatus : public QObject
{
  Q_OBJECT

  public:

    enum Status
    {
      none = 0,
      idle,
      starting,
      videoinit,
      buffering,
      playing,
      paused,
      stopping,
      stopped,
      failed,
      nostream
    };

    enum StreamInfo
    {
      StreamTime = 0,
      StreamCache,
      StreamStability,
      StreamFilename,
      StreamAudioCodec,
      StreamAudioFormat,
      StreamVideoFormat,
      StreamBitrate,
      StreamRate,
      StreamChannels,
      StreamVideoBitrate,
      StreamVideoFps,
      StreamVideoCodec,
      StreamLength,
      StreamVolume
    };

    enum StreamCommand
    {
      VolumeUp = 0,
      VolumeDn,
      Forward,
      Rewind,
      Mute,
      Pause,
      FullScreen,
      AVInc,
      AVDec,
      DefaultScreen
    };

    StreamStatus(QObject* parent);
    ~StreamStatus();

    void setVideoContainer(VideoContainer *vid);
    void setVideoRect(QRect& rect);
    void setVideoMaxRect(QRect& rect);

    Status&  getStatus();
    bool     isVideo();
    QString& getStatusString();
    QString& getStreamUrl();
    QString& getStreamName();
    QString& getStreamDescr();
    QString& getStreamHandler();
    QString& getLastPlayedUrl();
    QString& getLastPlayedName();
    QString& getLastPlayedDescr();
    QString& getLastPlayedHandler();
    QString& getLastPlayedConsole();
    
    void appendLastPlayedConsole(QString line);
    
    QString  getStreamInfo(StreamInfo info);
    QString  getCustomStreamInfo(const QString& info);
    bool     checkCustomStreamInfoExists(const QString& info);
    QString  getCustomStreamArea(const QString& info);
    QString  getCustomStreamTitle(const QString& info);

    const QString getStreamStability();

    void initStream(QString url, QString name, QString descr, QString handler);
    void stopStream();
    void issueCommand(StreamCommand command);
    void toggleFullScreen();
    
  private slots:
    void streamExited();
    void readFromStdout();
    void readFromStderr();
    void timerEvent();

  signals:
    void pollSignal();
    void statusChange();

  private:
    void reset();
    void startStream();
    void playerCommand(QString command);

    QString getVideoWindowId();
    bool isPending();

    void setStatus(Status stat);
    void parsePlayerOutput(const QString msg);
    void reportStreamCache(QString& cacheValue);

    VideoContainer* m_videoContainer;
    QRect m_videorect;
    QRect m_videomaxrect;
    bool videoSet();

    QObject *myParent;
    QProcess *proc;

    QString streamUrl, pendingUrl;
    QString streamName, pendingName;
    QString streamDescr, pendingDescr;
    QString streamHandler, pendingHandler;

    QString lastPlayedUrl;
    QString lastPlayedName;
    QString lastPlayedDescr;
    QString lastPlayedHandler;
    QString lastPlayedConsole;
    
    CurrentStream *pendingStream, *startedStream;
    bool pending;

    QString statusString;      // status information
    Status status;             // stream status
    int setIdleOnZero;         // timer ticks before info window reset

    int cacheval[50];          // cache usage history
    int cacheind;              // last cache push location

    bool video;                // current stream is video
    bool m_fullscreen;
    
    PlayerEncap* playerEncap;
};


#endif /* STREAMSTATUS_H */





