/* ============================================================
 * File  : streambrowser.h
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : 2003-12-22
 * Description : av stream repository handling
 *
 * Copyright 2003 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// development snapshot, many todo's

#ifndef STREAMSTORAGE_H
#define STREAMSTORAGE_H

#include <iostream>
#include <qwidget.h>
#include <qdatetime.h>
#include <qprocess.h>
#include <qhttp.h>
#include <qvaluevector.h>


#include "storage.h"

// Open reposstorage first: it creates default files on first run

class StreamStorage : public Storage
{
  public:
    StreamStorage(QString table = "", QString name = "") : Storage(table, name) {}

    bool selectStorage(int ident, ValueList& values);
};

class ReposStorage : public Storage
{
  public:
    ReposStorage();
    bool openRepository(); // opens the stream storage repository (containing stream storages)
    
    // warning: closes open storage, opens default storage
    bool getDefaultRepository(ValueList& values);
    
    bool getStorageValuesByName(ValueList& values, const QString& storageName);    
    
    //used by streamconfig
    bool openStorage(StreamStorage *streams, int ident, ValueList& values, QString& errorMessage);
    
    bool checkParsers(); // (stream list parsers) should be somewhere else

    bool oldParserMoved;
  private:
    bool filesDiffer(const QString& source, const QString& dest);
    bool copyFile(const QString& source, const QString& dest);
    bool copyFiles(const QString& sourceDir, const QString& destDir);
    bool createStorageRepos(const QString& dest, const QString& path);

};


#endif /* STREAMSTORAGE_H */
