#! /usr/bin/perl
#* ============================================================
# * File        : omroep/mediaurl.pl
# * Version     : 0.1
# * Author      : Eric
# * Date        : 2006-09-11
# * Description: parser for omroep/medialist.pl
# *
# * Requires:
# * - mythstream v0.17_2
# * - omroep/medialist.pl
# *
# *  
# * ============================================================ */

use English;
use XML::DOM;
use HTML::Entities;

#------------------------------------------------------------------------------
# Init
#------------------------------------------------------------------------------

&read_parse();    # get commandline parameters into @in
$source = $in[0]; # source filename from command line

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

#------------------------------------------------------------------------------
# read file into $data
#------------------------------------------------------------------------------

$datafile = $source;
open( INFO, "<$datafile" );      # Open file for reading
undef $/;
$data = <INFO>;                 # Read all
close(INFO);

#------------------------------------------------------------------------------
# Parse playlist
#------------------------------------------------------------------------------

## var omroep = "AVRO";
## var naam = "AVRO Dierenpark Artis";

## var mediaurl = "http://cgi.omroep.nl/cgi-bin/streams?/tv/avro/dierenparkartis/bb.20060512.asf";
    

##     <div class="metainfo" id="metainfo">
##           <div class="gidsinformatie" id="tab1">
## 
##             <img src="http://gids.omroep.nl/gfx/afbeelding/2006-03/160x120_olifantartis.png" />
##       
##       <h3>AVRO Dierenpark Artis</h3>
##       <h4></h4>
## 
##       <div id="rating">
## 
##       </div>
## 
##       <p>De chimpansees en gorilla Akili worden getest op tuberculose. Presentatie: Anniko van Santen.</p>


sub dump_lines
{
  @lines = split ( "\n", $data);
  foreach $line(@lines)
  {

    if (@matches = ( $line =~ m/var\snaam\s=\s"(.*)"/ ) )
    {
      $name = @matches[0];
    }
      
    if (@matches = ( $line =~ m/var\smediaurl\s=\s"(.*)"/ ) )
    {
      ##$country  = @matches[0];
      ##$language = @matches[1];
      ##$name     = @matches[2];
      
      ##@matches = ( $prevLine =~ m/file\d+=(.*)$/ );
      $url = @matches[0];
      
      $item = $doc->createElement('item');
      $root->appendChild($item);

      $name = decode_entities($name);
     
      $item->appendChild( newNode('name', $name) );
      $item->appendChild( newNode('url', $url) );
      $item->appendChild( newNode('descr', "Uitzending gemist: $name") );
      $item->appendChild( newNode('handler', "default") );
        
      # This action meta node requires the stations stationid, not yet present in
      # ubustream or pls format
      # When user selects "mark as nonfunctional", MythStream performs that action,
      # and displays a message based on the server response.
      
        #$stationid = ""; 
        #$meta = $doc->createElement('meta');
        #$meta->appendChild( newNode('name'   , 'action: mark as nonfunctional') );
        #$meta->appendChild( newNode('content', "wwmp/wwmp_act|marknf|$stationid") );
        #$meta->appendChild( newNode('viewer' , 'url') );
        #$item->appendChild( $meta );
    }

    ## $prevLine = $line;
  }
}

#------------------------------------------------------------------------------
# search url's in $data and place them in special format
#------------------------------------------------------------------------------

&dump_lines();

print $head->toString;
print $root->toString;
print "\n";

#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse 
{
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}



