#! /usr/bin/perl
#* ============================================================
# * File  : omroep/program_menu.pl
# * Author: Eric
# * Date  : 2006-09-30
# * Description: interactive menu to query www.uitzendinggemist.nl
# *              (episode history)
# *
# * Requires:
# * - mythstream v0.17_2
# * - omroep/menu_genres.txt
# * - omroep/menu_omroep.txt
# * - omroep/programlist.pl
# * - omroep/programurl.pl
# *
# * To use this parser
# *  add this stream item in MythStream:
# *      Stream Name   : Uitzending gemist programma's
# *      Stream URL    : http://www.uitzendinggemist.nl/
# *      Stream Handler: omroep/program_menu
# * ============================================================ */

   
    
use English;
use XML::Simple;
use XML::DOM;

$xml = new XML::Simple;

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

my $stage  = 0;  # menu level
my $choice = "";  # choice in last menu
my $path   = "";  # | separated values based on previous choices

my $alphid = 0; # helper index

sub decodeFakeURL
{
  local $url  = shift;    # fake url: http://fake#[stage]#[path]#[choice]
  $url = substr($url, 7);
  ($fake, $stage, $path, $choice) = split('#', $url);

  if ($fake ne 'fake')
  {
    $stage  = 0;
    $choice = "";
    $path   = "";
  }

  # print "\n $stage, $path, $choice \n";
}

#------------------------------------------------------------------------------
# Init and Run
#------------------------------------------------------------------------------

  &read_parse();    # get commandline parameters into @in
  
  @alph      = split( / */, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ');
  
  $urlPrefix = "http://fake";
  
  $source = $in[0]; # source filename from command line
  $url    = $in[1];
  decodeFakeURL($url); # get stage, path and choice
  

  if ($stage == 0)
  {
    
    $item = $doc->createElement('item');
    $root->appendChild($item);
    $item->appendChild( newNode('name' , 'Zoek op titel') );
    $item->appendChild( newNode('url'  , "$urlPrefix#1#titel#") );
    $item->appendChild( newNode('descr', 'Zoek op titel' ) );
    $item->appendChild( newNode('handler', '*omroep/program_menu' ) );

    $item = $doc->createElement('item');
    $root->appendChild($item);
    $item->appendChild( newNode('name' , 'Zoek op omroep') );
    $item->appendChild( newNode('url'  , "$urlPrefix#2#omroep#") );
    $item->appendChild( newNode('descr', 'Zoek op omroep' ) );
    $item->appendChild( newNode('handler', '*omroep/program_menu' ) );
  
    $item = $doc->createElement('item');
    $root->appendChild($item);
    $item->appendChild( newNode('name' , 'Zoek op genre') );
    $item->appendChild( newNode('url'  , "$urlPrefix#3#genre#") );
    $item->appendChild( newNode('descr', 'Zoek op genre' ) );
    $item->appendChild( newNode('handler', '*omroep/program_menu' ) );
  }
  elsif ($stage == 1)
  {
    
    $item = $doc->createElement('item');
    $root->appendChild($item);
    $item->appendChild( newNode('name' , 'Uitzending gemist, alle titels') );
    $item->appendChild( newNode('url'  , "$urlPrefix#4#$path|all#") );
    $item->appendChild( newNode('descr', 'Alle titels' ) );
    $item->appendChild( newNode('handler', '*omroep/program_menu' ) );

    $alphid = 0;
    
    foreach $alph (@alph)
    {
      $alphid++;   
      $item = $doc->createElement('item');
      $root->appendChild($item);
      $item->appendChild( newNode('name' , 'Uitzending gemist, titel begint met ' . $alph) );
      $item->appendChild( newNode('url'  , "$urlPrefix#4#$path|$alphid#") );
      $item->appendChild( newNode('descr', 'Titel ' . $alph . '...' ) );
      $item->appendChild( newNode('handler', '*omroep/program_menu' ) );
    }

  }
  elsif ($stage == 2)
  {
    
    open( FD, "<omroep/menu_omroep.txt" );
    @list = <FD>;
    close FD;

    $item = $doc->createElement('item');
    $root->appendChild($item);
    $item->appendChild( newNode('name' , 'Uitzending gemist, alle omroepen') );
    $item->appendChild( newNode('url'  , "$urlPrefix#4#$path|all#") );
    $item->appendChild( newNode('descr', 'Selecteer alle omroepen' ) );
    $item->appendChild( newNode('handler', '*omroep/program_menu' ) );

    foreach $line (@list)
    {
      ($id, $value) = split(',', $line);
      $item = $doc->createElement('item');
      $root->appendChild($item);
      $item->appendChild( newNode('name' , $value) );
      $item->appendChild( newNode('url'  , "$urlPrefix#4#$path|$id#") );
      $item->appendChild( newNode('descr', 'Select ' . $value ) );
      $item->appendChild( newNode('handler', '*omroep/program_menu' ) );
    }


  }
  elsif ($stage == 3)
  {
  
    open( FD, "<omroep/menu_genres.txt" );
    @list = <FD>;
    close FD;
  
    $item = $doc->createElement('item');
    $root->appendChild($item);
    $item->appendChild( newNode('name' , 'Uitzending gemist, alle genres') );
    $item->appendChild( newNode('url'  , "$urlPrefix#4#$path|all#") );
    $item->appendChild( newNode('descr', 'Selecteer alle genres' ) );
    $item->appendChild( newNode('handler', '*omroep/program_menu' ) );

    foreach $line (@list)
    {
      ($id, $value) = split(',', $line);
      $item = $doc->createElement('item');
      $root->appendChild($item);
      $item->appendChild( newNode('name' , $value) );
      $item->appendChild( newNode('url'  , "$urlPrefix#4#$path|$id#") );
      $item->appendChild( newNode('descr', 'Select ' . $value ) );
      $item->appendChild( newNode('handler', '*omroep/program_menu' ) );
    }

  }
  elsif ($stage == 4)
  {

# http://www.uitzendinggemist.nl/index.php/selectie?searchitem=titel&qs_uitzending=&titel=3&dag=&net_zender=&omroep=&genre=
    
    ($searchitem, $value) = split('\|', $path);

    $urlbase = 'http://www.uitzendinggemist.nl/index.php/selectie?searchitem=';

    $item = $doc->createElement('item');
    $root->appendChild($item);
    $item->appendChild( newNode('name' , 'Uitzending gemist: resultaten') );
    $item->appendChild( newNode('url'  , $urlbase . $searchitem . "&$searchitem=" . $value) );
    $item->appendChild( newNode('descr', 'omroep.nl query' ) );
    $item->appendChild( newNode('handler', 'omroep/programlist' ) );
  }
  
print $head->toString;
print $root->toString;
print "\n";

#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse {
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}


