/* ============================================================
 * File  : streamstatus.h
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : 2003-12-22
 * Description : av stream handling
 *
 * Copyright 2003 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// development snapshot, many todo's

#ifndef SPEECHPROC_H
#define SPEECHPROC_H

#include <iostream>

#include <qnetwork.h>
#include <qdatetime.h>
#include <qpainter.h>
#include <qdir.h>
#include <qtimer.h>
#include <qprocess.h>
#include <qstringlist.h>
#include <qdict.h>
#include <qwidget.h>


class SpeechProc : public QObject
{
  Q_OBJECT

  public:

    SpeechProc(QObject* parent);
    ~SpeechProc();

    void startService();
    void enable(bool on);
    
    bool isEnabled();

    void say(QString text);
    void stopSay();
    
  private slots:
    void serviceExited();
    void readFromStdout();
    void readFromStderr();
    void timerEvent();

  private:
    QObject *myParent;
    QProcess *proc;
    QString pendingSay;
    
    bool enabled;
    bool busy;
};


#endif /* SPEECHPROC_H */





