// -*- Mode: c++ -*-
// Copyright (c) 2003-2004, Daniel Thor Kristjansson
#include <qstring.h>
#include <qmap.h>

/** Note: this file takes a long time to compile. **/

/*
  Generated from
    http://www.loc.gov/standards/iso639-2/ascii_8bits.html
  using awk script:
    cat ISO-639-2_values_8bits.txt | \
      awk -F'|' '{printf "  names[iso639_2toInt(\"%s\")] = QString(\"%s\");\n", $1, $4}'
*/
QMap<int, QString> codes2names;
static inline int iso639_2toInt(const unsigned char *iso639_2) {
    return (iso639_2[0]<<16)|(iso639_2[1]<<8)|iso639_2[2];
}
static inline int iso639_2toInt(const char *iso639_2) {
    return iso639_2toInt((const unsigned char*)iso639_2);
}

static int createCodeToEnglishNamesMap(QMap<int, QString>& names) {
  names[iso639_2toInt("aar")] = QString("Afar");
  names[iso639_2toInt("abk")] = QString("Abkhazian");
  names[iso639_2toInt("ace")] = QString("Achinese");
  names[iso639_2toInt("ach")] = QString("Acoli");
  names[iso639_2toInt("ada")] = QString("Adangme");
  names[iso639_2toInt("ady")] = QString("Adyghe; Adygei");
  names[iso639_2toInt("afa")] = QString("Afro-Asiatic (Other)");
  names[iso639_2toInt("afh")] = QString("Afrihili");
  names[iso639_2toInt("afr")] = QString("Afrikaans");
  names[iso639_2toInt("aka")] = QString("Akan");
  names[iso639_2toInt("akk")] = QString("Akkadian");
  names[iso639_2toInt("alb")] = QString("Albanian");
  names[iso639_2toInt("alb")] = QString("Albanian");
  names[iso639_2toInt("ale")] = QString("Aleut");
  names[iso639_2toInt("alg")] = QString("Algonquian languages");
  names[iso639_2toInt("amh")] = QString("Amharic");
  names[iso639_2toInt("ang")] = QString("Old English (ca.450-1100)");
  names[iso639_2toInt("apa")] = QString("Apache languages");
  names[iso639_2toInt("ara")] = QString("Arabic");
  names[iso639_2toInt("arc")] = QString("Aramaic");
  names[iso639_2toInt("arg")] = QString("Aragonese");
  names[iso639_2toInt("arm")] = QString("Armenian");
  names[iso639_2toInt("arm")] = QString("Armenian");
  names[iso639_2toInt("arn")] = QString("Araucanian");
  names[iso639_2toInt("arp")] = QString("Arapaho");
  names[iso639_2toInt("art")] = QString("Artificial (Other)");
  names[iso639_2toInt("arw")] = QString("Arawak");
  names[iso639_2toInt("asm")] = QString("Assamese");
  names[iso639_2toInt("ast")] = QString("Asturian; Bable");
  names[iso639_2toInt("ath")] = QString("Athapascan languages");
  names[iso639_2toInt("aus")] = QString("Australian languages");
  names[iso639_2toInt("ava")] = QString("Avaric");
  names[iso639_2toInt("ave")] = QString("Avestan");
  names[iso639_2toInt("awa")] = QString("Awadhi");
  names[iso639_2toInt("aym")] = QString("Aymara");
  names[iso639_2toInt("aze")] = QString("Azerbaijani");
  names[iso639_2toInt("bad")] = QString("Banda");
  names[iso639_2toInt("bai")] = QString("Bamileke languages");
  names[iso639_2toInt("bak")] = QString("Bashkir");
  names[iso639_2toInt("bal")] = QString("Baluchi");
  names[iso639_2toInt("bam")] = QString("Bambara");
  names[iso639_2toInt("ban")] = QString("Balinese");
  names[iso639_2toInt("baq")] = QString("Basque");
  names[iso639_2toInt("baq")] = QString("Basque");
  names[iso639_2toInt("bas")] = QString("Basa");
  names[iso639_2toInt("bat")] = QString("Baltic (Other)");
  names[iso639_2toInt("bej")] = QString("Beja");
  names[iso639_2toInt("bel")] = QString("Belarusian");
  names[iso639_2toInt("bem")] = QString("Bemba");
  names[iso639_2toInt("ben")] = QString("Bengali");
  names[iso639_2toInt("ber")] = QString("Berber (Other)");
  names[iso639_2toInt("bho")] = QString("Bhojpuri");
  names[iso639_2toInt("bih")] = QString("Bihari");
  names[iso639_2toInt("bik")] = QString("Bikol");
  names[iso639_2toInt("bin")] = QString("Bini");
  names[iso639_2toInt("bis")] = QString("Bislama");
  names[iso639_2toInt("bla")] = QString("Siksika");
  names[iso639_2toInt("bnt")] = QString("Bantu (Other)");
  names[iso639_2toInt("bos")] = QString("Bosnian");
  names[iso639_2toInt("bra")] = QString("Braj");
  names[iso639_2toInt("bre")] = QString("Breton");
  names[iso639_2toInt("btk")] = QString("Batak (Indonesia)");
  names[iso639_2toInt("bua")] = QString("Buriat");
  names[iso639_2toInt("bug")] = QString("Buginese");
  names[iso639_2toInt("bul")] = QString("Bulgarian");
  names[iso639_2toInt("bur")] = QString("Burmese");
  names[iso639_2toInt("bur")] = QString("Burmese");
  names[iso639_2toInt("byn")] = QString("Blin; Bilin");
  names[iso639_2toInt("cad")] = QString("Caddo");
  names[iso639_2toInt("cai")] = QString("Central American Indian (Other)");
  names[iso639_2toInt("car")] = QString("Carib");
  names[iso639_2toInt("cat")] = QString("Catalan; Valencian");
  names[iso639_2toInt("cau")] = QString("Caucasian (Other)");
  names[iso639_2toInt("ceb")] = QString("Cebuano");
  names[iso639_2toInt("cel")] = QString("Celtic (Other)");
  names[iso639_2toInt("cha")] = QString("Chamorro");
  names[iso639_2toInt("chb")] = QString("Chibcha");
  names[iso639_2toInt("che")] = QString("Chechen");
  names[iso639_2toInt("chg")] = QString("Chagatai");
  names[iso639_2toInt("chi")] = QString("Chinese");
  names[iso639_2toInt("chi")] = QString("Chinese");
  names[iso639_2toInt("chk")] = QString("Chuukese");
  names[iso639_2toInt("chm")] = QString("Mari");
  names[iso639_2toInt("chn")] = QString("Chinook jargon");
  names[iso639_2toInt("cho")] = QString("Choctaw");
  names[iso639_2toInt("chp")] = QString("Chipewyan");
  names[iso639_2toInt("chr")] = QString("Cherokee");
  names[iso639_2toInt("chu")] = QString("Church Slavic; Old Slavonic").append(
      QString("; Church Slavonic; Old Bulgarian; Old Church Slavonic"));
  names[iso639_2toInt("chv")] = QString("Chuvash");
  names[iso639_2toInt("chy")] = QString("Cheyenne");
  names[iso639_2toInt("cmc")] = QString("Chamic languages");
  names[iso639_2toInt("cop")] = QString("Coptic");
  names[iso639_2toInt("cor")] = QString("Cornish");
  names[iso639_2toInt("cos")] = QString("Corsican");
  names[iso639_2toInt("cpe")] = QString("Creoles and pidgins, English based (Other)");
  names[iso639_2toInt("cpf")] = QString("Creoles and pidgins, French-based (Other)");
  names[iso639_2toInt("cpp")] = QString("Creoles and pidgins, Portuguese-based (Other)");
  names[iso639_2toInt("cre")] = QString("Cree");
  names[iso639_2toInt("crh")] = QString("Crimean Tatar; Crimean Turkish");
  names[iso639_2toInt("crp")] = QString("Creoles and pidgins (Other)");
  names[iso639_2toInt("csb")] = QString("Kashubian");
  names[iso639_2toInt("cus")] = QString("Cushitic (Other)");
  names[iso639_2toInt("cze")] = QString("Czech");
  names[iso639_2toInt("cze")] = QString("Czech");
  names[iso639_2toInt("dak")] = QString("Dakota");
  names[iso639_2toInt("dan")] = QString("Danish");
  names[iso639_2toInt("dar")] = QString("Dargwa");
  names[iso639_2toInt("day")] = QString("Dayak");
  names[iso639_2toInt("del")] = QString("Delaware");
  names[iso639_2toInt("den")] = QString("Slave (Athapascan)");
  names[iso639_2toInt("dgr")] = QString("Dogrib");
  names[iso639_2toInt("din")] = QString("Dinka");
  names[iso639_2toInt("div")] = QString("Divehi");
  names[iso639_2toInt("doi")] = QString("Dogri");
  names[iso639_2toInt("dra")] = QString("Dravidian (Other)");
  names[iso639_2toInt("dsb")] = QString("Lower Sorbian");
  names[iso639_2toInt("dua")] = QString("Duala");
  names[iso639_2toInt("dum")] = QString("Middle Dutch (ca.1050-1350)");
  names[iso639_2toInt("dut")] = QString("Dutch; Flemish");
  names[iso639_2toInt("dut")] = QString("Dutch; Flemish");
  names[iso639_2toInt("dyu")] = QString("Dyula");
  names[iso639_2toInt("dzo")] = QString("Dzongkha");
  names[iso639_2toInt("efi")] = QString("Efik");
  names[iso639_2toInt("egy")] = QString("Egyptian (Ancient)");
  names[iso639_2toInt("eka")] = QString("Ekajuk");
  names[iso639_2toInt("elx")] = QString("Elamite");
  names[iso639_2toInt("eng")] = QString("English");
  names[iso639_2toInt("enm")] = QString("Middle English (1100-1500)");
  names[iso639_2toInt("epo")] = QString("Esperanto");
  names[iso639_2toInt("est")] = QString("Estonian");
  names[iso639_2toInt("ewe")] = QString("Ewe");
  names[iso639_2toInt("ewo")] = QString("Ewondo");
  names[iso639_2toInt("fan")] = QString("Fang");
  names[iso639_2toInt("fao")] = QString("Faroese");
  names[iso639_2toInt("fat")] = QString("Fanti");
  names[iso639_2toInt("fij")] = QString("Fijian");
  names[iso639_2toInt("fin")] = QString("Finnish");
  names[iso639_2toInt("fiu")] = QString("Finno-Ugrian (Other)");
  names[iso639_2toInt("fon")] = QString("Fon");
  names[iso639_2toInt("fre")] = QString("French");
  names[iso639_2toInt("frm")] = QString("Middle French (ca.1400-1800)");
  names[iso639_2toInt("fro")] = QString("Old French (842-ca.1400)");
  names[iso639_2toInt("fry")] = QString("Frisian");
  names[iso639_2toInt("ful")] = QString("Fulah");
  names[iso639_2toInt("fur")] = QString("Friulian");
  names[iso639_2toInt("gaa")] = QString("Ga");
  names[iso639_2toInt("gay")] = QString("Gayo");
  names[iso639_2toInt("gba")] = QString("Gbaya");
  names[iso639_2toInt("gem")] = QString("Germanic (Other)");
  names[iso639_2toInt("geo")] = QString("Georgian");
  names[iso639_2toInt("geo")] = QString("Georgian");
  names[iso639_2toInt("ger")] = QString("German");
  names[iso639_2toInt("ger")] = QString("German");
  names[iso639_2toInt("gez")] = QString("Geez");
  names[iso639_2toInt("gil")] = QString("Gilbertese");
  names[iso639_2toInt("gla")] = QString("Gaelic; Scottish Gaelic");
  names[iso639_2toInt("gle")] = QString("Irish");
  names[iso639_2toInt("glg")] = QString("Gallegan");
  names[iso639_2toInt("glv")] = QString("Manx");
  names[iso639_2toInt("gmh")] = QString("Middle High German (ca.1050-1500)");
  names[iso639_2toInt("goh")] = QString("Old High German (ca.750-1050)");
  names[iso639_2toInt("gon")] = QString("Gondi");
  names[iso639_2toInt("gor")] = QString("Gorontalo");
  names[iso639_2toInt("got")] = QString("Gothic");
  names[iso639_2toInt("grb")] = QString("Grebo");
  names[iso639_2toInt("grc")] = QString("Greek, Ancient (to 1453)");
  names[iso639_2toInt("gre")] = QString("Greek, Modern (1453-)");
  names[iso639_2toInt("gre")] = QString("Greek, Modern (1453-)");
  names[iso639_2toInt("grn")] = QString("Guarani");
  names[iso639_2toInt("guj")] = QString("Gujarati");
  names[iso639_2toInt("gwi")] = QString("Gwichin");
  names[iso639_2toInt("hai")] = QString("Haida");
  names[iso639_2toInt("hat")] = QString("Haitian; Haitian Creole");
  names[iso639_2toInt("hau")] = QString("Hausa");
  names[iso639_2toInt("haw")] = QString("Hawaiian");
  names[iso639_2toInt("heb")] = QString("Hebrew");
  names[iso639_2toInt("her")] = QString("Herero");
  names[iso639_2toInt("hil")] = QString("Hiligaynon");
  names[iso639_2toInt("him")] = QString("Himachali");
  names[iso639_2toInt("hin")] = QString("Hindi");
  names[iso639_2toInt("hit")] = QString("Hittite");
  names[iso639_2toInt("hmn")] = QString("Hmong");
  names[iso639_2toInt("hmo")] = QString("Hiri Motu");
  names[iso639_2toInt("hsb")] = QString("Upper Sorbian");
  names[iso639_2toInt("hun")] = QString("Hungarian");
  names[iso639_2toInt("hup")] = QString("Hupa");
  names[iso639_2toInt("iba")] = QString("Iban");
  names[iso639_2toInt("ibo")] = QString("Igbo");
  names[iso639_2toInt("ice")] = QString("Icelandic");
  names[iso639_2toInt("ido")] = QString("Ido");
  names[iso639_2toInt("iii")] = QString("Sichuan Yi");
  names[iso639_2toInt("ijo")] = QString("Ijo");
  names[iso639_2toInt("iku")] = QString("Inuktitut");
  names[iso639_2toInt("ile")] = QString("Interlingue");
  names[iso639_2toInt("ilo")] = QString("Iloko");
  names[iso639_2toInt("ina")] = QString("Interlingua");
  names[iso639_2toInt("inc")] = QString("Indic (Other)");
  names[iso639_2toInt("ind")] = QString("Indonesian");
  names[iso639_2toInt("ine")] = QString("Indo-European (Other)");
  names[iso639_2toInt("inh")] = QString("Ingush");
  names[iso639_2toInt("ipk")] = QString("Inupiaq");
  names[iso639_2toInt("ira")] = QString("Iranian (Other)");
  names[iso639_2toInt("iro")] = QString("Iroquoian languages");
  names[iso639_2toInt("ita")] = QString("Italian");
  names[iso639_2toInt("jav")] = QString("Javanese");
  names[iso639_2toInt("jbo")] = QString("Lojban");
  names[iso639_2toInt("jpn")] = QString("Japanese");
  names[iso639_2toInt("jpr")] = QString("Judeo-Persian");
  names[iso639_2toInt("jrb")] = QString("Judeo-Arabic");
  names[iso639_2toInt("kaa")] = QString("Kara-Kalpak");
  names[iso639_2toInt("kab")] = QString("Kabyle");
  names[iso639_2toInt("kac")] = QString("Kachin");
  names[iso639_2toInt("kal")] = QString("Kalaallisut; Greenlandic");
  names[iso639_2toInt("kam")] = QString("Kamba");
  names[iso639_2toInt("kan")] = QString("Kannada");
  names[iso639_2toInt("kar")] = QString("Karen");
  names[iso639_2toInt("kas")] = QString("Kashmiri");
  names[iso639_2toInt("kau")] = QString("Kanuri");
  names[iso639_2toInt("kaw")] = QString("Kawi");
  names[iso639_2toInt("kaz")] = QString("Kazakh");
  names[iso639_2toInt("kbd")] = QString("Kabardian");
  names[iso639_2toInt("kha")] = QString("Khasi");
  names[iso639_2toInt("khi")] = QString("Khoisan (Other)");
  names[iso639_2toInt("khm")] = QString("Khmer");
  names[iso639_2toInt("kho")] = QString("Khotanese");
  names[iso639_2toInt("kik")] = QString("Kikuyu; Gikuyu");
  names[iso639_2toInt("kin")] = QString("Kinyarwanda");
  names[iso639_2toInt("kir")] = QString("Kirghiz");
  names[iso639_2toInt("kmb")] = QString("Kimbundu");
  names[iso639_2toInt("kok")] = QString("Konkani");
  names[iso639_2toInt("kom")] = QString("Komi");
  names[iso639_2toInt("kon")] = QString("Kongo");
  names[iso639_2toInt("kor")] = QString("Korean");
  names[iso639_2toInt("kos")] = QString("Kosraean");
  names[iso639_2toInt("kpe")] = QString("Kpelle");
  names[iso639_2toInt("krc")] = QString("Karachay-Balkar");
  names[iso639_2toInt("kro")] = QString("Kru");
  names[iso639_2toInt("kru")] = QString("Kurukh");
  names[iso639_2toInt("kua")] = QString("Kuanyama; Kwanyama");
  names[iso639_2toInt("kum")] = QString("Kumyk");
  names[iso639_2toInt("kur")] = QString("Kurdish");
  names[iso639_2toInt("kut")] = QString("Kutenai");
  names[iso639_2toInt("lad")] = QString("Ladino");
  names[iso639_2toInt("lah")] = QString("Lahnda");
  names[iso639_2toInt("lam")] = QString("Lamba");
  names[iso639_2toInt("lao")] = QString("Lao");
  names[iso639_2toInt("lat")] = QString("Latin");
  names[iso639_2toInt("lav")] = QString("Latvian");
  names[iso639_2toInt("lez")] = QString("Lezghian");
  names[iso639_2toInt("lim")] = QString("Limburgan; Limburger; Limburgish");
  names[iso639_2toInt("lin")] = QString("Lingala");
  names[iso639_2toInt("lit")] = QString("Lithuanian");
  names[iso639_2toInt("lol")] = QString("Mongo");
  names[iso639_2toInt("loz")] = QString("Lozi");
  names[iso639_2toInt("ltz")] = QString("Luxembourgish; Letzeburgesch");
  names[iso639_2toInt("lua")] = QString("Luba-Lulua");
  names[iso639_2toInt("lub")] = QString("Luba-Katanga");
  names[iso639_2toInt("lug")] = QString("Ganda");
  names[iso639_2toInt("lui")] = QString("Luiseno");
  names[iso639_2toInt("lun")] = QString("Lunda");
  names[iso639_2toInt("luo")] = QString("Luo (Kenya and Tanzania)");
  names[iso639_2toInt("lus")] = QString("lushai");
  names[iso639_2toInt("mac")] = QString("Macedonian");
  names[iso639_2toInt("mac")] = QString("Macedonian");
  names[iso639_2toInt("mad")] = QString("Madurese");
  names[iso639_2toInt("mag")] = QString("Magahi");
  names[iso639_2toInt("mah")] = QString("Marshallese");
  names[iso639_2toInt("mai")] = QString("Maithili");
  names[iso639_2toInt("mak")] = QString("Makasar");
  names[iso639_2toInt("mal")] = QString("Malayalam");
  names[iso639_2toInt("man")] = QString("Mandingo");
  names[iso639_2toInt("mao")] = QString("Maori");
  names[iso639_2toInt("mao")] = QString("Maori");
  names[iso639_2toInt("map")] = QString("Austronesian (Other)");
  names[iso639_2toInt("mar")] = QString("Marathi");
  names[iso639_2toInt("mas")] = QString("Masai");
  names[iso639_2toInt("may")] = QString("Malay");
  names[iso639_2toInt("may")] = QString("Malay");
  names[iso639_2toInt("mdf")] = QString("Moksha");
  names[iso639_2toInt("mdr")] = QString("Mandar");
  names[iso639_2toInt("men")] = QString("Mende");
  names[iso639_2toInt("mga")] = QString("Middle Irish (900-1200)");
  names[iso639_2toInt("mic")] = QString("Micmac");
  names[iso639_2toInt("min")] = QString("Minangkabau");
  names[iso639_2toInt("mis")] = QString("Miscellaneous languages");
  names[iso639_2toInt("mkh")] = QString("Mon-Khmer (Other)");
  names[iso639_2toInt("mlg")] = QString("Malagasy");
  names[iso639_2toInt("mlt")] = QString("Maltese");
  names[iso639_2toInt("mnc")] = QString("Manchu");
  names[iso639_2toInt("mni")] = QString("Manipuri");
  names[iso639_2toInt("mno")] = QString("Manobo languages");
  names[iso639_2toInt("moh")] = QString("Mohawk");
  names[iso639_2toInt("mol")] = QString("Moldavian");
  names[iso639_2toInt("mon")] = QString("Mongolian");
  names[iso639_2toInt("mos")] = QString("Mossi");
  names[iso639_2toInt("mul")] = QString("Multiple languages");
  names[iso639_2toInt("mun")] = QString("Munda languages");
  names[iso639_2toInt("mus")] = QString("Creek");
  names[iso639_2toInt("mwr")] = QString("Marwari");
  names[iso639_2toInt("myn")] = QString("Mayan languages");
  names[iso639_2toInt("myv")] = QString("Erzya");
  names[iso639_2toInt("nah")] = QString("Nahuatl");
  names[iso639_2toInt("nai")] = QString("North American Indian");
  names[iso639_2toInt("nap")] = QString("Neapolitan");
  names[iso639_2toInt("nau")] = QString("Nauru");
  names[iso639_2toInt("nav")] = QString("Navajo; Navaho");
  names[iso639_2toInt("nbl")] = QString("Ndebele, South; South Ndebele");
  names[iso639_2toInt("nde")] = QString("Ndebele, North; North Ndebele");
  names[iso639_2toInt("ndo")] = QString("Ndonga");
  names[iso639_2toInt("nds")] = QString("Low German; Low Saxon");
  names[iso639_2toInt("nep")] = QString("Nepali");
  names[iso639_2toInt("new")] = QString("Newari");
  names[iso639_2toInt("nia")] = QString("Nias");
  names[iso639_2toInt("nic")] = QString("Niger-Kordofanian (Other)");
  names[iso639_2toInt("niu")] = QString("Niuean");
  names[iso639_2toInt("nno")] = QString("Norwegian Nynorsk");
  names[iso639_2toInt("nob")] = QString("Norwegian Bokml");
  names[iso639_2toInt("nog")] = QString("Nogai");
  names[iso639_2toInt("non")] = QString("Old Norse");
  names[iso639_2toInt("nor")] = QString("Norwegian");
  names[iso639_2toInt("nso")] = QString("Northern Sotho");
  names[iso639_2toInt("nub")] = QString("Nubian languages");
  names[iso639_2toInt("nwc")] = QString("Classical Newari; Old Newari");
  names[iso639_2toInt("nya")] = QString("Chichewa; Chewa; Nyanja");
  names[iso639_2toInt("nym")] = QString("Nyamwezi");
  names[iso639_2toInt("nyn")] = QString("Nyankole");
  names[iso639_2toInt("nyo")] = QString("Nyoro");
  names[iso639_2toInt("nzi")] = QString("Nzima");
  names[iso639_2toInt("oci")] = QString("Occitan (post 1500); Provenal");
  names[iso639_2toInt("oji")] = QString("Ojibwa");
  names[iso639_2toInt("ori")] = QString("Oriya");
  names[iso639_2toInt("orm")] = QString("Oromo");
  names[iso639_2toInt("osa")] = QString("Osage");
  names[iso639_2toInt("oss")] = QString("Ossetian; Ossetic");
  names[iso639_2toInt("ota")] = QString("Ottoman Turkish (1500-1928)");
  names[iso639_2toInt("oto")] = QString("Otomian languages");
  names[iso639_2toInt("paa")] = QString("Papuan (Other)");
  names[iso639_2toInt("pag")] = QString("Pangasinan");
  names[iso639_2toInt("pal")] = QString("Pahlavi");
  names[iso639_2toInt("pam")] = QString("Pampanga");
  names[iso639_2toInt("pan")] = QString("Panjabi; Punjabi");
  names[iso639_2toInt("pap")] = QString("Papiamento");
  names[iso639_2toInt("pau")] = QString("Palauan");
  names[iso639_2toInt("peo")] = QString("Old Persian (ca.600-400 B.C.)");
  names[iso639_2toInt("per")] = QString("Persian");
  names[iso639_2toInt("per")] = QString("Persian");
  names[iso639_2toInt("phi")] = QString("Philippine (Other)");
  names[iso639_2toInt("phn")] = QString("Phoenician");
  names[iso639_2toInt("pli")] = QString("Pali");
  names[iso639_2toInt("pol")] = QString("Polish");
  names[iso639_2toInt("pon")] = QString("Pohnpeian");
  names[iso639_2toInt("por")] = QString("Portuguese");
  names[iso639_2toInt("pra")] = QString("Prakrit languages");
  names[iso639_2toInt("pro")] = QString("Old Provenal  (to 1500)");
  names[iso639_2toInt("pus")] = QString("Pushto");
  names[iso639_2toInt("qaa")] = QString("Reserved for local use");
  names[iso639_2toInt("qtz")] = QString("Reserved for local use");
  names[iso639_2toInt("que")] = QString("Quechua");
  names[iso639_2toInt("raj")] = QString("Rajasthani");
  names[iso639_2toInt("rap")] = QString("Rapanui");
  names[iso639_2toInt("rar")] = QString("Rarotongan");
  names[iso639_2toInt("roa")] = QString("Romance (Other)");
  names[iso639_2toInt("roh")] = QString("Raeto-Romance");
  names[iso639_2toInt("rom")] = QString("Romany");
  names[iso639_2toInt("rum")] = QString("Romanian");
  names[iso639_2toInt("run")] = QString("Rundi");
  names[iso639_2toInt("rus")] = QString("Russian");
  names[iso639_2toInt("sad")] = QString("Sandawe");
  names[iso639_2toInt("sag")] = QString("Sango");
  names[iso639_2toInt("sah")] = QString("Yakut");
  names[iso639_2toInt("sai")] = QString("South American Indian (Other)");
  names[iso639_2toInt("sal")] = QString("Salishan languages");
  names[iso639_2toInt("sam")] = QString("Samaritan Aramaic");
  names[iso639_2toInt("san")] = QString("Sanskrit");
  names[iso639_2toInt("sas")] = QString("Sasak");
  names[iso639_2toInt("sat")] = QString("Santali");
  names[iso639_2toInt("scc")] = QString("Serbian");
  names[iso639_2toInt("scc")] = QString("Serbian");
  names[iso639_2toInt("sco")] = QString("Scots");
  names[iso639_2toInt("scr")] = QString("Croatian");
  names[iso639_2toInt("scr")] = QString("Croatian");
  names[iso639_2toInt("sel")] = QString("Selkup");
  names[iso639_2toInt("sem")] = QString("Semitic (Other)");
  names[iso639_2toInt("sga")] = QString("Old Irish (to 900)");
  names[iso639_2toInt("sgn")] = QString("Sign Languages");
  names[iso639_2toInt("shn")] = QString("Shan");
  names[iso639_2toInt("sid")] = QString("Sidamo");
  names[iso639_2toInt("sin")] = QString("Sinhalese");
  names[iso639_2toInt("sio")] = QString("Siouan languages");
  names[iso639_2toInt("sit")] = QString("Sino-Tibetan (Other)");
  names[iso639_2toInt("sla")] = QString("Slavic (Other)");
  names[iso639_2toInt("slo")] = QString("Slovak");
  names[iso639_2toInt("slv")] = QString("Slovenian");
  names[iso639_2toInt("sma")] = QString("Southern Sami");
  names[iso639_2toInt("sme")] = QString("Northern Sami");
  names[iso639_2toInt("smi")] = QString("Sami languages (Other)");
  names[iso639_2toInt("smj")] = QString("Lule Sami");
  names[iso639_2toInt("smn")] = QString("Inari Sami");
  names[iso639_2toInt("smo")] = QString("Samoan");
  names[iso639_2toInt("sms")] = QString("Skolt Sami");
  names[iso639_2toInt("sna")] = QString("Shona");
  names[iso639_2toInt("snd")] = QString("Sindhi");
  names[iso639_2toInt("snk")] = QString("Soninke");
  names[iso639_2toInt("sog")] = QString("Sogdian");
  names[iso639_2toInt("som")] = QString("Somali");
  names[iso639_2toInt("son")] = QString("Songhai");
  names[iso639_2toInt("sot")] = QString("Sotho, Southern");
  names[iso639_2toInt("spa")] = QString("Spanish; Castilian");
  names[iso639_2toInt("srd")] = QString("Sardinian");
  names[iso639_2toInt("srr")] = QString("Serer");
  names[iso639_2toInt("ssa")] = QString("Nilo-Saharan (Other)");
  names[iso639_2toInt("ssw")] = QString("Swati");
  names[iso639_2toInt("suk")] = QString("Sukuma");
  names[iso639_2toInt("sun")] = QString("Sundanese");
  names[iso639_2toInt("sus")] = QString("Susu");
  names[iso639_2toInt("sux")] = QString("Sumerian");
  names[iso639_2toInt("swa")] = QString("Swahili");
  names[iso639_2toInt("swe")] = QString("Swedish");
  names[iso639_2toInt("syr")] = QString("Syriac");
  names[iso639_2toInt("tah")] = QString("Tahitian");
  names[iso639_2toInt("tai")] = QString("Tai (Other)");
  names[iso639_2toInt("tam")] = QString("Tamil");
  names[iso639_2toInt("tat")] = QString("Tatar");
  names[iso639_2toInt("tel")] = QString("Telugu");
  names[iso639_2toInt("tem")] = QString("Timne");
  names[iso639_2toInt("ter")] = QString("Tereno");
  names[iso639_2toInt("tet")] = QString("Tetum");
  names[iso639_2toInt("tgk")] = QString("Tajik");
  names[iso639_2toInt("tgl")] = QString("Tagalog");
  names[iso639_2toInt("tha")] = QString("Thai");
  names[iso639_2toInt("tib")] = QString("Tibetan");
  names[iso639_2toInt("tib")] = QString("Tibetan");
  names[iso639_2toInt("tig")] = QString("Tigre");
  names[iso639_2toInt("tir")] = QString("Tigrinya");
  names[iso639_2toInt("tiv")] = QString("Tiv");
  names[iso639_2toInt("tkl")] = QString("Tokelau");
  names[iso639_2toInt("tlh")] = QString("Klingon; tlhlngan-Hol");
  names[iso639_2toInt("tli")] = QString("Tlingit");
  names[iso639_2toInt("tmh")] = QString("Tamashek");
  names[iso639_2toInt("tog")] = QString("Tonga (Nyasa)");
  names[iso639_2toInt("ton")] = QString("Tonga (Tonga Islands)");
  names[iso639_2toInt("tpi")] = QString("Tok Pisin");
  names[iso639_2toInt("tsi")] = QString("Tsimshian");
  names[iso639_2toInt("tsn")] = QString("Tswana");
  names[iso639_2toInt("tso")] = QString("Tsonga");
  names[iso639_2toInt("tuk")] = QString("Turkmen");
  names[iso639_2toInt("tum")] = QString("Tumbuka");
  names[iso639_2toInt("tup")] = QString("Tupi languages");
  names[iso639_2toInt("tur")] = QString("Turkish");
  names[iso639_2toInt("tut")] = QString("Altaic (Other)");
  names[iso639_2toInt("tvl")] = QString("Tuvalu");
  names[iso639_2toInt("twi")] = QString("Twi");
  names[iso639_2toInt("tyv")] = QString("Tuvinian");
  names[iso639_2toInt("udm")] = QString("Udmurt");
  names[iso639_2toInt("uga")] = QString("Ugaritic");
  names[iso639_2toInt("uig")] = QString("Uighur");
  names[iso639_2toInt("ukr")] = QString("Ukrainian");
  names[iso639_2toInt("umb")] = QString("Umbundu");
  names[iso639_2toInt("und")] = QString("Undetermined");
  names[iso639_2toInt("urd")] = QString("Urdu");
  names[iso639_2toInt("uzb")] = QString("Uzbek");
  names[iso639_2toInt("vai")] = QString("Vai");
  names[iso639_2toInt("ven")] = QString("Venda");
  names[iso639_2toInt("vie")] = QString("Vietnamese");
  names[iso639_2toInt("vol")] = QString("Volapk");
  names[iso639_2toInt("vot")] = QString("Votic");
  names[iso639_2toInt("wak")] = QString("Wakashan languages");
  names[iso639_2toInt("wal")] = QString("Walamo");
  names[iso639_2toInt("war")] = QString("Waray");
  names[iso639_2toInt("was")] = QString("Washo");
  names[iso639_2toInt("wel")] = QString("Welsh");
  names[iso639_2toInt("wel")] = QString("Welsh");
  names[iso639_2toInt("wen")] = QString("Sorbian languages");
  names[iso639_2toInt("wln")] = QString("Walloon");
  names[iso639_2toInt("wol")] = QString("Wolof");
  names[iso639_2toInt("xal")] = QString("Kalmyk");
  names[iso639_2toInt("xho")] = QString("Xhosa");
  names[iso639_2toInt("yao")] = QString("Yao");
  names[iso639_2toInt("yap")] = QString("Yapese");
  names[iso639_2toInt("yid")] = QString("Yiddish");
  names[iso639_2toInt("yor")] = QString("Yoruba");
  names[iso639_2toInt("ypk")] = QString("Yupik languages");
  names[iso639_2toInt("zap")] = QString("Zapotec");
  names[iso639_2toInt("zen")] = QString("Zenaga");
  names[iso639_2toInt("zha")] = QString("Zhuang; Chuang");
  names[iso639_2toInt("znd")] = QString("Zande");
  names[iso639_2toInt("zul")] = QString("Zulu");
  names[iso639_2toInt("zun")] = QString("Zuni");
  return 0;
}

int dummy_createCodeToEnglishNamesMap =
    createCodeToEnglishNamesMap(codes2names);

