#ifndef GRABBERSETTINGS_H
#define GRABBERSETTINGS_H

// libmythui
#include "mythuibutton.h"
#include "mythuibuttonlist.h"
#include "mythuicheckbox.h"
#include "mythscreentype.h"
#include "mythdialogbox.h"
#include "metadatagrabber.h"

class MetaGrabberScript;
class GrabberSettings : public MythScreenType
{
  Q_OBJECT

  public:

    GrabberSettings(MythScreenStack *parent, const char *name = nullptr);
    ~GrabberSettings() = default;

    bool Create(void) override; // MythScreenType
    bool keyPressEvent(QKeyEvent *) override; // MythScreenType

  private:
    void Load(void) override; // MythScreenType
    void Init(void) override; // MythScreenType

    GrabberList m_movieGrabberList;
    GrabberList m_tvGrabberList;
    GrabberList m_gameGrabberList;

    MythUIButtonList   *m_movieGrabberButtonList;
    MythUIButtonList   *m_tvGrabberButtonList;
    MythUIButtonList   *m_gameGrabberButtonList;

    MythUICheckBox     *m_dailyUpdatesCheck;

    MythUIButton       *m_okButton;
    MythUIButton       *m_cancelButton;

  private slots:
    void slotSave(void);
};

#endif

