#ifndef L_LOADER_H
#define L_LOADER_H

#include <stdio.h>
#define CG_EXPLICIT
#include <Cg/cg.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Loader API */

extern int  lInit(const char *filename);
extern void lList(const char *prefix, FILE *out);
extern void lDestroy(void);

/* Internals */

typedef struct _LHandle *LHandle;

extern LHandle lHandle;

extern LHandle lLoadLibrary(const char *filename);
extern int     lFreeLibrary(LHandle handle);
extern void *  lGetProcAddress(LHandle handle, const char *name);
const char *   lGetModuleFileName(LHandle handle, void *function);

/* Typedefs */

typedef CGenum (*PFNCGSETLOCKINGPOLICYPROC)(CGenum);
typedef CGenum (*PFNCGGETLOCKINGPOLICYPROC)();
typedef CGenum (*PFNCGSETSEMANTICCASEPOLICYPROC)(CGenum);
typedef CGenum (*PFNCGGETSEMANTICCASEPOLICYPROC)();
typedef CGcontext (*PFNCGCREATECONTEXTPROC)();
typedef void (*PFNCGSETCONTEXTBEHAVIORPROC)(CGcontext, CGbehavior);
typedef CGbehavior (*PFNCGGETCONTEXTBEHAVIORPROC)(CGcontext);
typedef const char *(*PFNCGGETBEHAVIORSTRINGPROC)(CGbehavior);
typedef CGbehavior (*PFNCGGETBEHAVIORPROC)(const char *);
typedef void (*PFNCGDESTROYCONTEXTPROC)(CGcontext);
typedef CGbool (*PFNCGISCONTEXTPROC)(CGcontext);
typedef const char *(*PFNCGGETLASTLISTINGPROC)(CGcontext);
typedef void (*PFNCGSETLASTLISTINGPROC)(CGhandle, const char *);
typedef void (*PFNCGSETAUTOCOMPILEPROC)(CGcontext, CGenum);
typedef CGenum (*PFNCGGETAUTOCOMPILEPROC)(CGcontext);
typedef void (*PFNCGSETPARAMETERSETTINGMODEPROC)(CGcontext, CGenum);
typedef CGenum (*PFNCGGETPARAMETERSETTINGMODEPROC)(CGcontext);
typedef void (*PFNCGSETCOMPILERINCLUDESTRINGPROC)(CGcontext, const char *, const char *);
typedef void (*PFNCGSETCOMPILERINCLUDEFILEPROC)(CGcontext, const char *, const char *);
typedef void (*PFNCGSETCOMPILERINCLUDECALLBACKPROC)(CGcontext, CGIncludeCallbackFunc);
typedef CGIncludeCallbackFunc (*PFNCGGETCOMPILERINCLUDECALLBACKPROC)(CGcontext);
typedef CGprogram (*PFNCGCREATEPROGRAMPROC)(CGcontext, CGenum, const char *, CGprofile, const char *, const char **);
typedef CGprogram (*PFNCGCREATEPROGRAMFROMFILEPROC)(CGcontext, CGenum, const char *, CGprofile, const char *, const char **);
typedef CGprogram (*PFNCGCOPYPROGRAMPROC)(CGprogram);
typedef void (*PFNCGDESTROYPROGRAMPROC)(CGprogram);
typedef CGprogram (*PFNCGGETFIRSTPROGRAMPROC)(CGcontext);
typedef CGprogram (*PFNCGGETNEXTPROGRAMPROC)(CGprogram);
typedef CGcontext (*PFNCGGETPROGRAMCONTEXTPROC)(CGprogram);
typedef CGbool (*PFNCGISPROGRAMPROC)(CGprogram);
typedef void (*PFNCGCOMPILEPROGRAMPROC)(CGprogram);
typedef CGbool (*PFNCGISPROGRAMCOMPILEDPROC)(CGprogram);
typedef const char *(*PFNCGGETPROGRAMSTRINGPROC)(CGprogram, CGenum);
typedef CGprofile (*PFNCGGETPROGRAMPROFILEPROC)(CGprogram);
typedef char const * const *(*PFNCGGETPROGRAMOPTIONSPROC)(CGprogram);
typedef void (*PFNCGSETPROGRAMPROFILEPROC)(CGprogram, CGprofile);
typedef CGenum (*PFNCGGETPROGRAMINPUTPROC)(CGprogram);
typedef CGenum (*PFNCGGETPROGRAMOUTPUTPROC)(CGprogram);
typedef void (*PFNCGSETPASSPROGRAMPARAMETERSPROC)(CGprogram);
typedef void (*PFNCGUPDATEPROGRAMPARAMETERSPROC)(CGprogram);
typedef void (*PFNCGUPDATEPASSPARAMETERSPROC)(CGpass);
typedef CGparameter (*PFNCGCREATEPARAMETERPROC)(CGcontext, CGtype);
typedef CGparameter (*PFNCGCREATEPARAMETERARRAYPROC)(CGcontext, CGtype, int);
typedef CGparameter (*PFNCGCREATEPARAMETERMULTIDIMARRAYPROC)(CGcontext, CGtype, int, const int *);
typedef void (*PFNCGDESTROYPARAMETERPROC)(CGparameter);
typedef void (*PFNCGCONNECTPARAMETERPROC)(CGparameter, CGparameter);
typedef void (*PFNCGDISCONNECTPARAMETERPROC)(CGparameter);
typedef CGparameter (*PFNCGGETCONNECTEDPARAMETERPROC)(CGparameter);
typedef int (*PFNCGGETNUMCONNECTEDTOPARAMETERSPROC)(CGparameter);
typedef CGparameter (*PFNCGGETCONNECTEDTOPARAMETERPROC)(CGparameter, int);
typedef CGparameter (*PFNCGGETNAMEDPARAMETERPROC)(CGprogram, const char *);
typedef CGparameter (*PFNCGGETNAMEDPROGRAMPARAMETERPROC)(CGprogram, CGenum, const char *);
typedef CGparameter (*PFNCGGETFIRSTPARAMETERPROC)(CGprogram, CGenum);
typedef CGparameter (*PFNCGGETNEXTPARAMETERPROC)(CGparameter);
typedef CGparameter (*PFNCGGETFIRSTLEAFPARAMETERPROC)(CGprogram, CGenum);
typedef CGparameter (*PFNCGGETNEXTLEAFPARAMETERPROC)(CGparameter);
typedef CGparameter (*PFNCGGETFIRSTSTRUCTPARAMETERPROC)(CGparameter);
typedef CGparameter (*PFNCGGETNAMEDSTRUCTPARAMETERPROC)(CGparameter, const char *);
typedef CGparameter (*PFNCGGETFIRSTDEPENDENTPARAMETERPROC)(CGparameter);
typedef CGparameter (*PFNCGGETARRAYPARAMETERPROC)(CGparameter, int);
typedef int (*PFNCGGETARRAYDIMENSIONPROC)(CGparameter);
typedef CGtype (*PFNCGGETARRAYTYPEPROC)(CGparameter);
typedef int (*PFNCGGETARRAYSIZEPROC)(CGparameter, int);
typedef int (*PFNCGGETARRAYTOTALSIZEPROC)(CGparameter);
typedef void (*PFNCGSETARRAYSIZEPROC)(CGparameter, int);
typedef void (*PFNCGSETMULTIDIMARRAYSIZEPROC)(CGparameter, const int *);
typedef CGprogram (*PFNCGGETPARAMETERPROGRAMPROC)(CGparameter);
typedef CGcontext (*PFNCGGETPARAMETERCONTEXTPROC)(CGparameter);
typedef CGbool (*PFNCGISPARAMETERPROC)(CGparameter);
typedef const char *(*PFNCGGETPARAMETERNAMEPROC)(CGparameter);
typedef CGtype (*PFNCGGETPARAMETERTYPEPROC)(CGparameter);
typedef CGtype (*PFNCGGETPARAMETERBASETYPEPROC)(CGparameter);
typedef CGparameterclass (*PFNCGGETPARAMETERCLASSPROC)(CGparameter);
typedef int (*PFNCGGETPARAMETERROWSPROC)(CGparameter);
typedef int (*PFNCGGETPARAMETERCOLUMNSPROC)(CGparameter);
typedef CGtype (*PFNCGGETPARAMETERNAMEDTYPEPROC)(CGparameter);
typedef const char *(*PFNCGGETPARAMETERSEMANTICPROC)(CGparameter);
typedef CGresource (*PFNCGGETPARAMETERRESOURCEPROC)(CGparameter);
typedef CGresource (*PFNCGGETPARAMETERBASERESOURCEPROC)(CGparameter);
typedef unsigned long (*PFNCGGETPARAMETERRESOURCEINDEXPROC)(CGparameter);
typedef CGenum (*PFNCGGETPARAMETERVARIABILITYPROC)(CGparameter);
typedef CGenum (*PFNCGGETPARAMETERDIRECTIONPROC)(CGparameter);
typedef CGbool (*PFNCGISPARAMETERREFERENCEDPROC)(CGparameter);
typedef CGbool (*PFNCGISPARAMETERUSEDPROC)(CGparameter, CGhandle);
typedef const double *(*PFNCGGETPARAMETERVALUESPROC)(CGparameter, CGenum, int *);
typedef void (*PFNCGSETPARAMETERVALUEDRPROC)(CGparameter, int, const double *);
typedef void (*PFNCGSETPARAMETERVALUEDCPROC)(CGparameter, int, const double *);
typedef void (*PFNCGSETPARAMETERVALUEFRPROC)(CGparameter, int, const float *);
typedef void (*PFNCGSETPARAMETERVALUEFCPROC)(CGparameter, int, const float *);
typedef void (*PFNCGSETPARAMETERVALUEIRPROC)(CGparameter, int, const int *);
typedef void (*PFNCGSETPARAMETERVALUEICPROC)(CGparameter, int, const int *);
typedef int (*PFNCGGETPARAMETERVALUEDRPROC)(CGparameter, int, double *);
typedef int (*PFNCGGETPARAMETERVALUEDCPROC)(CGparameter, int, double *);
typedef int (*PFNCGGETPARAMETERVALUEFRPROC)(CGparameter, int, float *);
typedef int (*PFNCGGETPARAMETERVALUEFCPROC)(CGparameter, int, float *);
typedef int (*PFNCGGETPARAMETERVALUEIRPROC)(CGparameter, int, int *);
typedef int (*PFNCGGETPARAMETERVALUEICPROC)(CGparameter, int, int *);
typedef int (*PFNCGGETPARAMETERDEFAULTVALUEDRPROC)(CGparameter, int, double *);
typedef int (*PFNCGGETPARAMETERDEFAULTVALUEDCPROC)(CGparameter, int, double *);
typedef int (*PFNCGGETPARAMETERDEFAULTVALUEFRPROC)(CGparameter, int, float *);
typedef int (*PFNCGGETPARAMETERDEFAULTVALUEFCPROC)(CGparameter, int, float *);
typedef int (*PFNCGGETPARAMETERDEFAULTVALUEIRPROC)(CGparameter, int, int *);
typedef int (*PFNCGGETPARAMETERDEFAULTVALUEICPROC)(CGparameter, int, int *);
typedef const char *(*PFNCGGETSTRINGPARAMETERVALUEPROC)(CGparameter);
typedef void (*PFNCGSETSTRINGPARAMETERVALUEPROC)(CGparameter, const char *);
typedef int (*PFNCGGETPARAMETERORDINALNUMBERPROC)(CGparameter);
typedef CGbool (*PFNCGISPARAMETERGLOBALPROC)(CGparameter);
typedef int (*PFNCGGETPARAMETERINDEXPROC)(CGparameter);
typedef void (*PFNCGSETPARAMETERVARIABILITYPROC)(CGparameter, CGenum);
typedef void (*PFNCGSETPARAMETERSEMANTICPROC)(CGparameter, const char *);
typedef void (*PFNCGSETPARAMETER1FPROC)(CGparameter, float);
typedef void (*PFNCGSETPARAMETER2FPROC)(CGparameter, float, float);
typedef void (*PFNCGSETPARAMETER3FPROC)(CGparameter, float, float, float);
typedef void (*PFNCGSETPARAMETER4FPROC)(CGparameter, float, float, float, float);
typedef void (*PFNCGSETPARAMETER1DPROC)(CGparameter, double);
typedef void (*PFNCGSETPARAMETER2DPROC)(CGparameter, double, double);
typedef void (*PFNCGSETPARAMETER3DPROC)(CGparameter, double, double, double);
typedef void (*PFNCGSETPARAMETER4DPROC)(CGparameter, double, double, double, double);
typedef void (*PFNCGSETPARAMETER1IPROC)(CGparameter, int);
typedef void (*PFNCGSETPARAMETER2IPROC)(CGparameter, int, int);
typedef void (*PFNCGSETPARAMETER3IPROC)(CGparameter, int, int, int);
typedef void (*PFNCGSETPARAMETER4IPROC)(CGparameter, int, int, int, int);
typedef void (*PFNCGSETPARAMETER1IVPROC)(CGparameter, const int *);
typedef void (*PFNCGSETPARAMETER2IVPROC)(CGparameter, const int *);
typedef void (*PFNCGSETPARAMETER3IVPROC)(CGparameter, const int *);
typedef void (*PFNCGSETPARAMETER4IVPROC)(CGparameter, const int *);
typedef void (*PFNCGSETPARAMETER1FVPROC)(CGparameter, const float *);
typedef void (*PFNCGSETPARAMETER2FVPROC)(CGparameter, const float *);
typedef void (*PFNCGSETPARAMETER3FVPROC)(CGparameter, const float *);
typedef void (*PFNCGSETPARAMETER4FVPROC)(CGparameter, const float *);
typedef void (*PFNCGSETPARAMETER1DVPROC)(CGparameter, const double *);
typedef void (*PFNCGSETPARAMETER2DVPROC)(CGparameter, const double *);
typedef void (*PFNCGSETPARAMETER3DVPROC)(CGparameter, const double *);
typedef void (*PFNCGSETPARAMETER4DVPROC)(CGparameter, const double *);
typedef void (*PFNCGSETMATRIXPARAMETERIRPROC)(CGparameter, const int *);
typedef void (*PFNCGSETMATRIXPARAMETERDRPROC)(CGparameter, const double *);
typedef void (*PFNCGSETMATRIXPARAMETERFRPROC)(CGparameter, const float *);
typedef void (*PFNCGSETMATRIXPARAMETERICPROC)(CGparameter, const int *);
typedef void (*PFNCGSETMATRIXPARAMETERDCPROC)(CGparameter, const double *);
typedef void (*PFNCGSETMATRIXPARAMETERFCPROC)(CGparameter, const float *);
typedef void (*PFNCGGETMATRIXPARAMETERIRPROC)(CGparameter, int *);
typedef void (*PFNCGGETMATRIXPARAMETERDRPROC)(CGparameter, double *);
typedef void (*PFNCGGETMATRIXPARAMETERFRPROC)(CGparameter, float *);
typedef void (*PFNCGGETMATRIXPARAMETERICPROC)(CGparameter, int *);
typedef void (*PFNCGGETMATRIXPARAMETERDCPROC)(CGparameter, double *);
typedef void (*PFNCGGETMATRIXPARAMETERFCPROC)(CGparameter, float *);
typedef CGenum (*PFNCGGETMATRIXPARAMETERORDERPROC)(CGparameter);
typedef CGparameter (*PFNCGGETNAMEDSUBPARAMETERPROC)(CGparameter, const char *);
typedef const char *(*PFNCGGETTYPESTRINGPROC)(CGtype);
typedef CGtype (*PFNCGGETTYPEPROC)(const char *);
typedef CGtype (*PFNCGGETNAMEDUSERTYPEPROC)(CGhandle, const char *);
typedef int (*PFNCGGETNUMUSERTYPESPROC)(CGhandle);
typedef CGtype (*PFNCGGETUSERTYPEPROC)(CGhandle, int);
typedef int (*PFNCGGETNUMPARENTTYPESPROC)(CGtype);
typedef CGtype (*PFNCGGETPARENTTYPEPROC)(CGtype, int);
typedef CGbool (*PFNCGISPARENTTYPEPROC)(CGtype, CGtype);
typedef CGbool (*PFNCGISINTERFACETYPEPROC)(CGtype);
typedef const char *(*PFNCGGETRESOURCESTRINGPROC)(CGresource);
typedef CGresource (*PFNCGGETRESOURCEPROC)(const char *);
typedef const char *(*PFNCGGETENUMSTRINGPROC)(CGenum);
typedef CGenum (*PFNCGGETENUMPROC)(const char *);
typedef const char *(*PFNCGGETPROFILESTRINGPROC)(CGprofile);
typedef CGprofile (*PFNCGGETPROFILEPROC)(const char *);
typedef int (*PFNCGGETNUMSUPPORTEDPROFILESPROC)();
typedef CGprofile (*PFNCGGETSUPPORTEDPROFILEPROC)(int);
typedef CGbool (*PFNCGISPROFILESUPPORTEDPROC)(CGprofile);
typedef CGbool (*PFNCGGETPROFILEPROPERTYPROC)(CGprofile, CGenum);
typedef const char *(*PFNCGGETPARAMETERCLASSSTRINGPROC)(CGparameterclass);
typedef CGparameterclass (*PFNCGGETPARAMETERCLASSENUMPROC)(const char *);
typedef const char *(*PFNCGGETDOMAINSTRINGPROC)(CGdomain);
typedef CGdomain (*PFNCGGETDOMAINPROC)(const char *);
typedef CGdomain (*PFNCGGETPROGRAMDOMAINPROC)(CGprogram);
typedef CGerror (*PFNCGGETERRORPROC)();
typedef CGerror (*PFNCGGETFIRSTERRORPROC)();
typedef const char *(*PFNCGGETERRORSTRINGPROC)(CGerror);
typedef const char *(*PFNCGGETLASTERRORSTRINGPROC)(CGerror *);
typedef void (*PFNCGSETERRORCALLBACKPROC)(CGerrorCallbackFunc);
typedef CGerrorCallbackFunc (*PFNCGGETERRORCALLBACKPROC)();
typedef void (*PFNCGSETERRORHANDLERPROC)(CGerrorHandlerFunc, void *);
typedef CGerrorHandlerFunc (*PFNCGGETERRORHANDLERPROC)(void **);
typedef const char *(*PFNCGGETSTRINGPROC)(CGenum);
typedef CGeffect (*PFNCGCREATEEFFECTPROC)(CGcontext, const char *, const char **);
typedef CGeffect (*PFNCGCREATEEFFECTFROMFILEPROC)(CGcontext, const char *, const char **);
typedef CGeffect (*PFNCGCOPYEFFECTPROC)(CGeffect);
typedef void (*PFNCGDESTROYEFFECTPROC)(CGeffect);
typedef CGcontext (*PFNCGGETEFFECTCONTEXTPROC)(CGeffect);
typedef CGbool (*PFNCGISEFFECTPROC)(CGeffect);
typedef CGeffect (*PFNCGGETFIRSTEFFECTPROC)(CGcontext);
typedef CGeffect (*PFNCGGETNEXTEFFECTPROC)(CGeffect);
typedef CGprogram (*PFNCGCREATEPROGRAMFROMEFFECTPROC)(CGeffect, CGprofile, const char *, const char **);
typedef CGtechnique (*PFNCGGETFIRSTTECHNIQUEPROC)(CGeffect);
typedef CGtechnique (*PFNCGGETNEXTTECHNIQUEPROC)(CGtechnique);
typedef CGtechnique (*PFNCGGETNAMEDTECHNIQUEPROC)(CGeffect, const char *);
typedef const char *(*PFNCGGETTECHNIQUENAMEPROC)(CGtechnique);
typedef CGbool (*PFNCGISTECHNIQUEPROC)(CGtechnique);
typedef CGbool (*PFNCGVALIDATETECHNIQUEPROC)(CGtechnique);
typedef CGbool (*PFNCGISTECHNIQUEVALIDATEDPROC)(CGtechnique);
typedef CGeffect (*PFNCGGETTECHNIQUEEFFECTPROC)(CGtechnique);
typedef CGpass (*PFNCGGETFIRSTPASSPROC)(CGtechnique);
typedef CGpass (*PFNCGGETNAMEDPASSPROC)(CGtechnique, const char *);
typedef CGpass (*PFNCGGETNEXTPASSPROC)(CGpass);
typedef CGbool (*PFNCGISPASSPROC)(CGpass);
typedef const char *(*PFNCGGETPASSNAMEPROC)(CGpass);
typedef CGtechnique (*PFNCGGETPASSTECHNIQUEPROC)(CGpass);
typedef CGprogram (*PFNCGGETPASSPROGRAMPROC)(CGpass, CGdomain);
typedef void (*PFNCGSETPASSSTATEPROC)(CGpass);
typedef void (*PFNCGRESETPASSSTATEPROC)(CGpass);
typedef CGstateassignment (*PFNCGGETFIRSTSTATEASSIGNMENTPROC)(CGpass);
typedef CGstateassignment (*PFNCGGETNAMEDSTATEASSIGNMENTPROC)(CGpass, const char *);
typedef CGstateassignment (*PFNCGGETNEXTSTATEASSIGNMENTPROC)(CGstateassignment);
typedef CGbool (*PFNCGISSTATEASSIGNMENTPROC)(CGstateassignment);
typedef CGbool (*PFNCGCALLSTATESETCALLBACKPROC)(CGstateassignment);
typedef CGbool (*PFNCGCALLSTATEVALIDATECALLBACKPROC)(CGstateassignment);
typedef CGbool (*PFNCGCALLSTATERESETCALLBACKPROC)(CGstateassignment);
typedef CGpass (*PFNCGGETSTATEASSIGNMENTPASSPROC)(CGstateassignment);
typedef CGparameter (*PFNCGGETSAMPLERSTATEASSIGNMENTPARAMETERPROC)(CGstateassignment);
typedef const float *(*PFNCGGETFLOATSTATEASSIGNMENTVALUESPROC)(CGstateassignment, int *);
typedef const int *(*PFNCGGETINTSTATEASSIGNMENTVALUESPROC)(CGstateassignment, int *);
typedef const CGbool *(*PFNCGGETBOOLSTATEASSIGNMENTVALUESPROC)(CGstateassignment, int *);
typedef const char *(*PFNCGGETSTRINGSTATEASSIGNMENTVALUEPROC)(CGstateassignment);
typedef CGprogram (*PFNCGGETPROGRAMSTATEASSIGNMENTVALUEPROC)(CGstateassignment);
typedef CGparameter (*PFNCGGETTEXTURESTATEASSIGNMENTVALUEPROC)(CGstateassignment);
typedef CGparameter (*PFNCGGETSAMPLERSTATEASSIGNMENTVALUEPROC)(CGstateassignment);
typedef int (*PFNCGGETSTATEASSIGNMENTINDEXPROC)(CGstateassignment);
typedef int (*PFNCGGETNUMDEPENDENTSTATEASSIGNMENTPARAMETERSPROC)(CGstateassignment);
typedef CGparameter (*PFNCGGETDEPENDENTSTATEASSIGNMENTPARAMETERPROC)(CGstateassignment, int);
typedef int (*PFNCGGETNUMDEPENDENTPROGRAMARRAYSTATEASSIGNMENTPARAMETERSPROC)(CGstateassignment);
typedef CGparameter (*PFNCGGETDEPENDENTPROGRAMARRAYSTATEASSIGNMENTPARAMETERPROC)(CGstateassignment, int);
typedef CGparameter (*PFNCGGETCONNECTEDSTATEASSIGNMENTPARAMETERPROC)(CGstateassignment);
typedef CGstate (*PFNCGGETSTATEASSIGNMENTSTATEPROC)(CGstateassignment);
typedef CGstate (*PFNCGGETSAMPLERSTATEASSIGNMENTSTATEPROC)(CGstateassignment);
typedef CGstate (*PFNCGCREATESTATEPROC)(CGcontext, const char *, CGtype);
typedef CGstate (*PFNCGCREATEARRAYSTATEPROC)(CGcontext, const char *, CGtype, int);
typedef void (*PFNCGSETSTATECALLBACKSPROC)(CGstate, CGstatecallback, CGstatecallback, CGstatecallback);
typedef void (*PFNCGSETSTATELATESTPROFILEPROC)(CGstate, CGprofile);
typedef CGstatecallback (*PFNCGGETSTATESETCALLBACKPROC)(CGstate);
typedef CGstatecallback (*PFNCGGETSTATERESETCALLBACKPROC)(CGstate);
typedef CGstatecallback (*PFNCGGETSTATEVALIDATECALLBACKPROC)(CGstate);
typedef CGprofile (*PFNCGGETSTATELATESTPROFILEPROC)(CGstate);
typedef CGcontext (*PFNCGGETSTATECONTEXTPROC)(CGstate);
typedef CGtype (*PFNCGGETSTATETYPEPROC)(CGstate);
typedef const char *(*PFNCGGETSTATENAMEPROC)(CGstate);
typedef CGstate (*PFNCGGETNAMEDSTATEPROC)(CGcontext, const char *);
typedef CGstate (*PFNCGGETFIRSTSTATEPROC)(CGcontext);
typedef CGstate (*PFNCGGETNEXTSTATEPROC)(CGstate);
typedef CGbool (*PFNCGISSTATEPROC)(CGstate);
typedef void (*PFNCGADDSTATEENUMERANTPROC)(CGstate, const char *, int);
typedef CGstate (*PFNCGCREATESAMPLERSTATEPROC)(CGcontext, const char *, CGtype);
typedef CGstate (*PFNCGCREATEARRAYSAMPLERSTATEPROC)(CGcontext, const char *, CGtype, int);
typedef CGstate (*PFNCGGETNAMEDSAMPLERSTATEPROC)(CGcontext, const char *);
typedef CGstate (*PFNCGGETFIRSTSAMPLERSTATEPROC)(CGcontext);
typedef CGstateassignment (*PFNCGGETFIRSTSAMPLERSTATEASSIGNMENTPROC)(CGparameter);
typedef CGstateassignment (*PFNCGGETNAMEDSAMPLERSTATEASSIGNMENTPROC)(CGparameter, const char *);
typedef void (*PFNCGSETSAMPLERSTATEPROC)(CGparameter);
typedef CGparameter (*PFNCGGETNAMEDEFFECTPARAMETERPROC)(CGeffect, const char *);
typedef CGparameter (*PFNCGGETFIRSTLEAFEFFECTPARAMETERPROC)(CGeffect);
typedef CGparameter (*PFNCGGETFIRSTEFFECTPARAMETERPROC)(CGeffect);
typedef CGparameter (*PFNCGGETEFFECTPARAMETERBYSEMANTICPROC)(CGeffect, const char *);
typedef CGannotation (*PFNCGGETFIRSTTECHNIQUEANNOTATIONPROC)(CGtechnique);
typedef CGannotation (*PFNCGGETFIRSTPASSANNOTATIONPROC)(CGpass);
typedef CGannotation (*PFNCGGETFIRSTPARAMETERANNOTATIONPROC)(CGparameter);
typedef CGannotation (*PFNCGGETFIRSTPROGRAMANNOTATIONPROC)(CGprogram);
typedef CGannotation (*PFNCGGETFIRSTEFFECTANNOTATIONPROC)(CGeffect);
typedef CGannotation (*PFNCGGETNEXTANNOTATIONPROC)(CGannotation);
typedef CGannotation (*PFNCGGETNAMEDTECHNIQUEANNOTATIONPROC)(CGtechnique, const char *);
typedef CGannotation (*PFNCGGETNAMEDPASSANNOTATIONPROC)(CGpass, const char *);
typedef CGannotation (*PFNCGGETNAMEDPARAMETERANNOTATIONPROC)(CGparameter, const char *);
typedef CGannotation (*PFNCGGETNAMEDPROGRAMANNOTATIONPROC)(CGprogram, const char *);
typedef CGannotation (*PFNCGGETNAMEDEFFECTANNOTATIONPROC)(CGeffect, const char *);
typedef CGbool (*PFNCGISANNOTATIONPROC)(CGannotation);
typedef const char *(*PFNCGGETANNOTATIONNAMEPROC)(CGannotation);
typedef CGtype (*PFNCGGETANNOTATIONTYPEPROC)(CGannotation);
typedef const float *(*PFNCGGETFLOATANNOTATIONVALUESPROC)(CGannotation, int *);
typedef const int *(*PFNCGGETINTANNOTATIONVALUESPROC)(CGannotation, int *);
typedef const char *(*PFNCGGETSTRINGANNOTATIONVALUEPROC)(CGannotation);
typedef const char * const *(*PFNCGGETSTRINGANNOTATIONVALUESPROC)(CGannotation, int *);
typedef const CGbool *(*PFNCGGETBOOLANNOTATIONVALUESPROC)(CGannotation, int *);
typedef const int *(*PFNCGGETBOOLEANANNOTATIONVALUESPROC)(CGannotation, int *);
typedef int (*PFNCGGETNUMDEPENDENTANNOTATIONPARAMETERSPROC)(CGannotation);
typedef CGparameter (*PFNCGGETDEPENDENTANNOTATIONPARAMETERPROC)(CGannotation, int);
typedef void (*PFNCGEVALUATEPROGRAMPROC)(CGprogram, float *, int, int, int, int);
typedef CGbool (*PFNCGSETEFFECTNAMEPROC)(CGeffect, const char *);
typedef const char *(*PFNCGGETEFFECTNAMEPROC)(CGeffect);
typedef CGeffect (*PFNCGGETNAMEDEFFECTPROC)(CGcontext, const char *);
typedef CGparameter (*PFNCGCREATEEFFECTPARAMETERPROC)(CGeffect, const char *, CGtype);
typedef CGtechnique (*PFNCGCREATETECHNIQUEPROC)(CGeffect, const char *);
typedef CGparameter (*PFNCGCREATEEFFECTPARAMETERARRAYPROC)(CGeffect, const char *, CGtype, int);
typedef CGparameter (*PFNCGCREATEEFFECTPARAMETERMULTIDIMARRAYPROC)(CGeffect, const char *, CGtype, int, const int *);
typedef CGpass (*PFNCGCREATEPASSPROC)(CGtechnique, const char *);
typedef CGstateassignment (*PFNCGCREATESTATEASSIGNMENTPROC)(CGpass, CGstate);
typedef CGstateassignment (*PFNCGCREATESTATEASSIGNMENTINDEXPROC)(CGpass, CGstate, int);
typedef CGstateassignment (*PFNCGCREATESAMPLERSTATEASSIGNMENTPROC)(CGparameter, CGstate);
typedef CGbool (*PFNCGSETFLOATSTATEASSIGNMENTPROC)(CGstateassignment, float);
typedef CGbool (*PFNCGSETINTSTATEASSIGNMENTPROC)(CGstateassignment, int);
typedef CGbool (*PFNCGSETBOOLSTATEASSIGNMENTPROC)(CGstateassignment, CGbool);
typedef CGbool (*PFNCGSETSTRINGSTATEASSIGNMENTPROC)(CGstateassignment, const char *);
typedef CGbool (*PFNCGSETPROGRAMSTATEASSIGNMENTPROC)(CGstateassignment, CGprogram);
typedef CGbool (*PFNCGSETSAMPLERSTATEASSIGNMENTPROC)(CGstateassignment, CGparameter);
typedef CGbool (*PFNCGSETTEXTURESTATEASSIGNMENTPROC)(CGstateassignment, CGparameter);
typedef CGbool (*PFNCGSETFLOATARRAYSTATEASSIGNMENTPROC)(CGstateassignment, const float *);
typedef CGbool (*PFNCGSETINTARRAYSTATEASSIGNMENTPROC)(CGstateassignment, const int *);
typedef CGbool (*PFNCGSETBOOLARRAYSTATEASSIGNMENTPROC)(CGstateassignment, const CGbool *);
typedef CGannotation (*PFNCGCREATETECHNIQUEANNOTATIONPROC)(CGtechnique, const char *, CGtype);
typedef CGannotation (*PFNCGCREATEPASSANNOTATIONPROC)(CGpass, const char *, CGtype);
typedef CGannotation (*PFNCGCREATEPARAMETERANNOTATIONPROC)(CGparameter, const char *, CGtype);
typedef CGannotation (*PFNCGCREATEPROGRAMANNOTATIONPROC)(CGprogram, const char *, CGtype);
typedef CGannotation (*PFNCGCREATEEFFECTANNOTATIONPROC)(CGeffect, const char *, CGtype);
typedef CGbool (*PFNCGSETINTANNOTATIONPROC)(CGannotation, int);
typedef CGbool (*PFNCGSETFLOATANNOTATIONPROC)(CGannotation, float);
typedef CGbool (*PFNCGSETBOOLANNOTATIONPROC)(CGannotation, CGbool);
typedef CGbool (*PFNCGSETSTRINGANNOTATIONPROC)(CGannotation, const char *);
typedef int (*PFNCGGETNUMSTATEENUMERANTSPROC)(CGstate);
typedef const char *(*PFNCGGETSTATEENUMERANTPROC)(CGstate, int, int *);
typedef const char *(*PFNCGGETSTATEENUMERANTNAMEPROC)(CGstate, int);
typedef int (*PFNCGGETSTATEENUMERANTVALUEPROC)(CGstate, const char *);
typedef CGeffect (*PFNCGGETPARAMETEREFFECTPROC)(CGparameter);
typedef CGparameterclass (*PFNCGGETTYPECLASSPROC)(CGtype);
typedef CGtype (*PFNCGGETTYPEBASEPROC)(CGtype);
typedef CGbool (*PFNCGGETTYPESIZESPROC)(CGtype, int *, int *);
typedef void (*PFNCGGETMATRIXSIZEPROC)(CGtype, int *, int *);
typedef int (*PFNCGGETNUMPROGRAMDOMAINSPROC)(CGprogram);
typedef CGdomain (*PFNCGGETPROFILEDOMAINPROC)(CGprofile);
typedef CGprogram (*PFNCGCOMBINEPROGRAMSPROC)(int, const CGprogram *);
typedef CGprogram (*PFNCGCOMBINEPROGRAMS2PROC)(const CGprogram, const CGprogram);
typedef CGprogram (*PFNCGCOMBINEPROGRAMS3PROC)(const CGprogram, const CGprogram, const CGprogram);
typedef CGprogram (*PFNCGCOMBINEPROGRAMS4PROC)(const CGprogram, const CGprogram, const CGprogram, const CGprogram);
typedef CGprogram (*PFNCGCOMBINEPROGRAMS5PROC)(const CGprogram, const CGprogram, const CGprogram, const CGprogram, const CGprogram);
typedef CGprofile (*PFNCGGETPROGRAMDOMAINPROFILEPROC)(CGprogram, int);
typedef CGprogram (*PFNCGGETPROGRAMDOMAINPROGRAMPROC)(CGprogram, int);
typedef CGobj (*PFNCGCREATEOBJPROC)(CGcontext, CGenum, const char *, CGprofile, const char **);
typedef CGobj (*PFNCGCREATEOBJFROMFILEPROC)(CGcontext, CGenum, const char *, CGprofile, const char **);
typedef void (*PFNCGDESTROYOBJPROC)(CGobj);
typedef long (*PFNCGGETPARAMETERRESOURCESIZEPROC)(CGparameter);
typedef CGtype (*PFNCGGETPARAMETERRESOURCETYPEPROC)(CGparameter);
typedef const char *(*PFNCGGETPARAMETERRESOURCENAMEPROC)(CGparameter);
typedef int (*PFNCGGETPARAMETERBUFFERINDEXPROC)(CGparameter);
typedef int (*PFNCGGETPARAMETERBUFFEROFFSETPROC)(CGparameter);
typedef CGbuffer (*PFNCGCREATEBUFFERPROC)(CGcontext, int, const void *, CGbufferusage);
typedef void (*PFNCGSETBUFFERDATAPROC)(CGbuffer, int, const void *);
typedef void (*PFNCGSETBUFFERSUBDATAPROC)(CGbuffer, int, int, const void *);
typedef void (*PFNCGSETPROGRAMBUFFERPROC)(CGprogram, int, CGbuffer);
typedef void *(*PFNCGMAPBUFFERPROC)(CGbuffer, CGbufferaccess);
typedef void (*PFNCGUNMAPBUFFERPROC)(CGbuffer);
typedef void (*PFNCGDESTROYBUFFERPROC)(CGbuffer);
typedef CGbuffer (*PFNCGGETPROGRAMBUFFERPROC)(CGprogram, int);
typedef int (*PFNCGGETBUFFERSIZEPROC)(CGbuffer);
typedef int (*PFNCGGETPROGRAMBUFFERMAXSIZEPROC)(CGprofile);
typedef int (*PFNCGGETPROGRAMBUFFERMAXINDEXPROC)(CGprofile);
typedef CGbuffer (*PFNCGGETEFFECTPARAMETERBUFFERPROC)(CGparameter);
typedef void (*PFNCGSETEFFECTPARAMETERBUFFERPROC)(CGparameter, CGbuffer);

/* Declarations */

extern PFNCGSETLOCKINGPOLICYPROC cgSetLockingPolicy;
extern PFNCGGETLOCKINGPOLICYPROC cgGetLockingPolicy;
extern PFNCGSETSEMANTICCASEPOLICYPROC cgSetSemanticCasePolicy;
extern PFNCGGETSEMANTICCASEPOLICYPROC cgGetSemanticCasePolicy;
extern PFNCGCREATECONTEXTPROC cgCreateContext;
extern PFNCGSETCONTEXTBEHAVIORPROC cgSetContextBehavior;
extern PFNCGGETCONTEXTBEHAVIORPROC cgGetContextBehavior;
extern PFNCGGETBEHAVIORSTRINGPROC cgGetBehaviorString;
extern PFNCGGETBEHAVIORPROC cgGetBehavior;
extern PFNCGDESTROYCONTEXTPROC cgDestroyContext;
extern PFNCGISCONTEXTPROC cgIsContext;
extern PFNCGGETLASTLISTINGPROC cgGetLastListing;
extern PFNCGSETLASTLISTINGPROC cgSetLastListing;
extern PFNCGSETAUTOCOMPILEPROC cgSetAutoCompile;
extern PFNCGGETAUTOCOMPILEPROC cgGetAutoCompile;
extern PFNCGSETPARAMETERSETTINGMODEPROC cgSetParameterSettingMode;
extern PFNCGGETPARAMETERSETTINGMODEPROC cgGetParameterSettingMode;
extern PFNCGSETCOMPILERINCLUDESTRINGPROC cgSetCompilerIncludeString;
extern PFNCGSETCOMPILERINCLUDEFILEPROC cgSetCompilerIncludeFile;
extern PFNCGSETCOMPILERINCLUDECALLBACKPROC cgSetCompilerIncludeCallback;
extern PFNCGGETCOMPILERINCLUDECALLBACKPROC cgGetCompilerIncludeCallback;
extern PFNCGCREATEPROGRAMPROC cgCreateProgram;
extern PFNCGCREATEPROGRAMFROMFILEPROC cgCreateProgramFromFile;
extern PFNCGCOPYPROGRAMPROC cgCopyProgram;
extern PFNCGDESTROYPROGRAMPROC cgDestroyProgram;
extern PFNCGGETFIRSTPROGRAMPROC cgGetFirstProgram;
extern PFNCGGETNEXTPROGRAMPROC cgGetNextProgram;
extern PFNCGGETPROGRAMCONTEXTPROC cgGetProgramContext;
extern PFNCGISPROGRAMPROC cgIsProgram;
extern PFNCGCOMPILEPROGRAMPROC cgCompileProgram;
extern PFNCGISPROGRAMCOMPILEDPROC cgIsProgramCompiled;
extern PFNCGGETPROGRAMSTRINGPROC cgGetProgramString;
extern PFNCGGETPROGRAMPROFILEPROC cgGetProgramProfile;
extern PFNCGGETPROGRAMOPTIONSPROC cgGetProgramOptions;
extern PFNCGSETPROGRAMPROFILEPROC cgSetProgramProfile;
extern PFNCGGETPROGRAMINPUTPROC cgGetProgramInput;
extern PFNCGGETPROGRAMOUTPUTPROC cgGetProgramOutput;
extern PFNCGSETPASSPROGRAMPARAMETERSPROC cgSetPassProgramParameters;
extern PFNCGUPDATEPROGRAMPARAMETERSPROC cgUpdateProgramParameters;
extern PFNCGUPDATEPASSPARAMETERSPROC cgUpdatePassParameters;
extern PFNCGCREATEPARAMETERPROC cgCreateParameter;
extern PFNCGCREATEPARAMETERARRAYPROC cgCreateParameterArray;
extern PFNCGCREATEPARAMETERMULTIDIMARRAYPROC cgCreateParameterMultiDimArray;
extern PFNCGDESTROYPARAMETERPROC cgDestroyParameter;
extern PFNCGCONNECTPARAMETERPROC cgConnectParameter;
extern PFNCGDISCONNECTPARAMETERPROC cgDisconnectParameter;
extern PFNCGGETCONNECTEDPARAMETERPROC cgGetConnectedParameter;
extern PFNCGGETNUMCONNECTEDTOPARAMETERSPROC cgGetNumConnectedToParameters;
extern PFNCGGETCONNECTEDTOPARAMETERPROC cgGetConnectedToParameter;
extern PFNCGGETNAMEDPARAMETERPROC cgGetNamedParameter;
extern PFNCGGETNAMEDPROGRAMPARAMETERPROC cgGetNamedProgramParameter;
extern PFNCGGETFIRSTPARAMETERPROC cgGetFirstParameter;
extern PFNCGGETNEXTPARAMETERPROC cgGetNextParameter;
extern PFNCGGETFIRSTLEAFPARAMETERPROC cgGetFirstLeafParameter;
extern PFNCGGETNEXTLEAFPARAMETERPROC cgGetNextLeafParameter;
extern PFNCGGETFIRSTSTRUCTPARAMETERPROC cgGetFirstStructParameter;
extern PFNCGGETNAMEDSTRUCTPARAMETERPROC cgGetNamedStructParameter;
extern PFNCGGETFIRSTDEPENDENTPARAMETERPROC cgGetFirstDependentParameter;
extern PFNCGGETARRAYPARAMETERPROC cgGetArrayParameter;
extern PFNCGGETARRAYDIMENSIONPROC cgGetArrayDimension;
extern PFNCGGETARRAYTYPEPROC cgGetArrayType;
extern PFNCGGETARRAYSIZEPROC cgGetArraySize;
extern PFNCGGETARRAYTOTALSIZEPROC cgGetArrayTotalSize;
extern PFNCGSETARRAYSIZEPROC cgSetArraySize;
extern PFNCGSETMULTIDIMARRAYSIZEPROC cgSetMultiDimArraySize;
extern PFNCGGETPARAMETERPROGRAMPROC cgGetParameterProgram;
extern PFNCGGETPARAMETERCONTEXTPROC cgGetParameterContext;
extern PFNCGISPARAMETERPROC cgIsParameter;
extern PFNCGGETPARAMETERNAMEPROC cgGetParameterName;
extern PFNCGGETPARAMETERTYPEPROC cgGetParameterType;
extern PFNCGGETPARAMETERBASETYPEPROC cgGetParameterBaseType;
extern PFNCGGETPARAMETERCLASSPROC cgGetParameterClass;
extern PFNCGGETPARAMETERROWSPROC cgGetParameterRows;
extern PFNCGGETPARAMETERCOLUMNSPROC cgGetParameterColumns;
extern PFNCGGETPARAMETERNAMEDTYPEPROC cgGetParameterNamedType;
extern PFNCGGETPARAMETERSEMANTICPROC cgGetParameterSemantic;
extern PFNCGGETPARAMETERRESOURCEPROC cgGetParameterResource;
extern PFNCGGETPARAMETERBASERESOURCEPROC cgGetParameterBaseResource;
extern PFNCGGETPARAMETERRESOURCEINDEXPROC cgGetParameterResourceIndex;
extern PFNCGGETPARAMETERVARIABILITYPROC cgGetParameterVariability;
extern PFNCGGETPARAMETERDIRECTIONPROC cgGetParameterDirection;
extern PFNCGISPARAMETERREFERENCEDPROC cgIsParameterReferenced;
extern PFNCGISPARAMETERUSEDPROC cgIsParameterUsed;
extern PFNCGGETPARAMETERVALUESPROC cgGetParameterValues;
extern PFNCGSETPARAMETERVALUEDRPROC cgSetParameterValuedr;
extern PFNCGSETPARAMETERVALUEDCPROC cgSetParameterValuedc;
extern PFNCGSETPARAMETERVALUEFRPROC cgSetParameterValuefr;
extern PFNCGSETPARAMETERVALUEFCPROC cgSetParameterValuefc;
extern PFNCGSETPARAMETERVALUEIRPROC cgSetParameterValueir;
extern PFNCGSETPARAMETERVALUEICPROC cgSetParameterValueic;
extern PFNCGGETPARAMETERVALUEDRPROC cgGetParameterValuedr;
extern PFNCGGETPARAMETERVALUEDCPROC cgGetParameterValuedc;
extern PFNCGGETPARAMETERVALUEFRPROC cgGetParameterValuefr;
extern PFNCGGETPARAMETERVALUEFCPROC cgGetParameterValuefc;
extern PFNCGGETPARAMETERVALUEIRPROC cgGetParameterValueir;
extern PFNCGGETPARAMETERVALUEICPROC cgGetParameterValueic;
extern PFNCGGETPARAMETERDEFAULTVALUEDRPROC cgGetParameterDefaultValuedr;
extern PFNCGGETPARAMETERDEFAULTVALUEDCPROC cgGetParameterDefaultValuedc;
extern PFNCGGETPARAMETERDEFAULTVALUEFRPROC cgGetParameterDefaultValuefr;
extern PFNCGGETPARAMETERDEFAULTVALUEFCPROC cgGetParameterDefaultValuefc;
extern PFNCGGETPARAMETERDEFAULTVALUEIRPROC cgGetParameterDefaultValueir;
extern PFNCGGETPARAMETERDEFAULTVALUEICPROC cgGetParameterDefaultValueic;
extern PFNCGGETSTRINGPARAMETERVALUEPROC cgGetStringParameterValue;
extern PFNCGSETSTRINGPARAMETERVALUEPROC cgSetStringParameterValue;
extern PFNCGGETPARAMETERORDINALNUMBERPROC cgGetParameterOrdinalNumber;
extern PFNCGISPARAMETERGLOBALPROC cgIsParameterGlobal;
extern PFNCGGETPARAMETERINDEXPROC cgGetParameterIndex;
extern PFNCGSETPARAMETERVARIABILITYPROC cgSetParameterVariability;
extern PFNCGSETPARAMETERSEMANTICPROC cgSetParameterSemantic;
extern PFNCGSETPARAMETER1FPROC cgSetParameter1f;
extern PFNCGSETPARAMETER2FPROC cgSetParameter2f;
extern PFNCGSETPARAMETER3FPROC cgSetParameter3f;
extern PFNCGSETPARAMETER4FPROC cgSetParameter4f;
extern PFNCGSETPARAMETER1DPROC cgSetParameter1d;
extern PFNCGSETPARAMETER2DPROC cgSetParameter2d;
extern PFNCGSETPARAMETER3DPROC cgSetParameter3d;
extern PFNCGSETPARAMETER4DPROC cgSetParameter4d;
extern PFNCGSETPARAMETER1IPROC cgSetParameter1i;
extern PFNCGSETPARAMETER2IPROC cgSetParameter2i;
extern PFNCGSETPARAMETER3IPROC cgSetParameter3i;
extern PFNCGSETPARAMETER4IPROC cgSetParameter4i;
extern PFNCGSETPARAMETER1IVPROC cgSetParameter1iv;
extern PFNCGSETPARAMETER2IVPROC cgSetParameter2iv;
extern PFNCGSETPARAMETER3IVPROC cgSetParameter3iv;
extern PFNCGSETPARAMETER4IVPROC cgSetParameter4iv;
extern PFNCGSETPARAMETER1FVPROC cgSetParameter1fv;
extern PFNCGSETPARAMETER2FVPROC cgSetParameter2fv;
extern PFNCGSETPARAMETER3FVPROC cgSetParameter3fv;
extern PFNCGSETPARAMETER4FVPROC cgSetParameter4fv;
extern PFNCGSETPARAMETER1DVPROC cgSetParameter1dv;
extern PFNCGSETPARAMETER2DVPROC cgSetParameter2dv;
extern PFNCGSETPARAMETER3DVPROC cgSetParameter3dv;
extern PFNCGSETPARAMETER4DVPROC cgSetParameter4dv;
extern PFNCGSETMATRIXPARAMETERIRPROC cgSetMatrixParameterir;
extern PFNCGSETMATRIXPARAMETERDRPROC cgSetMatrixParameterdr;
extern PFNCGSETMATRIXPARAMETERFRPROC cgSetMatrixParameterfr;
extern PFNCGSETMATRIXPARAMETERICPROC cgSetMatrixParameteric;
extern PFNCGSETMATRIXPARAMETERDCPROC cgSetMatrixParameterdc;
extern PFNCGSETMATRIXPARAMETERFCPROC cgSetMatrixParameterfc;
extern PFNCGGETMATRIXPARAMETERIRPROC cgGetMatrixParameterir;
extern PFNCGGETMATRIXPARAMETERDRPROC cgGetMatrixParameterdr;
extern PFNCGGETMATRIXPARAMETERFRPROC cgGetMatrixParameterfr;
extern PFNCGGETMATRIXPARAMETERICPROC cgGetMatrixParameteric;
extern PFNCGGETMATRIXPARAMETERDCPROC cgGetMatrixParameterdc;
extern PFNCGGETMATRIXPARAMETERFCPROC cgGetMatrixParameterfc;
extern PFNCGGETMATRIXPARAMETERORDERPROC cgGetMatrixParameterOrder;
extern PFNCGGETNAMEDSUBPARAMETERPROC cgGetNamedSubParameter;
extern PFNCGGETTYPESTRINGPROC cgGetTypeString;
extern PFNCGGETTYPEPROC cgGetType;
extern PFNCGGETNAMEDUSERTYPEPROC cgGetNamedUserType;
extern PFNCGGETNUMUSERTYPESPROC cgGetNumUserTypes;
extern PFNCGGETUSERTYPEPROC cgGetUserType;
extern PFNCGGETNUMPARENTTYPESPROC cgGetNumParentTypes;
extern PFNCGGETPARENTTYPEPROC cgGetParentType;
extern PFNCGISPARENTTYPEPROC cgIsParentType;
extern PFNCGISINTERFACETYPEPROC cgIsInterfaceType;
extern PFNCGGETRESOURCESTRINGPROC cgGetResourceString;
extern PFNCGGETRESOURCEPROC cgGetResource;
extern PFNCGGETENUMSTRINGPROC cgGetEnumString;
extern PFNCGGETENUMPROC cgGetEnum;
extern PFNCGGETPROFILESTRINGPROC cgGetProfileString;
extern PFNCGGETPROFILEPROC cgGetProfile;
extern PFNCGGETNUMSUPPORTEDPROFILESPROC cgGetNumSupportedProfiles;
extern PFNCGGETSUPPORTEDPROFILEPROC cgGetSupportedProfile;
extern PFNCGISPROFILESUPPORTEDPROC cgIsProfileSupported;
extern PFNCGGETPROFILEPROPERTYPROC cgGetProfileProperty;
extern PFNCGGETPARAMETERCLASSSTRINGPROC cgGetParameterClassString;
extern PFNCGGETPARAMETERCLASSENUMPROC cgGetParameterClassEnum;
extern PFNCGGETDOMAINSTRINGPROC cgGetDomainString;
extern PFNCGGETDOMAINPROC cgGetDomain;
extern PFNCGGETPROGRAMDOMAINPROC cgGetProgramDomain;
extern PFNCGGETERRORPROC cgGetError;
extern PFNCGGETFIRSTERRORPROC cgGetFirstError;
extern PFNCGGETERRORSTRINGPROC cgGetErrorString;
extern PFNCGGETLASTERRORSTRINGPROC cgGetLastErrorString;
extern PFNCGSETERRORCALLBACKPROC cgSetErrorCallback;
extern PFNCGGETERRORCALLBACKPROC cgGetErrorCallback;
extern PFNCGSETERRORHANDLERPROC cgSetErrorHandler;
extern PFNCGGETERRORHANDLERPROC cgGetErrorHandler;
extern PFNCGGETSTRINGPROC cgGetString;
extern PFNCGCREATEEFFECTPROC cgCreateEffect;
extern PFNCGCREATEEFFECTFROMFILEPROC cgCreateEffectFromFile;
extern PFNCGCOPYEFFECTPROC cgCopyEffect;
extern PFNCGDESTROYEFFECTPROC cgDestroyEffect;
extern PFNCGGETEFFECTCONTEXTPROC cgGetEffectContext;
extern PFNCGISEFFECTPROC cgIsEffect;
extern PFNCGGETFIRSTEFFECTPROC cgGetFirstEffect;
extern PFNCGGETNEXTEFFECTPROC cgGetNextEffect;
extern PFNCGCREATEPROGRAMFROMEFFECTPROC cgCreateProgramFromEffect;
extern PFNCGGETFIRSTTECHNIQUEPROC cgGetFirstTechnique;
extern PFNCGGETNEXTTECHNIQUEPROC cgGetNextTechnique;
extern PFNCGGETNAMEDTECHNIQUEPROC cgGetNamedTechnique;
extern PFNCGGETTECHNIQUENAMEPROC cgGetTechniqueName;
extern PFNCGISTECHNIQUEPROC cgIsTechnique;
extern PFNCGVALIDATETECHNIQUEPROC cgValidateTechnique;
extern PFNCGISTECHNIQUEVALIDATEDPROC cgIsTechniqueValidated;
extern PFNCGGETTECHNIQUEEFFECTPROC cgGetTechniqueEffect;
extern PFNCGGETFIRSTPASSPROC cgGetFirstPass;
extern PFNCGGETNAMEDPASSPROC cgGetNamedPass;
extern PFNCGGETNEXTPASSPROC cgGetNextPass;
extern PFNCGISPASSPROC cgIsPass;
extern PFNCGGETPASSNAMEPROC cgGetPassName;
extern PFNCGGETPASSTECHNIQUEPROC cgGetPassTechnique;
extern PFNCGGETPASSPROGRAMPROC cgGetPassProgram;
extern PFNCGSETPASSSTATEPROC cgSetPassState;
extern PFNCGRESETPASSSTATEPROC cgResetPassState;
extern PFNCGGETFIRSTSTATEASSIGNMENTPROC cgGetFirstStateAssignment;
extern PFNCGGETNAMEDSTATEASSIGNMENTPROC cgGetNamedStateAssignment;
extern PFNCGGETNEXTSTATEASSIGNMENTPROC cgGetNextStateAssignment;
extern PFNCGISSTATEASSIGNMENTPROC cgIsStateAssignment;
extern PFNCGCALLSTATESETCALLBACKPROC cgCallStateSetCallback;
extern PFNCGCALLSTATEVALIDATECALLBACKPROC cgCallStateValidateCallback;
extern PFNCGCALLSTATERESETCALLBACKPROC cgCallStateResetCallback;
extern PFNCGGETSTATEASSIGNMENTPASSPROC cgGetStateAssignmentPass;
extern PFNCGGETSAMPLERSTATEASSIGNMENTPARAMETERPROC cgGetSamplerStateAssignmentParameter;
extern PFNCGGETFLOATSTATEASSIGNMENTVALUESPROC cgGetFloatStateAssignmentValues;
extern PFNCGGETINTSTATEASSIGNMENTVALUESPROC cgGetIntStateAssignmentValues;
extern PFNCGGETBOOLSTATEASSIGNMENTVALUESPROC cgGetBoolStateAssignmentValues;
extern PFNCGGETSTRINGSTATEASSIGNMENTVALUEPROC cgGetStringStateAssignmentValue;
extern PFNCGGETPROGRAMSTATEASSIGNMENTVALUEPROC cgGetProgramStateAssignmentValue;
extern PFNCGGETTEXTURESTATEASSIGNMENTVALUEPROC cgGetTextureStateAssignmentValue;
extern PFNCGGETSAMPLERSTATEASSIGNMENTVALUEPROC cgGetSamplerStateAssignmentValue;
extern PFNCGGETSTATEASSIGNMENTINDEXPROC cgGetStateAssignmentIndex;
extern PFNCGGETNUMDEPENDENTSTATEASSIGNMENTPARAMETERSPROC cgGetNumDependentStateAssignmentParameters;
extern PFNCGGETDEPENDENTSTATEASSIGNMENTPARAMETERPROC cgGetDependentStateAssignmentParameter;
extern PFNCGGETNUMDEPENDENTPROGRAMARRAYSTATEASSIGNMENTPARAMETERSPROC cgGetNumDependentProgramArrayStateAssignmentParameters;
extern PFNCGGETDEPENDENTPROGRAMARRAYSTATEASSIGNMENTPARAMETERPROC cgGetDependentProgramArrayStateAssignmentParameter;
extern PFNCGGETCONNECTEDSTATEASSIGNMENTPARAMETERPROC cgGetConnectedStateAssignmentParameter;
extern PFNCGGETSTATEASSIGNMENTSTATEPROC cgGetStateAssignmentState;
extern PFNCGGETSAMPLERSTATEASSIGNMENTSTATEPROC cgGetSamplerStateAssignmentState;
extern PFNCGCREATESTATEPROC cgCreateState;
extern PFNCGCREATEARRAYSTATEPROC cgCreateArrayState;
extern PFNCGSETSTATECALLBACKSPROC cgSetStateCallbacks;
extern PFNCGSETSTATELATESTPROFILEPROC cgSetStateLatestProfile;
extern PFNCGGETSTATESETCALLBACKPROC cgGetStateSetCallback;
extern PFNCGGETSTATERESETCALLBACKPROC cgGetStateResetCallback;
extern PFNCGGETSTATEVALIDATECALLBACKPROC cgGetStateValidateCallback;
extern PFNCGGETSTATELATESTPROFILEPROC cgGetStateLatestProfile;
extern PFNCGGETSTATECONTEXTPROC cgGetStateContext;
extern PFNCGGETSTATETYPEPROC cgGetStateType;
extern PFNCGGETSTATENAMEPROC cgGetStateName;
extern PFNCGGETNAMEDSTATEPROC cgGetNamedState;
extern PFNCGGETFIRSTSTATEPROC cgGetFirstState;
extern PFNCGGETNEXTSTATEPROC cgGetNextState;
extern PFNCGISSTATEPROC cgIsState;
extern PFNCGADDSTATEENUMERANTPROC cgAddStateEnumerant;
extern PFNCGCREATESAMPLERSTATEPROC cgCreateSamplerState;
extern PFNCGCREATEARRAYSAMPLERSTATEPROC cgCreateArraySamplerState;
extern PFNCGGETNAMEDSAMPLERSTATEPROC cgGetNamedSamplerState;
extern PFNCGGETFIRSTSAMPLERSTATEPROC cgGetFirstSamplerState;
extern PFNCGGETFIRSTSAMPLERSTATEASSIGNMENTPROC cgGetFirstSamplerStateAssignment;
extern PFNCGGETNAMEDSAMPLERSTATEASSIGNMENTPROC cgGetNamedSamplerStateAssignment;
extern PFNCGSETSAMPLERSTATEPROC cgSetSamplerState;
extern PFNCGGETNAMEDEFFECTPARAMETERPROC cgGetNamedEffectParameter;
extern PFNCGGETFIRSTLEAFEFFECTPARAMETERPROC cgGetFirstLeafEffectParameter;
extern PFNCGGETFIRSTEFFECTPARAMETERPROC cgGetFirstEffectParameter;
extern PFNCGGETEFFECTPARAMETERBYSEMANTICPROC cgGetEffectParameterBySemantic;
extern PFNCGGETFIRSTTECHNIQUEANNOTATIONPROC cgGetFirstTechniqueAnnotation;
extern PFNCGGETFIRSTPASSANNOTATIONPROC cgGetFirstPassAnnotation;
extern PFNCGGETFIRSTPARAMETERANNOTATIONPROC cgGetFirstParameterAnnotation;
extern PFNCGGETFIRSTPROGRAMANNOTATIONPROC cgGetFirstProgramAnnotation;
extern PFNCGGETFIRSTEFFECTANNOTATIONPROC cgGetFirstEffectAnnotation;
extern PFNCGGETNEXTANNOTATIONPROC cgGetNextAnnotation;
extern PFNCGGETNAMEDTECHNIQUEANNOTATIONPROC cgGetNamedTechniqueAnnotation;
extern PFNCGGETNAMEDPASSANNOTATIONPROC cgGetNamedPassAnnotation;
extern PFNCGGETNAMEDPARAMETERANNOTATIONPROC cgGetNamedParameterAnnotation;
extern PFNCGGETNAMEDPROGRAMANNOTATIONPROC cgGetNamedProgramAnnotation;
extern PFNCGGETNAMEDEFFECTANNOTATIONPROC cgGetNamedEffectAnnotation;
extern PFNCGISANNOTATIONPROC cgIsAnnotation;
extern PFNCGGETANNOTATIONNAMEPROC cgGetAnnotationName;
extern PFNCGGETANNOTATIONTYPEPROC cgGetAnnotationType;
extern PFNCGGETFLOATANNOTATIONVALUESPROC cgGetFloatAnnotationValues;
extern PFNCGGETINTANNOTATIONVALUESPROC cgGetIntAnnotationValues;
extern PFNCGGETSTRINGANNOTATIONVALUEPROC cgGetStringAnnotationValue;
extern PFNCGGETSTRINGANNOTATIONVALUESPROC cgGetStringAnnotationValues;
extern PFNCGGETBOOLANNOTATIONVALUESPROC cgGetBoolAnnotationValues;
extern PFNCGGETBOOLEANANNOTATIONVALUESPROC cgGetBooleanAnnotationValues;
extern PFNCGGETNUMDEPENDENTANNOTATIONPARAMETERSPROC cgGetNumDependentAnnotationParameters;
extern PFNCGGETDEPENDENTANNOTATIONPARAMETERPROC cgGetDependentAnnotationParameter;
extern PFNCGEVALUATEPROGRAMPROC cgEvaluateProgram;
extern PFNCGSETEFFECTNAMEPROC cgSetEffectName;
extern PFNCGGETEFFECTNAMEPROC cgGetEffectName;
extern PFNCGGETNAMEDEFFECTPROC cgGetNamedEffect;
extern PFNCGCREATEEFFECTPARAMETERPROC cgCreateEffectParameter;
extern PFNCGCREATETECHNIQUEPROC cgCreateTechnique;
extern PFNCGCREATEEFFECTPARAMETERARRAYPROC cgCreateEffectParameterArray;
extern PFNCGCREATEEFFECTPARAMETERMULTIDIMARRAYPROC cgCreateEffectParameterMultiDimArray;
extern PFNCGCREATEPASSPROC cgCreatePass;
extern PFNCGCREATESTATEASSIGNMENTPROC cgCreateStateAssignment;
extern PFNCGCREATESTATEASSIGNMENTINDEXPROC cgCreateStateAssignmentIndex;
extern PFNCGCREATESAMPLERSTATEASSIGNMENTPROC cgCreateSamplerStateAssignment;
extern PFNCGSETFLOATSTATEASSIGNMENTPROC cgSetFloatStateAssignment;
extern PFNCGSETINTSTATEASSIGNMENTPROC cgSetIntStateAssignment;
extern PFNCGSETBOOLSTATEASSIGNMENTPROC cgSetBoolStateAssignment;
extern PFNCGSETSTRINGSTATEASSIGNMENTPROC cgSetStringStateAssignment;
extern PFNCGSETPROGRAMSTATEASSIGNMENTPROC cgSetProgramStateAssignment;
extern PFNCGSETSAMPLERSTATEASSIGNMENTPROC cgSetSamplerStateAssignment;
extern PFNCGSETTEXTURESTATEASSIGNMENTPROC cgSetTextureStateAssignment;
extern PFNCGSETFLOATARRAYSTATEASSIGNMENTPROC cgSetFloatArrayStateAssignment;
extern PFNCGSETINTARRAYSTATEASSIGNMENTPROC cgSetIntArrayStateAssignment;
extern PFNCGSETBOOLARRAYSTATEASSIGNMENTPROC cgSetBoolArrayStateAssignment;
extern PFNCGCREATETECHNIQUEANNOTATIONPROC cgCreateTechniqueAnnotation;
extern PFNCGCREATEPASSANNOTATIONPROC cgCreatePassAnnotation;
extern PFNCGCREATEPARAMETERANNOTATIONPROC cgCreateParameterAnnotation;
extern PFNCGCREATEPROGRAMANNOTATIONPROC cgCreateProgramAnnotation;
extern PFNCGCREATEEFFECTANNOTATIONPROC cgCreateEffectAnnotation;
extern PFNCGSETINTANNOTATIONPROC cgSetIntAnnotation;
extern PFNCGSETFLOATANNOTATIONPROC cgSetFloatAnnotation;
extern PFNCGSETBOOLANNOTATIONPROC cgSetBoolAnnotation;
extern PFNCGSETSTRINGANNOTATIONPROC cgSetStringAnnotation;
extern PFNCGGETNUMSTATEENUMERANTSPROC cgGetNumStateEnumerants;
extern PFNCGGETSTATEENUMERANTPROC cgGetStateEnumerant;
extern PFNCGGETSTATEENUMERANTNAMEPROC cgGetStateEnumerantName;
extern PFNCGGETSTATEENUMERANTVALUEPROC cgGetStateEnumerantValue;
extern PFNCGGETPARAMETEREFFECTPROC cgGetParameterEffect;
extern PFNCGGETTYPECLASSPROC cgGetTypeClass;
extern PFNCGGETTYPEBASEPROC cgGetTypeBase;
extern PFNCGGETTYPESIZESPROC cgGetTypeSizes;
extern PFNCGGETMATRIXSIZEPROC cgGetMatrixSize;
extern PFNCGGETNUMPROGRAMDOMAINSPROC cgGetNumProgramDomains;
extern PFNCGGETPROFILEDOMAINPROC cgGetProfileDomain;
extern PFNCGCOMBINEPROGRAMSPROC cgCombinePrograms;
extern PFNCGCOMBINEPROGRAMS2PROC cgCombinePrograms2;
extern PFNCGCOMBINEPROGRAMS3PROC cgCombinePrograms3;
extern PFNCGCOMBINEPROGRAMS4PROC cgCombinePrograms4;
extern PFNCGCOMBINEPROGRAMS5PROC cgCombinePrograms5;
extern PFNCGGETPROGRAMDOMAINPROFILEPROC cgGetProgramDomainProfile;
extern PFNCGGETPROGRAMDOMAINPROGRAMPROC cgGetProgramDomainProgram;
extern PFNCGCREATEOBJPROC cgCreateObj;
extern PFNCGCREATEOBJFROMFILEPROC cgCreateObjFromFile;
extern PFNCGDESTROYOBJPROC cgDestroyObj;
extern PFNCGGETPARAMETERRESOURCESIZEPROC cgGetParameterResourceSize;
extern PFNCGGETPARAMETERRESOURCETYPEPROC cgGetParameterResourceType;
extern PFNCGGETPARAMETERRESOURCENAMEPROC cgGetParameterResourceName;
extern PFNCGGETPARAMETERBUFFERINDEXPROC cgGetParameterBufferIndex;
extern PFNCGGETPARAMETERBUFFEROFFSETPROC cgGetParameterBufferOffset;
extern PFNCGCREATEBUFFERPROC cgCreateBuffer;
extern PFNCGSETBUFFERDATAPROC cgSetBufferData;
extern PFNCGSETBUFFERSUBDATAPROC cgSetBufferSubData;
extern PFNCGSETPROGRAMBUFFERPROC cgSetProgramBuffer;
extern PFNCGMAPBUFFERPROC cgMapBuffer;
extern PFNCGUNMAPBUFFERPROC cgUnmapBuffer;
extern PFNCGDESTROYBUFFERPROC cgDestroyBuffer;
extern PFNCGGETPROGRAMBUFFERPROC cgGetProgramBuffer;
extern PFNCGGETBUFFERSIZEPROC cgGetBufferSize;
extern PFNCGGETPROGRAMBUFFERMAXSIZEPROC cgGetProgramBufferMaxSize;
extern PFNCGGETPROGRAMBUFFERMAXINDEXPROC cgGetProgramBufferMaxIndex;
extern PFNCGGETEFFECTPARAMETERBUFFERPROC cgGetEffectParameterBuffer;
extern PFNCGSETEFFECTPARAMETERBUFFERPROC cgSetEffectParameterBuffer;

#ifdef __cplusplus
}
#endif

#endif
