/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*-
 *
 * nautilus-burn-drive.h: easy to use cd burner software
 *
 * Copyright (C) 2002-2004 Red Hat, Inc.
 * Copyright (C) 2005 William Jon McCann <mccann@jhu.edu>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Alexander Larsson <alexl@redhat.com>
 *          Bastien Nocera <hadess@hadess.net>
 *          William Jon McCann <mccann@jhu.edu>
 */

#ifndef NAUTILUS_BURN_DRIVE_COMMON_H
#define NAUTILUS_BURN_DRIVE_COMMON_H

#include <nautilus-burn-drive.h>

G_BEGIN_DECLS

#ifndef INVALID_HANDLE
#define INVALID_HANDLE (GINT_TO_POINTER(-1))
#endif

#define CD_ROM_SPEED 176

typedef struct
{
  const char *name;
  gboolean can_write_cdr;
  gboolean can_write_cdrw;
  gboolean can_write_dvdr;
  gboolean can_write_dvdram;
} NautilusBurnWhiteDrive;

void     nautilus_burn_drive_add_dvd_plus      (NautilusBurnDrive *drive);
void     nautilus_burn_drive_add_whitelist     (NautilusBurnDrive *drive);
void     nautilus_burn_drive_set_monitor       (NautilusBurnDrive *drive, 
                                                gboolean          enabled);
void     nautilus_burn_drive_get_cd_properties (NautilusBurnDrive *drive);

int      get_device_max_write_speed (char       *device);

gpointer open_ioctl_handle          (const char *device);
void     close_ioctl_handle         (gpointer   handle);

NautilusBurnMediaType nautilus_burn_drive_get_media_type_from_path_full (const char *device);

G_END_DECLS

#endif
