/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2008 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "ogmrip-lavc-mpeg4.h"
#include "ogmrip-plugin.h"

#include <glib/gi18n-lib.h>

G_DEFINE_TYPE (OGMRipLavcMpeg4, ogmrip_lavc_mpeg4, OGMRIP_TYPE_LAVC)

static void
ogmrip_lavc_mpeg4_class_init (OGMRipLavcMpeg4Class *klass)
{
}

static void
ogmrip_lavc_mpeg4_init (OGMRipLavcMpeg4 *lavc_mpeg4)
{
}

/**
 * ogmrip_lavc_mpeg4_new:
 * @title: An #OGMDvdTitle
 * @output: The output file
 *
 * Creates a new #OGMRipLavcMpeg4.
 *
 * Returns: the new #OGMRipLavcMpeg4
 */
OGMJobSpawn *
ogmrip_lavc_mpeg4_new (OGMDvdTitle *title, const gchar *output)
{
  g_return_val_if_fail (title != NULL, NULL);
  g_return_val_if_fail (output && *output, NULL);

  return g_object_new (OGMRIP_TYPE_LAVC_MPEG4, "input", title, "output", output, NULL);
}

static OGMRipVideoPlugin lavc_mpeg4_plugin =
{
  NULL,
  G_TYPE_NONE,
  "lavc-mpeg4",
  N_("Lavc Mpeg-4"),
  OGMRIP_FORMAT_MPEG4,
  G_MAXINT,
  8
};

OGMRipVideoPlugin *
ogmrip_init_plugin (void)
{
  gchar *output;
  gboolean match;

  if (!g_spawn_command_line_sync ("mencoder -ovc help", &output, NULL, NULL, NULL))
    return NULL;

  match = g_regex_match_simple ("^ *lavc *- .*$", output, G_REGEX_MULTILINE, 0);
  g_free (output);

  if (!match)
    return NULL;

  lavc_mpeg4_plugin.type = OGMRIP_TYPE_LAVC_MPEG4;

  return &lavc_mpeg4_plugin;
}

