/* OGMRip - A DVD Encoder for GNOME
 * Copyright (C) 2004-2009 Olivier Rolland <billl@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "ogmrip-gconf.h"
#include "ogmrip-helper.h"
#include "ogmrip-preferences.h"
#include "ogmrip-plugin.h"

#include <string.h>

GType
ogmrip_gconf_get_container_type (const gchar *name)
{
  GType container;
  gchar *str;

  if (name)
    str = g_strdup (name);
  else
    str = ogmrip_preferences_get_string (OGMRIP_GCONF_CONTAINER_FORMAT, OGMRIP_DEFAULT_CONTAINER_FORMAT);
  container = ogmrip_plugin_get_container_by_name (str);
  g_free (str);

  return container;
}

GType
ogmrip_gconf_get_video_codec_type (const gchar *name)
{
  GType codec;
  gchar *str;

  if (name)
    str = g_strdup (name);
  else
    str = ogmrip_preferences_get_string (OGMRIP_GCONF_VIDEO_CODEC, OGMRIP_DEFAULT_VIDEO_CODEC);
  codec = ogmrip_plugin_get_video_codec_by_name (str);
  g_free (str);

  return codec;
}

GType
ogmrip_gconf_get_audio_codec_type (const gchar *name)
{
  GType codec;
  gchar *str;

  if (name)
    str = g_strdup (name);
  else
    str = ogmrip_preferences_get_string (OGMRIP_GCONF_AUDIO_CODEC, OGMRIP_DEFAULT_AUDIO_CODEC);
  codec = ogmrip_plugin_get_audio_codec_by_name (str);
  g_free (str);

  return codec;
}

GType
ogmrip_gconf_get_subp_codec_type (const gchar *name)
{
  GType codec;
  gchar *str;

  if (name)
    str = g_strdup (name);
  else
    str = ogmrip_preferences_get_string (OGMRIP_GCONF_SUBP_CODEC, OGMRIP_DEFAULT_SUBP_CODEC);
  codec = ogmrip_plugin_get_subp_codec_by_name (str);
  g_free (str);

  return codec;
}

