// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepLib_FindSurface_HeaderFile
#define _BRepLib_FindSurface_HeaderFile

#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopLoc_Location_HeaderFile
#include <TopLoc_Location.hxx>
#endif
class Geom_Surface;
class Standard_NoSuchObject;
class TopoDS_Shape;
class TopLoc_Location;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides an  algorithm to find  a Surface  through a <br>
//!          set of edges. <br>
//! <br>
//!          The edges  of  the  shape  given  as  argument are <br>
//!          explored if they are not coplanar at  the required <br>
//!          tolerance  the method Found returns false. <br>
//! <br>
//!          If a null tolerance is given the max of the  edges <br>
//!          tolerances is used. <br>
//! <br>
//!          The method Tolerance returns the true distance  of <br>
//!          the edges to the Surface. <br>
//! <br>
//!          The method Surface returns the Surface if found. <br>
//! <br>
//!          The method Existed  returns returns  True  if  the <br>
//!          Surface was already attached to some of the edges. <br>
//! <br>
//!          When Existed  returns True  the  Surface  may have a <br>
//!          location given by the Location method. <br>
class BRepLib_FindSurface  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepLib_FindSurface();

//! Computes the Surface from the edges of  <S> with the <br>
//!          given tolerance. <br>
//!          if <OnlyPlane> is true, the computed surface will be <br>
//!          a plane. If it is not possible to find a plane, the <br>
//!          flag NotDone will be set. <br>
Standard_EXPORT BRepLib_FindSurface(const TopoDS_Shape& S,const Standard_Real Tol = -1,const Standard_Boolean OnlyPlane = Standard_False);

//! Computes the Surface from the edges of  <S> with the <br>
//!          given tolerance. <br>
//!          if <OnlyPlane> is true, the computed surface will be <br>
//!          a plane. If it is not possible to find a plane, the <br>
//!          flag NotDone will be set. <br>
Standard_EXPORT   void Init(const TopoDS_Shape& S,const Standard_Real Tol = -1,const Standard_Boolean OnlyPlane = Standard_False) ;


Standard_EXPORT   Standard_Boolean Found() const;


Standard_EXPORT   Handle_Geom_Surface Surface() const;


Standard_EXPORT   Standard_Real Tolerance() const;


Standard_EXPORT   Standard_Real ToleranceReached() const;


Standard_EXPORT   Standard_Boolean Existed() const;


Standard_EXPORT   TopLoc_Location Location() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Geom_Surface mySurface;
Standard_Real myTolerance;
Standard_Real myTolReached;
Standard_Boolean isExisted;
TopLoc_Location myLocation;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
