// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BlendFunc_HeaderFile
#define _BlendFunc_HeaderFile

#ifndef _BlendFunc_SectionShape_HeaderFile
#include <BlendFunc_SectionShape.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Convert_ParameterisationType_HeaderFile
#include <Convert_ParameterisationType.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
class TColStd_Array1OfReal;
class TColStd_Array1OfInteger;
class BlendFunc_CurveTool;
class BlendFunc_SurfaceTool;
class BlendFunc_ConstRad;
class BlendFunc_ConstRadInv;
class BlendFunc_Ruled;
class BlendFunc_RuledInv;
class BlendFunc_EvolRad;
class BlendFunc_EvolRadInv;
class BlendFunc_CSConstRad;
class BlendFunc_CSCircular;
class BlendFunc_Corde;
class BlendFunc_Chamfer;
class BlendFunc_ChamfInv;
class BlendFunc_ChAsym;
class BlendFunc_ChAsymInv;
class BlendFunc_Tensor;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This package provides a set of generic functions, that can <br>
//!          instantiated to compute blendings between two surfaces <br>
//!          (Constant radius, Evolutive radius, Ruled surface). <br>
class BlendFunc  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT static  void GetShape(const BlendFunc_SectionShape SectShape,const Standard_Real MaxAng,Standard_Integer& NbPoles,Standard_Integer& NbKnots,Standard_Integer& Degree,Convert_ParameterisationType& TypeConv) ;


Standard_EXPORT static  void Knots(const BlendFunc_SectionShape SectShape,TColStd_Array1OfReal& TKnots) ;


Standard_EXPORT static  void Mults(const BlendFunc_SectionShape SectShape,TColStd_Array1OfInteger& TMults) ;


Standard_EXPORT static  void GetMinimalWeights(const BlendFunc_SectionShape SectShape,const Convert_ParameterisationType TConv,const Standard_Real AngleMin,const Standard_Real AngleMax,TColStd_Array1OfReal& Weigths) ;


Standard_EXPORT static  GeomAbs_Shape NextShape(const GeomAbs_Shape S) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class BlendFunc_CurveTool;
friend class BlendFunc_SurfaceTool;
friend class BlendFunc_ConstRad;
friend class BlendFunc_ConstRadInv;
friend class BlendFunc_Ruled;
friend class BlendFunc_RuledInv;
friend class BlendFunc_EvolRad;
friend class BlendFunc_EvolRadInv;
friend class BlendFunc_CSConstRad;
friend class BlendFunc_CSCircular;
friend class BlendFunc_Corde;
friend class BlendFunc_Chamfer;
friend class BlendFunc_ChamfInv;
friend class BlendFunc_ChAsym;
friend class BlendFunc_ChAsymInv;
friend class BlendFunc_Tensor;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
