// File generated by CPPExt (Storable)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntRes2d_IntersectionPoint_HeaderFile
#define _IntRes2d_IntersectionPoint_HeaderFile

#ifndef _gp_Pnt2d_HeaderFile
#include <gp_Pnt2d.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _IntRes2d_Transition_HeaderFile
#include <IntRes2d_Transition.hxx>
#endif
#ifndef _Standard_Storable_HeaderFile
#include <Standard_Storable.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif
class gp_Pnt2d;
class IntRes2d_Transition;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

Standard_EXPORT Handle_Standard_Type& IntRes2d_IntersectionPoint_Type_();

//! Definition of an intersection point between two <br>
//!          2D curves. <br>
class IntRes2d_IntersectionPoint  {

public:
    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }

 // Methods PUBLIC
 // 

//! Empty constructor. <br>
Standard_EXPORT IntRes2d_IntersectionPoint();
//! Creates an IntersectionPoint. <br>
//!          if ReversedFlag is False, the parameter Uc1(resp. Uc2) <br>
//!          and the Transition Trans1 (resp. Trans2) refer to <br>
//!          the first curve (resp. second curve) otherwise Uc1 <br>
//!          and Trans1 (resp. Uc2 and Trans2) refer to the <br>
//!          second curve (resp. the first curve). <br>
IntRes2d_IntersectionPoint(const gp_Pnt2d& P,const Standard_Real Uc1,const Standard_Real Uc2,const IntRes2d_Transition& Trans1,const IntRes2d_Transition& Trans2,const Standard_Boolean ReversedFlag);
//! Sets the values for an existing intersection <br>
//!          point. The meaning of the parameters are the same <br>
//!          as for the Create. <br>
  void SetValues(const gp_Pnt2d& P,const Standard_Real Uc1,const Standard_Real Uc2,const IntRes2d_Transition& Trans1,const IntRes2d_Transition& Trans2,const Standard_Boolean ReversedFlag) ;
//! Returns the value of the coordinates of the <br>
//!          intersection point in the 2D space. <br>
 const gp_Pnt2d& Value() const;
//! Returns the parameter on the first curve. <br>
  Standard_Real ParamOnFirst() const;
//! Returns the parameter on the second curve. <br>
  Standard_Real ParamOnSecond() const;
//! Returns the transition of the 1st curve compared to <br>
//!          the 2nd one. <br>
 const IntRes2d_Transition& TransitionOfFirst() const;
//! returns the transition of the 2nd curve compared to <br>
//!          the 1st one. <br>
 const IntRes2d_Transition& TransitionOfSecond() const;
    const gp_Pnt2d& _CSFDB_GetIntRes2d_IntersectionPointpt() const { return pt; }
    Standard_Real _CSFDB_GetIntRes2d_IntersectionPointp1() const { return p1; }
    void _CSFDB_SetIntRes2d_IntersectionPointp1(const Standard_Real p) { p1 = p; }
    Standard_Real _CSFDB_GetIntRes2d_IntersectionPointp2() const { return p2; }
    void _CSFDB_SetIntRes2d_IntersectionPointp2(const Standard_Real p) { p2 = p; }
    const IntRes2d_Transition& _CSFDB_GetIntRes2d_IntersectionPointtrans1() const { return trans1; }
    const IntRes2d_Transition& _CSFDB_GetIntRes2d_IntersectionPointtrans2() const { return trans2; }




 // Type management
 //
 Standard_EXPORT friend Handle_Standard_Type& IntRes2d_IntersectionPoint_Type_();

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Pnt2d pt;
Standard_Real p1;
Standard_Real p2;
IntRes2d_Transition trans1;
IntRes2d_Transition trans2;


};


#include <IntRes2d_IntersectionPoint.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
