// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntTools_FaceFace_HeaderFile
#define _IntTools_FaceFace_HeaderFile

#ifndef _IntPatch_Intersection_HeaderFile
#include <IntPatch_Intersection.hxx>
#endif
#ifndef _IntTools_LineConstructor_HeaderFile
#include <IntTools_LineConstructor.hxx>
#endif
#ifndef _Handle_GeomAdaptor_HSurface_HeaderFile
#include <Handle_GeomAdaptor_HSurface.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _IntTools_SequenceOfCurves_HeaderFile
#include <IntTools_SequenceOfCurves.hxx>
#endif
#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _IntTools_SequenceOfPntOn2Faces_HeaderFile
#include <IntTools_SequenceOfPntOn2Faces.hxx>
#endif
#ifndef _IntSurf_ListOfPntOn2S_HeaderFile
#include <IntSurf_ListOfPntOn2S.hxx>
#endif
#ifndef _Handle_Adaptor3d_TopolTool_HeaderFile
#include <Handle_Adaptor3d_TopolTool.hxx>
#endif
class GeomAdaptor_HSurface;
class StdFail_NotDone;
class TopoDS_Face;
class IntTools_SequenceOfCurves;
class IntTools_SequenceOfPntOn2Faces;
class IntSurf_ListOfPntOn2S;
class Adaptor3d_TopolTool;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class provides the intersection of <br>
//!	    face's underlying surfaces. <br>
class IntTools_FaceFace  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor. <br>
Standard_EXPORT IntTools_FaceFace();


//! Modifier <br>
Standard_EXPORT   void SetParameters(const Standard_Boolean ApproxCurves,const Standard_Boolean ComputeCurveOnS1,const Standard_Boolean ComputeCurveOnS2,const Standard_Real ApproximationTolerance) ;


//! Intersects underliing surfaces of F1 and F2 <br>
//! Use sum of tolerance of F1 and F2 as intersection <br>
//! criteria <br>
Standard_EXPORT   void Perform(const TopoDS_Face& F1,const TopoDS_Face& F2) ;


//! Returns True if the intersection was successful <br>
Standard_EXPORT   Standard_Boolean IsDone() const;


//! Returns sequence of 3d curves as result of intersection <br>
Standard_EXPORT  const IntTools_SequenceOfCurves& Lines() const;


//! Returns sequence of 3d curves as result of intersection <br>
Standard_EXPORT  const IntTools_SequenceOfPntOn2Faces& Points() const;


//! Returns tolerance reached during approximation. <br>
//! If approximation was not done, returns zero. <br>
Standard_EXPORT   Standard_Real TolReached3d() const;


//! Returns tolerance reached during approximation. <br>
//! If approximation was not done, returns zero. <br>
Standard_EXPORT   Standard_Real TolReached2d() const;


//! Returns first of processed faces <br>
Standard_EXPORT  const TopoDS_Face& Face1() const;


//! Returns second of processed faces <br>
Standard_EXPORT  const TopoDS_Face& Face2() const;


//! Returns True if faces are tangent <br>
Standard_EXPORT   Standard_Boolean TangentFaces() const;


//! Provides post-processing the result lines, <br>
//! which includes spliting closed curves. <br>
Standard_EXPORT   void PrepareLines3D() ;


Standard_EXPORT   void SetList(IntSurf_ListOfPntOn2S& ListOfPnts) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void MakeCurve(const Standard_Integer Index,const Handle(Adaptor3d_TopolTool)& D1,const Handle(Adaptor3d_TopolTool)& D2) ;


 // Fields PRIVATE
 //
IntPatch_Intersection myIntersector;
IntTools_LineConstructor myLConstruct;
Handle_GeomAdaptor_HSurface myHS1;
Handle_GeomAdaptor_HSurface myHS2;
Standard_Integer myNbrestr;
Standard_Real myTolReached2d;
Standard_Real myTolReached3d;
Standard_Boolean myApprox;
Standard_Boolean myApprox1;
Standard_Boolean myApprox2;
Standard_Real myTolApprox;
IntTools_SequenceOfCurves mySeqOfCurve;
Standard_Boolean myTangentFaces;
TopoDS_Face myFace1;
TopoDS_Face myFace2;
IntTools_SequenceOfPntOn2Faces myPnts;
IntSurf_ListOfPntOn2S myListOfPnts;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
