// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepAlgo_FaceRestrictor_HeaderFile
#define _BRepAlgo_FaceRestrictor_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _TopTools_ListOfShape_HeaderFile
#include <TopTools_ListOfShape.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeListOfShape_HeaderFile
#include <TopTools_DataMapOfShapeListOfShape.hxx>
#endif
class TopoDS_Face;
class TopoDS_Wire;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//!  Builds all  the faces  limited  with a set of non <br>
//!                 jointing   and     planars     wires.    if <br>
//!          <ControlOrientation> is false  The Wires must have <br>
//!          correct orientations.  Sinon orientation des wires <br>
//!          de telle sorte que les faces ne soient pas infinies <br>
//!          et qu'elles soient disjointes. <br>
class BRepAlgo_FaceRestrictor  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepAlgo_FaceRestrictor();

//! the surface of <F> will be the the surface of each new <br>
//!          faces built. <br>
//!          <Proj> is used to update pcurves on edges if necessary. <br>
//!          See Add(). <br>
Standard_EXPORT   void Init(const TopoDS_Face& F,const Standard_Boolean Proj = Standard_False,const Standard_Boolean ControlOrientation = Standard_False) ;

//! Add the wire <W> to the set of wires. <br>
//! <br>
//!  Warning: <br>
//!          The Wires must be closed. <br>
//! <br>
//!          The edges of <W> can be modified if they  have not pcurves <br>
//!          on the surface <S>  of <F>. In this  case <br>
//!          if <Proj> is false the first pcurve of  the edge <br>
//!          is positionned on <S>. <br>
//!          if <Proj> is True ,the Pcurve On <S> is the <br>
//!          projection of the  curve 3d on <F>. <br>
Standard_EXPORT   void Add(TopoDS_Wire& W) ;

//! Removes all the Wires <br>
Standard_EXPORT   void Clear() ;

//! Evaluate all the faces limited by the set of Wires. <br>
Standard_EXPORT   void Perform() ;


Standard_EXPORT   Standard_Boolean IsDone() const;


Standard_EXPORT   Standard_Boolean More() const;


Standard_EXPORT   void Next() ;


Standard_EXPORT   TopoDS_Face Current() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Evaluate all the faces limited by the set of Wires. <br>
Standard_EXPORT   void PerformWithCorrection() ;


 // Fields PRIVATE
 //
Standard_Boolean myDone;
Standard_Boolean modeProj;
TopoDS_Face myFace;
TopTools_ListOfShape wires;
TopTools_ListOfShape faces;
Standard_Boolean myCorrection;
TopTools_DataMapOfShapeListOfShape keyIsIn;
TopTools_DataMapOfShapeListOfShape keyContains;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
