// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Bnd_Box_HeaderFile
#define _Bnd_Box_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_ConstructionError;
class gp_Pnt;
class gp_Dir;
class gp_Trsf;
class gp_Lin;
class gp_Pln;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes a bounding box in 3D space. <br>
//! A bounding box is parallel to the axes of the coordinates <br>
//! system. If it is finite, it is defined by the three intervals: <br>
//! -   [ Xmin,Xmax ], <br>
//! -   [ Ymin,Ymax ], <br>
//! -   [ Zmin,Zmax ]. <br>
//! A bounding box may be infinite (i.e. open) in one or more <br>
//! directions. It is said to be: <br>
//! -   OpenXmin if it is infinite on the negative side of the   "X Direction"; <br>
//! -   OpenXmax if it is infinite on the positive side of the "X Direction"; <br>
//! -   OpenYmin if it is infinite on the negative side of the   "Y Direction"; <br>
//! -   OpenYmax if it is infinite on the positive side of the "Y Direction"; <br>
//! -   OpenZmin if it is infinite on the negative side of the   "Z Direction"; <br>
//! -   OpenZmax if it is infinite on the positive side of the "Z Direction"; <br>
//! -   WholeSpace if it is infinite in all six directions. In this <br>
//!   case, any point of the space is inside the box; <br>
//! -   Void if it is empty. In this case, there is no point included in the box. <br>
//!   A bounding box is defined by: <br>
//! -   six bounds (Xmin, Xmax, Ymin, Ymax, Zmin and <br>
//!   Zmax) which limit the bounding box if it is finite, <br>
//! -   eight flags (OpenXmin, OpenXmax, OpenYmin, <br>
//!   OpenYmax, OpenZmin, OpenZmax, <br>
//!   WholeSpace and Void) which describe the <br>
//!   bounding box if it is infinite or empty, and <br>
//! -   a gap, which is included on both sides in any direction <br>
//!   when consulting the finite bounds of the box. <br>
class Bnd_Box  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an empty Box. <br>
//! The constructed box is qualified Void. Its gap is null. <br>
Standard_EXPORT Bnd_Box();

//! Sets this bounding box so that it  covers the whole of 3D space. <br>
//!        It is infinitely  long in all directions. <br>
Standard_EXPORT   void SetWhole() ;

//! Sets this bounding box so that it is empty. All points are outside a void box. <br>
Standard_EXPORT   void SetVoid() ;

//! Sets this bounding box so that it bounds <br>
//! -   the point P. This involves first setting this bounding box <br>
//!   to be void and then adding the point P. <br>
Standard_EXPORT   void Set(const gp_Pnt& P) ;

//! Sets this bounding box so that it bounds <br>
//!   the half-line defined by point P and direction D, i.e. all <br>
//!   points M defined by M=P+u*D, where u is greater than <br>
//!   or equal to 0, are inside the bounding volume. This <br>
//!   involves first setting this box to be void and then adding   the half-line. <br>
Standard_EXPORT   void Set(const gp_Pnt& P,const gp_Dir& D) ;

//! Enlarges this bounding box, if required, so that it <br>
//!          contains at least: <br>
//!   -   interval [ aXmin,aXmax ] in the "X Direction", <br>
//!   -   interval [ aYmin,aYmax ] in the "Y Direction", <br>
//!   -   interval [ aZmin,aZmax ] in the "Z Direction"; <br>
Standard_EXPORT   void Update(const Standard_Real aXmin,const Standard_Real aYmin,const Standard_Real aZmin,const Standard_Real aXmax,const Standard_Real aYmax,const Standard_Real aZmax) ;

//!  Adds a point of coordinates (X,Y,Z) to this bounding box. <br>
Standard_EXPORT   void Update(const Standard_Real X,const Standard_Real Y,const Standard_Real Z) ;

//! Returns the gap of this bounding box. <br>
Standard_EXPORT   Standard_Real GetGap() const;

//! Set the gap of this bounding box to abs(Tol). <br>
Standard_EXPORT   void SetGap(const Standard_Real Tol) ;

//! Enlarges the      box    with    a   tolerance   value. <br>
//!          (minvalues-Abs(<tol>) and maxvalues+Abs(<tol>)) <br>
//!	This means that the minimum values of its X, Y and Z <br>
//! intervals of definition, when they are finite, are reduced by <br>
//! the absolute value of Tol, while the maximum values are <br>
//! increased by the same amount. <br>
Standard_EXPORT   void Enlarge(const Standard_Real Tol) ;

//! Returns the bounds of this bounding box. The gap is included. <br>
//! If this bounding box is infinite (i.e. "open"), returned values <br>
//! may be equal to +/- Precision::Infinite(). <br>
//! if IsVoid() <br>
Standard_EXPORT   void Get(Standard_Real& aXmin,Standard_Real& aYmin,Standard_Real& aZmin,Standard_Real& aXmax,Standard_Real& aYmax,Standard_Real& aZmax) const;

//! The   Box will be   infinitely   long  in the Xmin <br>
//!          direction. <br>
Standard_EXPORT   void OpenXmin() ;

//! The   Box will be   infinitely   long  in the Xmax <br>
//!          direction. <br>
Standard_EXPORT   void OpenXmax() ;

//! The   Box will be   infinitely   long  in the Ymin <br>
//!          direction. <br>
Standard_EXPORT   void OpenYmin() ;

//! The   Box will be   infinitely   long  in the Ymax <br>
//!          direction. <br>
Standard_EXPORT   void OpenYmax() ;

//! The   Box will be   infinitely   long  in the Zmin <br>
//!          direction. <br>
Standard_EXPORT   void OpenZmin() ;

//! The   Box will be   infinitely   long  in the Zmax <br>
//!          direction. <br>
Standard_EXPORT   void OpenZmax() ;

//! Returns true if this bounding box is open in the  Xmin direction. <br>
Standard_EXPORT   Standard_Boolean IsOpenXmin() const;

//! Returns true if this bounding box is open in the  Xmax direction. <br>
Standard_EXPORT   Standard_Boolean IsOpenXmax() const;

//! Returns true if this bounding box is open in the  Ymix direction. <br>
Standard_EXPORT   Standard_Boolean IsOpenYmin() const;

//! Returns true if this bounding box is open in the  Ymax direction. <br>
Standard_EXPORT   Standard_Boolean IsOpenYmax() const;

//! Returns true if this bounding box is open in the  Zmin direction. <br>
Standard_EXPORT   Standard_Boolean IsOpenZmin() const;

//! Returns true if this bounding box is open in the  Zmax  direction. <br>
Standard_EXPORT   Standard_Boolean IsOpenZmax() const;

//! Returns true if this bounding box is infinite in all 6 directions (WholeSpace flag). <br>
Standard_EXPORT   Standard_Boolean IsWhole() const;

//! Returns true if this bounding box is empty (Void flag). <br>
Standard_EXPORT   Standard_Boolean IsVoid() const;

//! true if xmax-xmin < tol. <br>
Standard_EXPORT   Standard_Boolean IsXThin(const Standard_Real tol) const;

//! true if ymax-ymin < tol. <br>
Standard_EXPORT   Standard_Boolean IsYThin(const Standard_Real tol) const;

//! true if zmax-zmin < tol. <br>
Standard_EXPORT   Standard_Boolean IsZThin(const Standard_Real tol) const;

//! Returns true if IsXThin, IsYThin and IsZThin are all true, <br>
//! i.e. if the box is thin in all three dimensions. <br>
Standard_EXPORT   Standard_Boolean IsThin(const Standard_Real tol) const;

//! Returns a bounding box which is the result of applying the <br>
//! transformation T to this bounding box. <br>
//! Warning <br>
//! Applying a geometric transformation (for example, a <br>
//! rotation) to a bounding box generally increases its <br>
//! dimensions. This is not optimal for algorithms which use it. <br>
Standard_EXPORT   Bnd_Box Transformed(const gp_Trsf& T) const;

//! Adds the box <Other> to <me>. <br>
Standard_EXPORT   void Add(const Bnd_Box& Other) ;

//! Adds a Pnt to the box. <br>
Standard_EXPORT   void Add(const gp_Pnt& P) ;

//! Extends  <me> from the Pnt <P> in the direction <D>. <br>
Standard_EXPORT   void Add(const gp_Pnt& P,const gp_Dir& D) ;

//! Extends the Box  in the given Direction, i.e. adds <br>
//!          an  half-line. The   box  may become   infinite in <br>
//!          1,2 or 3 directions. <br>
Standard_EXPORT   void Add(const gp_Dir& D) ;

//! Returns True if the Pnt is out the box. <br>
Standard_EXPORT   Standard_Boolean IsOut(const gp_Pnt& P) const;

//! Returns False if the line intersects the box. <br>
Standard_EXPORT   Standard_Boolean IsOut(const gp_Lin& L) const;

//! Returns False if the plane intersects the box. <br>
Standard_EXPORT   Standard_Boolean IsOut(const gp_Pln& P) const;

//! Returns False if the <Box> intersects or is inside <me>. <br>
Standard_EXPORT   Standard_Boolean IsOut(const Bnd_Box& Other) const;

//! Returns False if  the transformed <Box> intersects <br>
//!          or  is inside <me>. <br>
Standard_EXPORT   Standard_Boolean IsOut(const Bnd_Box& Other,const gp_Trsf& T) const;

//! Returns False  if the transformed <Box> intersects <br>
//!          or  is inside the transformed box <me>. <br>
Standard_EXPORT   Standard_Boolean IsOut(const gp_Trsf& T1,const Bnd_Box& Other,const gp_Trsf& T2) const;

//! Returns False  if the flat band lying between two parallel <br>
//!    	    lines represented by their reference points <P1>, <P2> and <br>
//!          direction <D> intersects the box. <br>
Standard_EXPORT   Standard_Boolean IsOut(const gp_Pnt& P1,const gp_Pnt& P2,const gp_Dir& D) const;

//! Computes the minimum distance between two boxes. <br>
Standard_EXPORT   Standard_Real Distance(const Bnd_Box& Other) const;


Standard_EXPORT   void Dump() const;
//! Computes the squared diagonal of me. <br>
  Standard_Real SquareExtent() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real Xmin;
Standard_Real Xmax;
Standard_Real Ymin;
Standard_Real Ymax;
Standard_Real Zmin;
Standard_Real Zmax;
Standard_Real Gap;
Standard_Integer Flags;


};


#include <Bnd_Box.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
