// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Convert_CylinderToBSplineSurface_HeaderFile
#define _Convert_CylinderToBSplineSurface_HeaderFile

#ifndef _Convert_ElementarySurfaceToBSplineSurface_HeaderFile
#include <Convert_ElementarySurfaceToBSplineSurface.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Standard_DomainError;
class gp_Cylinder;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  This algorithm converts a bounded cylinder into a rational <br>
//!  B-spline surface. The cylinder is a Cylinder from package gp. <br>
//!  The parametrization of the cylinder is  : <br>
//!  P (U, V) = Loc + V * Zdir + Radius * (Xdir*Cos(U) + Ydir*Sin(U)) <br>
//!  where Loc is the location point of the cylinder, Xdir, Ydir and <br>
//!  Zdir are the normalized directions of the local cartesian <br>
//!  coordinate system of the cylinder (Zdir is the direction of the <br>
//!  cylinder's axis). The U parametrization range is U [0, 2PI]. <br>
//! KeyWords : <br>
//!  Convert, Cylinder, BSplineSurface. <br>
class Convert_CylinderToBSplineSurface  : public Convert_ElementarySurfaceToBSplineSurface {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//!  The equivalent B-splineSurface as the same orientation as the <br>
//!  cylinder in the U and V parametric directions. <br>
//!  Raised if U1 = U2 or U1 = U2 + 2.0 * Pi <br>
//!  Raised if V1 = V2. <br>
Standard_EXPORT Convert_CylinderToBSplineSurface(const gp_Cylinder& Cyl,const Standard_Real U1,const Standard_Real U2,const Standard_Real V1,const Standard_Real V2);


//!  The equivalent B-splineSurface as the same orientation as the <br>
//!  cylinder in the U and V parametric directions. <br>
//!  Raised if V1 = V2. <br>
Standard_EXPORT Convert_CylinderToBSplineSurface(const gp_Cylinder& Cyl,const Standard_Real V1,const Standard_Real V2);





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
