// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntTools_TopolTool_HeaderFile
#define _IntTools_TopolTool_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IntTools_TopolTool_HeaderFile
#include <Handle_IntTools_TopolTool.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Adaptor3d_TopolTool_HeaderFile
#include <Adaptor3d_TopolTool.hxx>
#endif
#ifndef _Handle_Adaptor3d_HSurface_HeaderFile
#include <Handle_Adaptor3d_HSurface.hxx>
#endif
class Standard_DomainError;
class Adaptor3d_HSurface;
class gp_Pnt2d;
class gp_Pnt;


//! Class redefine methods of TopolTool from Adaptor3d <br>
//!         concerning sample points <br>
class IntTools_TopolTool : public Adaptor3d_TopolTool {

public:
 // Methods PUBLIC
 // 


//! Empty constructor <br>
Standard_EXPORT IntTools_TopolTool();


//! Initializes me by surface <br>
Standard_EXPORT IntTools_TopolTool(const Handle(Adaptor3d_HSurface)& theSurface);


//! Redefined empty initializer <br>
Standard_EXPORT virtual  void Initialize() ;


//! Initializes me by surface <br>
Standard_EXPORT virtual  void Initialize(const Handle(Adaptor3d_HSurface)& theSurface) ;


//! <br>
Standard_EXPORT virtual  void ComputeSamplePoints() ;


//! Computes the sample-points for the intersections algorithms <br>
Standard_EXPORT virtual  Standard_Integer NbSamplesU() ;


//! Computes the sample-points for the intersections algorithms <br>
Standard_EXPORT virtual  Standard_Integer NbSamplesV() ;


//! Computes the sample-points for the intersections algorithms <br>
Standard_EXPORT virtual  Standard_Integer NbSamples() ;


//! Returns a 2d point from surface myS <br>
//! and a corresponded 3d point <br>
//! for given index. <br>
//! The index should be from 1 to NbSamples() <br>
Standard_EXPORT virtual  void SamplePoint(const Standard_Integer Index,gp_Pnt2d& P2d,gp_Pnt& P3d) ;

//! compute the sample-points for the intersections algorithms <br>
//! by adaptive algorithm for BSpline surfaces. For other surfaces algorithm <br>
//! is the same as in method ComputeSamplePoints(), but only fill arrays of U <br>
//! and V sample parameters; <br>
//! theDefl is a requred deflection <br>
//! theNUmin, theNVmin are minimal nb points for U and V. <br>
Standard_EXPORT virtual  void SamplePnts(const Standard_Real theDefl,const Standard_Integer theNUmin,const Standard_Integer theNVmin) ;
//Standard_EXPORT ~IntTools_TopolTool();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myNbSmplU;
Standard_Integer myNbSmplV;
Standard_Real myU0;
Standard_Real myV0;
Standard_Real myDU;
Standard_Real myDV;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
