// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _StdSelect_ViewerSelector3d_HeaderFile
#define _StdSelect_ViewerSelector3d_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_StdSelect_ViewerSelector3d_HeaderFile
#include <Handle_StdSelect_ViewerSelector3d.hxx>
#endif

#ifndef _Select3D_Projector_HeaderFile
#include <Select3D_Projector.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_V3d_View_HeaderFile
#include <Handle_V3d_View.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Graphic3d_Group_HeaderFile
#include <Handle_Graphic3d_Group.hxx>
#endif
#ifndef _Handle_Graphic3d_Structure_HeaderFile
#include <Handle_Graphic3d_Structure.hxx>
#endif
#ifndef _SelectMgr_ViewerSelector_HeaderFile
#include <SelectMgr_ViewerSelector.hxx>
#endif
#ifndef _Handle_SelectMgr_Selection_HeaderFile
#include <Handle_SelectMgr_Selection.hxx>
#endif
class V3d_View;
class Graphic3d_Group;
class Graphic3d_Structure;
class Select3D_Projector;
class SelectMgr_Selection;
class TColgp_Array1OfPnt2d;


//! Selector Usable by Viewers from V3d <br>
//! <br>
class StdSelect_ViewerSelector3d : public SelectMgr_ViewerSelector {

public:
 // Methods PUBLIC
 // 

//! Constructs an empty 3D selector object. <br>
Standard_EXPORT StdSelect_ViewerSelector3d();

//! Constructs a 3D selector object defined by the projector aProj. <br>
Standard_EXPORT StdSelect_ViewerSelector3d(const Select3D_Projector& aProj);

//! Initializes the projector in the view aView. <br>
Standard_EXPORT   void InitProj(const Handle(V3d_View)& aView) ;

//! Processes the projection of the sensitive  primitives <br>
//!          in the active view ; to be done before the selection action... <br>
Standard_EXPORT   void Convert(const Handle(SelectMgr_Selection)& aSelection) ;

//! Sets the sensitivity aSensitivity. <br>
Standard_EXPORT   void Set(const Standard_Integer aSensitivity) ;

//! Sets the new projector aProj to replace the one used at construction time. <br>
Standard_EXPORT   void Set(const Select3D_Projector& aProj) ;

//! Picks the sensitive entity at the pixel coordinates of <br>
//! the mouse Xpix and Ypix.   The selector looks for touched areas and owners. <br>
Standard_EXPORT   void Pick(const Standard_Integer XPix,const Standard_Integer YPix,const Handle(V3d_View)& aView) ;

//! Picks the sensitive entity according to the minimum <br>
//! and maximum pixel values XPMin, YPMin, XPMax <br>
//! and YPMax   defining a 2D area for selection in the 3D view aView. <br>
Standard_EXPORT   void Pick(const Standard_Integer XPMin,const Standard_Integer YPMin,const Standard_Integer XPMax,const Standard_Integer YPMax,const Handle(V3d_View)& aView) ;

//! pick action  - input pixel values for polyline selection for selection. <br>
Standard_EXPORT   void Pick(const TColgp_Array1OfPnt2d& Polyline,const Handle(V3d_View)& aView) ;
//! Returns the current Projector. <br>
 const Select3D_Projector& Projector() const;

//! Puts back the address of the current projector in sensitive primitives... <br>
Standard_EXPORT   void ReactivateProjector() ;

//! Displays sensitive areas found in the view aView. <br>
Standard_EXPORT   void DisplayAreas(const Handle(V3d_View)& aView) ;

//! Clears the view aView of sensitive areas found in it. <br>
Standard_EXPORT   void ClearAreas(const Handle(V3d_View)& aView) ;

//! Displays the selection aSel found in the view aView. <br>
Standard_EXPORT   void DisplaySensitive(const Handle(V3d_View)& aView) ;


Standard_EXPORT   void ClearSensitive(const Handle(V3d_View)& aView) ;


Standard_EXPORT   void DisplaySensitive(const Handle(SelectMgr_Selection)& aSel,const Handle(V3d_View)& aView,const Standard_Boolean ClearOthers = Standard_True) ;


Standard_EXPORT   void DisplayAreas(const Handle(SelectMgr_Selection)& aSel,const Handle(V3d_View)& aView,const Standard_Boolean ClearOthers = Standard_True) ;
//Standard_EXPORT ~StdSelect_ViewerSelector3d();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Standard_Boolean UpdateProj(const Handle(V3d_View)& aView) ;


Standard_EXPORT   void ComputeSensitivePrs(const Handle(SelectMgr_Selection)& aSel) ;


Standard_EXPORT   void ComputeAreasPrs(const Handle(SelectMgr_Selection)& aSel) ;


 // Fields PRIVATE
 //
Select3D_Projector myprj;
Standard_Real mycoeff[14];
Standard_Real myprevcoeff[14];
Standard_Real mycenter[2];
Standard_Real myprevcenter[2];
Handle_V3d_View mylastview;
Standard_Integer mypixtol;
Standard_Boolean myupdatetol;
Handle_Graphic3d_Group myareagroup;
Handle_Graphic3d_Group mysensgroup;
Handle_Graphic3d_Structure mystruct;


};


#include <StdSelect_ViewerSelector3d.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
