// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TDocStd_Application_HeaderFile
#define _TDocStd_Application_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_TDocStd_Application_HeaderFile
#include <Handle_TDocStd_Application.hxx>
#endif

#ifndef _Handle_Resource_Manager_HeaderFile
#include <Handle_Resource_Manager.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _CDF_Application_HeaderFile
#include <CDF_Application.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TDocStd_Document_HeaderFile
#include <Handle_TDocStd_Document.hxx>
#endif
#ifndef _CDF_RetrievableStatus_HeaderFile
#include <CDF_RetrievableStatus.hxx>
#endif
#ifndef _CDF_StoreStatus_HeaderFile
#include <CDF_StoreStatus.hxx>
#endif
class Resource_Manager;
class Standard_NoSuchObject;
class TDocStd_Document;
class TColStd_SequenceOfExtendedString;
class TCollection_ExtendedString;



//! The abstract root class for all application classes. <br>
//! They are in charge of: <br>
//! -   Creating documents <br>
//! -   Storing documents and retrieving them <br>
//! -   Initializing document views. <br>
//! To create a useful OCAF-based application, you <br>
//! derive a class from Application and implement <br>
//! the methods below. You will have to redefine the <br>
//! deferred (virtual) methods Formats, <br>
//! InitDocument, and Resources, and override others. <br>
//! The application is a container for a document, <br>
//! which in its turn is the container of the data <br>
//! framework made up of labels and attributes. <br>
//! Besides furnishing a container for documents, <br>
//! TDocStd_Application provides the following <br>
//! services for them: <br>
//! -   Creation of new documents <br>
//! -   Activation of documents in sessions of an application <br>
//! -   Storage and retrieval of documents <br>
//! -   Initialization of document views. <br>
//! Note: <br>
//! If a client needs detailed information concerning <br>
//! the events during the Open/Store operation, MessageDriver <br>
//! inherited from CDM_MessageDriver of the <br>
//! corresponding application has to be implemented. <br>
//! If the MessageDriver is not defined all messages <br>
//! will be (by default) directed to <br>
//! CDM_NullMessageDriver and will be lost. <br>
class TDocStd_Application : public CDF_Application {

public:
 // Methods PUBLIC
 // 

//! Check if meta data driver was successfully loaded <br>
//!          by the application constructor <br>
Standard_EXPORT   Standard_Boolean IsDriverLoaded() const;

//! create  (if  not done)  a Manager  using ResourcesName <br>
//!          method. <br>
Standard_EXPORT virtual  Handle_Resource_Manager Resources() ;

//!  Returns the name of the file containing the <br>
//! resources of this application. <br>
//! In a resource file, the application associates the schema name <br>
//! of the document with the storage and <br>
//! retrieval plug-ins that are to be loaded for each <br>
//! document. On retrieval, the application reads the <br>
//! schema name in the heading of the CSF file and <br>
//! loads the plug-in indicated in the resource file. <br>
//! This plug-in instantiates the actual driver for <br>
//! transient-persistent conversion. <br>
//! Your application can bring this process into play <br>
//! by defining a class which inherits <br>
//! CDF_Application and redefines the function <br>
//! which returns the appropriate resources file. At <br>
//! this point, the function Retrieve and the class <br>
//! CDF_Store can be called. This allows you to <br>
//! deal with storage and retrieval of - as well as <br>
//! copying and pasting - documents. <br>
//! To implement a class like this, several virtual <br>
//! functions should be redefined. In particular, you <br>
//! must redefine the abstract function Resources <br>
//! inherited from the superclass CDM_Application. <br>
Standard_EXPORT virtual  Standard_CString ResourcesName()  = 0;

//! returns the number of documents handled by the current applicative session. <br>
Standard_EXPORT   Standard_Integer NbDocuments() const;

//! Constructs the new document aDoc. <br>
//! aDoc is identified by the index index which is <br>
//! any integer between 1 and n where n is the <br>
//! number of documents returned by NbDocument. <br>
//! Example <br>
//! Handle(TDocStd_Application) <br>
//! anApp; <br>
//! if (!CafTest::Find(A)) return 1; <br>
//!  Handle(TDocStd) aDoc; <br>
//! Standard_Integer nbdoc = anApp->NbDocuments(); <br>
//! for (Standard_Integer i = 1; i <= nbdoc; i++) { <br>
//! aApp->GetDocument(i,aDoc); <br>
Standard_EXPORT   void GetDocument(const Standard_Integer index,Handle(TDocStd_Document)& aDoc) const;


//! Returns the format name Formats <br>
//! representing the format supported for <br>
//! application documents. <br>
//! This virtual function is to be redefined for each <br>
//! specific application. <br>
Standard_EXPORT virtual  void Formats(TColStd_SequenceOfExtendedString& Formats)  = 0;

//! Constructs the empty new document aDoc. <br>
//! This document will have the format format. <br>
//! If InitDocument is redefined for a specific <br>
//! application, the new document is handled by the <br>
//! applicative session. <br>
Standard_EXPORT virtual  void NewDocument(const TCollection_ExtendedString& format,Handle(TDocStd_Document)& aDoc) ;

//! Initialize the document aDoc for the applicative session. <br>
//! This virtual function is called by NewDocument <br>
//! and is to be redefined for each specific application. <br>//! Modified flag (different of disk version) <br>
//!          ============= <br>//! to open/save a document <br>
//!          ======================= <br>
Standard_EXPORT virtual  void InitDocument(const Handle(TDocStd_Document)& aDoc) const;

//! Close the given document. the document is not any more <br>
//!          handled by the applicative session. <br>
Standard_EXPORT   void Close(const Handle(TDocStd_Document)& aDoc) ;

//!  Returns an index for the document found in the <br>
//! path path in this applicative session. <br>
//! If the returned value is 0, the document is not <br>
//! present in the applicative session. <br>
//! This method can be used for the interactive part <br>
//! of an application. For instance, on a call to <br>
//! Open, the document to be opened may already <br>
//! be in memory. IsInSession checks to see if this <br>
//! is the case. Open can be made to depend on <br>
//! the value of the index returned: if IsInSession <br>
//!  returns 0, the document is opened; if it returns <br>
//! another value, a message is displayed asking the <br>
//!  user if he wants to override the version of the <br>
//!  document in memory. <br>
//! Example: <br>
//! Standard_Integer insession = A->IsInSession(aDoc); <br>
//! if (insession > 0) { <br>
//! cout << "document " << insession << " is already in session" << endl; <br>
//! return 0; <br>
//! } <br>
Standard_EXPORT   Standard_Integer IsInSession(const TCollection_ExtendedString& path) const;

//! Retrieves the document aDoc stored under the <br>
//! name aName in the directory directory. <br>
//! In order not to override a version of aDoc which <br>
//! is already in memory, this method can be made <br>
//! to depend on the value returned by IsInSession. <br>
Standard_EXPORT   CDF_RetrievableStatus Open(const TCollection_ExtendedString& path,Handle(TDocStd_Document)& aDoc) ;

//!  Save the  active document  in the file  <name> in the <br>
//!           path <path> ; o verwrites  the file  if  it already exists. <br>
Standard_EXPORT   CDF_StoreStatus SaveAs(const Handle(TDocStd_Document)& aDoc,const TCollection_ExtendedString& path) ;

//! Save aDoc active document. <br>
//! Exceptions: <br>
//!  Standard_NotImplemented if the document <br>
//! was not retrieved in the applicative session by using Open. <br>
Standard_EXPORT   CDF_StoreStatus Save(const Handle(TDocStd_Document)& aDoc) ;

//!  Save the  active document  in the file  <name> in the <br>
//!           path <path>  .  overwrite  the file  if  it <br>
//!          already exist. <br>
Standard_EXPORT   CDF_StoreStatus SaveAs(const Handle(TDocStd_Document)& aDoc,const TCollection_ExtendedString& path,TCollection_ExtendedString& theStatusMessage) ;

//! Save the document overwriting the previous file <br>
Standard_EXPORT   CDF_StoreStatus Save(const Handle(TDocStd_Document)& aDoc,TCollection_ExtendedString& theStatusMessage) ;
//Standard_EXPORT ~TDocStd_Application();


friend class TDocStd_Document;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


Standard_EXPORT TDocStd_Application();

//! Notification that is fired at each OpenTransaction event. <br>
Standard_EXPORT virtual  void OnOpenTransaction(const Handle(TDocStd_Document)& theDoc) ;

//! Notification that is fired at each CommitTransaction event. <br>
Standard_EXPORT virtual  void OnCommitTransaction(const Handle(TDocStd_Document)& theDoc) ;

//! Notification that is fired at each AbortTransaction event. <br>
Standard_EXPORT virtual  void OnAbortTransaction(const Handle(TDocStd_Document)& theDoc) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Resource_Manager myResources;
Standard_Boolean myIsDriverLoaded;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
