// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _UnitsAPI_HeaderFile
#define _UnitsAPI_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_Units_Dimensions_HeaderFile
#include <Handle_Units_Dimensions.hxx>
#endif
#ifndef _UnitsAPI_SystemUnits_HeaderFile
#include <UnitsAPI_SystemUnits.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Units_Dimensions;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The UnitsAPI global functions are used to <br>
//! convert a value from any unit into another unit. <br>
//! Principles <br>
//! Conversion is executed among three unit systems: <br>
//! -   the SI System <br>
//! -   the user's Local System <br>
//! -   the user's Current System. <br>
//! The SI System is the standard international unit <br>
//! system. It is indicated by SI in the synopses of <br>
//! the UnitsAPI functions. <br>
//! The MDTV System corresponds to the SI <br>
//! international standard but the length unit and all <br>
//! its derivatives use millimeters instead of the meters. <br>
//! Both systems are proposed by Open CASCADE; <br>
//! the SI System is the standard option. By <br>
//! selecting one of these two systems, the user <br>
//! defines his Local System through the <br>
//! SetLocalSystem function. The Local System is <br>
//! indicated by LS in the synopses of the UnitsAPI functions. <br>
//! The user's Local System units can be modified in <br>
//! the working environment. The user defines his <br>
//! Current System by modifying its units through <br>
//! the SetCurrentUnit function. The Current <br>
//! System is indicated by Current in the synopses <br>
//! of the UnitsAPI functions. <br>
class UnitsAPI  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Converts the current unit value to the local system units value. <br>
//!  Example: CurrentToLS(1.,"LENGTH") returns 1000. if the current length unit <br>
//!          is meter and LocalSystem is MDTV. <br>
Standard_EXPORT static  Standard_Real CurrentToLS(const Standard_Real aData,const Standard_CString aQuantity) ;

//! Converts the current unit value to the SI system units value. <br>
//!  Example: CurrentToSI(1.,"LENGTH") returns 0.001 if current length unit <br>
//!          is millimeter. <br>
Standard_EXPORT static  Standard_Real CurrentToSI(const Standard_Real aData,const Standard_CString aQuantity) ;

//! Converts the local system units value to the current unit value. <br>
//!  Example: CurrentFromLS(1000.,"LENGTH") returns 1. if current length unit <br>
//!          is meter and LocalSystem is MDTV. <br>
Standard_EXPORT static  Standard_Real CurrentFromLS(const Standard_Real aData,const Standard_CString aQuantity) ;

//! Converts the SI system units value to the current unit value. <br>
//!  Example: CurrentFromSI(0.001,"LENGTH") returns 1 if current length unit <br>
//!          is millimeter. <br>
Standard_EXPORT static  Standard_Real CurrentFromSI(const Standard_Real aData,const Standard_CString aQuantity) ;

//! Converts the local unit value to the local system units value. <br>
//!  Example: AnyToLS(1.,"in.") returns 25.4 if the LocalSystem is MDTV. <br>
Standard_EXPORT static  Standard_Real AnyToLS(const Standard_Real aData,const Standard_CString aUnit) ;

//! Converts the local unit value to the local system units value. <br>
//!          and gives the associated dimension of the unit <br>
Standard_EXPORT static  Standard_Real AnyToLS(const Standard_Real aData,const Standard_CString aUnit,Handle(Units_Dimensions)& aDim) ;

//! Converts the local unit value to the SI system units value. <br>
//!  Example: AnyToSI(1.,"in.") returns 0.0254 <br>
Standard_EXPORT static  Standard_Real AnyToSI(const Standard_Real aData,const Standard_CString aUnit) ;

//! Converts the local unit value to the SI system units value. <br>
//!          and gives the associated dimension of the unit <br>
Standard_EXPORT static  Standard_Real AnyToSI(const Standard_Real aData,const Standard_CString aUnit,Handle(Units_Dimensions)& aDim) ;

//! Converts the local system units value to the local unit value. <br>
//!  Example: AnyFromLS(25.4,"in.") returns 1. if the LocalSystem is MDTV. <br>
//! Note: aUnit is also used to identify the type of physical quantity to convert. <br>
Standard_EXPORT static  Standard_Real AnyFromLS(const Standard_Real aData,const Standard_CString aUnit) ;

//! Converts the SI system units value to the local unit value. <br>
//!  Example: AnyFromSI(0.0254,"in.") returns 0.001 <br>
//! Note: aUnit is also used to identify the type of physical quantity to convert. <br>
Standard_EXPORT static  Standard_Real AnyFromSI(const Standard_Real aData,const Standard_CString aUnit) ;

//! Converts the aData value expressed in the <br>
//! current unit for the working environment, as <br>
//! defined for the physical quantity aQuantity by the <br>
//! last call to the SetCurrentUnit function, into the unit aUnit. <br>
Standard_EXPORT static  Standard_Real CurrentToAny(const Standard_Real aData,const Standard_CString aQuantity,const Standard_CString aUnit) ;

//! Converts the aData value expressed in the unit <br>
//! aUnit, into the current unit for the working <br>
//! environment, as defined for the physical quantity <br>
//! aQuantity by the last call to the SetCurrentUnit function. <br>
Standard_EXPORT static  Standard_Real CurrentFromAny(const Standard_Real aData,const Standard_CString aQuantity,const Standard_CString aUnit) ;

//! Converts the local unit value to another local unit value. <br>
//!  Example: AnyToAny(0.0254,"in.","millimeter") returns 1. ; <br>
Standard_EXPORT static  Standard_Real AnyToAny(const Standard_Real aData,const Standard_CString aUnit1,const Standard_CString aUnit2) ;

//! Converts the local system units value to the SI system unit value. <br>
//!  Example: LSToSI(1.,"LENGTH") returns 0.001 if the local system <br>
//!		length unit is millimeter. <br>
Standard_EXPORT static  Standard_Real LSToSI(const Standard_Real aData,const Standard_CString aQuantity) ;

//! Converts the SI system unit value to the local system units value. <br>
//!  Example: SIToLS(1.,"LENGTH") returns 1000. if the local system <br>
//!		length unit is millimeter. <br>
Standard_EXPORT static  Standard_Real SIToLS(const Standard_Real aData,const Standard_CString aQuantity) ;

//! Sets the local system units. <br>
//!  Example: SetLocalSystem(UnitsAPI_MDTV) <br>
Standard_EXPORT static  void SetLocalSystem(const UnitsAPI_SystemUnits aSystemUnit = UnitsAPI_SI) ;

//! Returns the current local system units. <br>
Standard_EXPORT static  UnitsAPI_SystemUnits LocalSystem() ;

//! Sets the current unit dimension <aUnit> to the unit quantity <aQuantity>. <br>
//!  Example: SetCurrentUnit("LENGTH","millimeter") <br>
Standard_EXPORT static  void SetCurrentUnit(const Standard_CString aQuantity,const Standard_CString aUnit) ;

//! Returns the current unit dimension <aUnit> from the unit quantity <aQuantity>. <br>
Standard_EXPORT static  Standard_CString CurrentUnit(const Standard_CString aQuantity) ;

//! saves the units in the file .CurrentUnits of the directory pointed by the <br>
//!          CSF_CurrentUnitsUserDefaults environment variable. <br>
Standard_EXPORT static  void Save() ;


Standard_EXPORT static  void Reload() ;

//! return the dimension associated to the quantity <br>
Standard_EXPORT static  Handle_Units_Dimensions Dimensions(const Standard_CString aQuantity) ;


Standard_EXPORT static  Handle_Units_Dimensions DimensionLess() ;


Standard_EXPORT static  Handle_Units_Dimensions DimensionMass() ;


Standard_EXPORT static  Handle_Units_Dimensions DimensionLength() ;


Standard_EXPORT static  Handle_Units_Dimensions DimensionTime() ;


Standard_EXPORT static  Handle_Units_Dimensions DimensionElectricCurrent() ;


Standard_EXPORT static  Handle_Units_Dimensions DimensionThermodynamicTemperature() ;


Standard_EXPORT static  Handle_Units_Dimensions DimensionAmountOfSubstance() ;


Standard_EXPORT static  Handle_Units_Dimensions DimensionLuminousIntensity() ;


Standard_EXPORT static  Handle_Units_Dimensions DimensionPlaneAngle() ;

//! Returns the basic dimensions. <br>
Standard_EXPORT static  Handle_Units_Dimensions DimensionSolidAngle() ;

//! Checks the coherence between the quantity <aQuantity> <br>
//!  	and the unit <aUnits> in the current system and <br>
//!		returns FALSE when it's WRONG. <br>
Standard_EXPORT static  Standard_Boolean Check(const Standard_CString aQuantity,const Standard_CString aUnit) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT static  void CheckLoading(const UnitsAPI_SystemUnits aSystemUnit) ;


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
