// File:	StepToGeom_MakeLine2d.cxx
// Created:	Wed Aug  4 10:55:40 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>
// sln 23.10.2001. CTS23496: Line is not created if direction have not been succesfully created (StepToGeom_MakeLine2d(...) function)

#include <StepToGeom_MakeLine2d.ixx>
#include <StepGeom_Line.hxx>
#include <StepGeom_Vector.hxx>
#include <StepGeom_CartesianPoint.hxx>
#include <StepToGeom_MakeVectorWithMagnitude2d.hxx>
#include <StepToGeom_MakeCartesianPoint2d.hxx>
#include <Geom2d_CartesianPoint.hxx>
#include <Geom2d_Line.hxx>
#include <Geom2d_Vector.hxx>
#include <gp_Pnt2d.hxx>
#include <gp_Vec2d.hxx>
#include <gp_Dir2d.hxx>
#include <StdFail_NotDone.hxx>

//=============================================================================
// Creation d' une Line de Geom2d a partir d' une Line de Step
//=============================================================================

StepToGeom_MakeLine2d::StepToGeom_MakeLine2d
  ( const Handle(StepGeom_Line)& L)
{
  Handle(StepGeom_CartesianPoint)   P;
  Handle(Geom2d_CartesianPoint)         P1;
  gp_Pnt2d                              P2; 
  Handle(StepGeom_Vector)           V;
  Handle(Geom2d_Vector)                 V1;
  gp_Vec2d                              V2;

  P  = L->Pnt();
  StepToGeom_MakeCartesianPoint2d MkPoint2d(P);
  P1 = MkPoint2d.Value();
  P2 = P1->Pnt2d();
  V  = L->Dir();
  StepToGeom_MakeVectorWithMagnitude2d MkVector2d(V);
  // sln 23.10.2001. CTS23496: Line is not created if direction have not been succesfully created 
  if(!MkVector2d.IsDone()) {
    done = Standard_False;
    return;
  }

  V1 = MkVector2d.Value();
  V2 = V1->Vec2d();
  theLine = new Geom2d_Line(P2, gp_Dir2d(V2));
  done = Standard_True;
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom2d_Line) &
      StepToGeom_MakeLine2d::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theLine;
}
