// TopologyOperationsDoc.cpp : implementation of the CTopologyOperationsDoc class
//

#include "stdafx.h"

#include "TopologyOperationsDoc.h"

#include "TopologyOperationsApp.h"
#include "ResultDialog.h"
#include "..\res\resource.h"

#include <AIS_ListOfInteractive.hxx>
#include <AIS_ListIteratorOfListOfInteractive.hxx>

/////////////////////////////////////////////////////////////////////////////
// CTopologyOperationsDoc

IMPLEMENT_DYNCREATE(CTopologyOperationsDoc, CDocument)

BEGIN_MESSAGE_MAP(CTopologyOperationsDoc, OCC_3dBaseDoc)
	//{{AFX_MSG_MAP(CTopologyOperationsDoc)
	ON_COMMAND(ID_CUT, OnCut)
	ON_COMMAND(ID_FUSE, OnFuse)
	ON_COMMAND(ID_SECTION, OnSection)
	ON_COMMAND(ID_COMMON, OnCommon)
	ON_COMMAND(ID_PSECTION, OnPsection)
	ON_COMMAND(ID_BLEND, OnBlend)
	ON_COMMAND(ID_CHAMF, OnChamf)
	ON_COMMAND(ID_EVOLVEDBLEND, OnEvolvedblend)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTopologyOperationsDoc construction/destruction

CTopologyOperationsDoc::CTopologyOperationsDoc()
{
	myAISContext->SetDisplayMode(AIS_Shaded,Standard_False);
}

CTopologyOperationsDoc::~CTopologyOperationsDoc()
{
}

/////////////////////////////////////////////////////////////////////////////
// CTopologyOperationsDoc diagnostics

#ifdef _DEBUG
void CTopologyOperationsDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CTopologyOperationsDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

void CTopologyOperationsDoc::OnCut() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

TopoDS_Shape theBox = BRepPrimAPI_MakeBox(200,60,60);

Handle (AIS_Shape)	ais1 = new AIS_Shape(theBox);
myAISContext->SetDisplayMode(ais1,1,Standard_False);
myAISContext->SetColor(ais1,Quantity_NOC_GREEN,Standard_False);
myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);
myAISContext->Display(ais1,Standard_False);
myAISContext->SetCurrentObject(ais1,Standard_False);
Fit();
Sleep(1000);


TopoDS_Shape theSphere = BRepPrimAPI_MakeSphere(gp_Pnt(100,20,20),80);
Handle (AIS_Shape)	ais2 = new AIS_Shape(theSphere);
myAISContext->SetDisplayMode(ais2,1,Standard_False);
myAISContext->SetColor(ais2,Quantity_NOC_YELLOW,Standard_False);
myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);
myAISContext->Display(ais2,Standard_False);
myAISContext->SetCurrentObject(ais2,Standard_False);
Fit();
Sleep(1000);

TopoDS_Shape ShapeCut = BRepAlgoAPI_Cut(theSphere,theBox);

myAISContext->Erase(ais1,Standard_False,Standard_False);
myAISContext->Erase(ais2,Standard_False,Standard_False);

Handle (AIS_Shape)	aSection = new AIS_Shape(ShapeCut);
myAISContext->SetDisplayMode(aSection,1,Standard_False);
myAISContext->SetColor(aSection,Quantity_NOC_RED,Standard_False);
myAISContext->SetMaterial(aSection,Graphic3d_NOM_PLASTIC,Standard_False);
myAISContext->Display(aSection,Standard_False);
myAISContext->SetCurrentObject(aSection,Standard_False);
Fit();

    TCollection_AsciiString Message ("\
		\n\
TopoDS_Shape theBox = BRepPrimAPI_MakeBox(200,40,40); \n\
 \n\
TopoDS_Shape theSphere = BRepPrimAPI_MakeSphere(gp_Pnt(100,20,20),80); \n\
 \n\
TopoDS_Shape ShapeCut = BRepAlgoAPI_Cut(theSphere,theBox); \n\
 \n");
	PocessTextInDialog("Cut the sphere with a box", Message);


}










void CTopologyOperationsDoc::OnFuse() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

gp_Pnt P(-5,5,-5);
TopoDS_Shape theBox1 = BRepPrimAPI_MakeBox(60,200,70);
Handle (AIS_Shape)	ais1 = new AIS_Shape(theBox1);
myAISContext->SetColor(ais1,Quantity_NOC_GREEN,Standard_False);
myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);
myAISContext->Display(ais1,Standard_False);
myAISContext->SetCurrentObject(ais1,Standard_False);
Fit();
Sleep(1000);

TopoDS_Shape theBox2 = BRepPrimAPI_MakeBox(P,20,150,110);
Handle (AIS_Shape)	ais2 = new AIS_Shape(theBox2);
myAISContext->SetColor(ais2,Quantity_NOC_YELLOW,Standard_False);
myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);
myAISContext->Display(ais2,Standard_False);
myAISContext->SetCurrentObject(ais2,Standard_False);
Fit();
Sleep(1000);

TopoDS_Shape FusedShape = BRepAlgoAPI_Fuse(theBox1,theBox2);

myAISContext->Erase(ais1,Standard_True,Standard_False);
myAISContext->Erase(ais2,Standard_True,Standard_False);

Handle (AIS_Shape)	aFusion = new AIS_Shape(FusedShape);
myAISContext->SetDisplayMode(aFusion,1,Standard_False);
myAISContext->SetColor(aFusion,Quantity_NOC_RED,Standard_False);
myAISContext->SetMaterial(aFusion,Graphic3d_NOM_PLASTIC,Standard_False);
myAISContext->Display(aFusion,Standard_False);
myAISContext->SetCurrentObject(aFusion,Standard_False);
Fit();

    TCollection_AsciiString Message ("\
		\n\
TopoDS_Shape theBox1 = BRepPrimAPI_MakeBox(50,200,70); \n\
 \n\
TopoDS_Shape theBox2 = BRepPrimAPI_MakeBox(-30,150,70); \n\
 \n\
TopoDS_Shape FusedShape = BRepAlgoAPI_Fuse(theBox1,theBox2); \n");
	PocessTextInDialog("Fuse the boxes", Message);

}

void CTopologyOperationsDoc::OnCommon() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

gp_Ax2 axe(gp_Pnt(10,10,10),gp_Dir(1,2,1));
TopoDS_Shape theBox = BRepPrimAPI_MakeBox(axe,60,80,100);

Handle(AIS_Shape) aboxshape=new AIS_Shape(theBox);
myAISContext->SetColor(aboxshape,Quantity_NOC_YELLOW,Standard_False);
myAISContext->SetMaterial(aboxshape,Graphic3d_NOM_PLASTIC,Standard_False);    
myAISContext->SetDisplayMode(aboxshape,1,Standard_False);
myAISContext->SetTransparency(aboxshape,0.2,Standard_False);
myAISContext->Display(aboxshape,Standard_False);
myAISContext->SetCurrentObject(aboxshape,Standard_False);
Fit();
Sleep(500);

TopoDS_Shape theWedge = BRepPrimAPI_MakeWedge(60.,100.,80.,20.);

Handle(AIS_Shape) awedge = new AIS_Shape(theWedge);
myAISContext->SetColor(awedge,Quantity_NOC_RED,Standard_False);
myAISContext->SetMaterial(awedge,Graphic3d_NOM_PLASTIC,Standard_False);    
myAISContext->SetTransparency(awedge,0.0,Standard_False);
myAISContext->Display(awedge,Standard_False);
myAISContext->SetCurrentObject(awedge,Standard_False);
Fit();
Sleep(500);

TopoDS_Shape theCommonSurface = BRepAlgoAPI_Common(theBox,theWedge);

myAISContext->Erase(aboxshape,Standard_True,Standard_False);
myAISContext->Erase(awedge,Standard_True,Standard_False);

Handle(AIS_Shape) acommon = new AIS_Shape(theCommonSurface);
myAISContext->SetColor(acommon,Quantity_NOC_GREEN,Standard_False); 
myAISContext->SetMaterial(acommon,Graphic3d_NOM_PLASTIC,Standard_False);    
myAISContext->Display(acommon,Standard_False);
myAISContext->SetCurrentObject(acommon);

   TCollection_AsciiString Message ("\
		\n\
gp_Ax2 axe(gp_Pnt(10,10,10),gp_Dir(1,2,1)); \n\
 \n\
TopoDS_Shape theBox = BRepPrimAPI_MakeBox(axe,60,80,100); \n\
 \n\
TopoDS_Shape theWedge = BRepPrimAPI_MakeWedge(60.,100.,80.,20.); \n\
 \n\
TopoDS_Shape theCommonSurface = BRepAlgoAPI_Common(theBox,theWedge); \n\
 \n");

	PocessTextInDialog("Compute the common surface ", Message);

}

void CTopologyOperationsDoc::OnSection() 
{

	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

TopoDS_Shape atorus = BRepPrimAPI_MakeTorus(120,20);

    Handle(AIS_Shape) ashape=new AIS_Shape(atorus);
    myAISContext->SetColor(ashape,Quantity_NOC_RED,Standard_False);
    myAISContext->SetMaterial(ashape,Graphic3d_NOM_PLASTIC,Standard_False);    
    myAISContext->SetDisplayMode(ashape,1,Standard_False);
	myAISContext->SetTransparency(ashape,0.1,Standard_False);
    myAISContext->Display(ashape,Standard_False);

gp_Vec V1(1,1,1);
Standard_Real radius = 120;
Standard_Integer i=-3;

for(i;i<=3;i++) {
    TopoDS_Shape asphere = BRepPrimAPI_MakeSphere(gp_Pnt(26*3*i,0,0),radius);

    Handle (AIS_Shape) theShape=new AIS_Shape (asphere);
    myAISContext->SetTransparency(theShape,0.1,Standard_False);
    myAISContext->SetColor(theShape,Quantity_NOC_WHITE,Standard_False);
    myAISContext->SetDisplayMode(theShape,1,Standard_False);
    myAISContext->Display(theShape,Standard_False);
	Fit();

    Standard_Boolean PerformNow=Standard_False; 

    BRepAlgoAPI_Section section(atorus,asphere,PerformNow);
    section.ComputePCurveOn1(Standard_True);
    section.Approximation(TopOpeBRepTool_APPROX);
    section.Build();

    Handle(AIS_Shape) asection=new AIS_Shape(section.Shape());
    myAISContext->SetDisplayMode(asection,0);
    myAISContext->SetColor(asection,Quantity_NOC_WHITE);
    myAISContext->Display(asection);
    if(i<3) {
    myAISContext->Remove(theShape);
	}
}
   TCollection_AsciiString Message ("\
		\n\
TopoDS_Shape atorus = BRepPrimAPI_MakeTorus(120,20); \n\
gp_Vec V1(1,1,1); \n\
Standard_Real radius = 120; \n\
Standard_Integer i=-3; \n\
for(i;i<=3;i++) { \n\
    TopoDS_Shape asphere = BRepPrimAPI_MakeSphere(gp_Pnt(78*i,0,0),radius); \n\
    Standard_Boolean PerformNow=Standard_False; \n\
    BRepAlgoAPI_Section section(atorus,asphere,PerformNow); \n\
    section.ComputePCurveOn1(Standard_True); \n\
    section.Approximation(TopOpeBRepTool_APPROX); \n\
    section.Build(); \n\
	\n");

	PocessTextInDialog("Compute the sections ", Message);

}

void CTopologyOperationsDoc::OnPsection() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

TopoDS_Shape theTorus = BRepPrimAPI_MakeTorus(35,8);
Handle(AIS_Shape) atorus = new AIS_Shape(theTorus);
myAISContext->SetColor(atorus,Quantity_NOC_YELLOW,Standard_False); 
myAISContext->SetMaterial(atorus,Graphic3d_NOM_PLASTIC,Standard_False);
myAISContext->SetTransparency(atorus,0.1,Standard_False);
myAISContext->Display(atorus,Standard_False);
myAISContext->SetCurrentObject(atorus,Standard_False);
Fit();
Sleep(500);

gp_Pln aplane(1,0.25,3,4);
Handle (Geom_Plane) thePlane = new Geom_Plane(aplane);
Handle (AIS_Plane) ais1 = new AIS_Plane(thePlane);
myAISContext->Display(ais1,Standard_False);
myAISContext->SetCurrentObject(ais1,Standard_False);
Fit();
Sleep(300);

BRepAlgoAPI_Section section(theTorus,thePlane,Standard_False);
section.ComputePCurveOn1(Standard_True);
section.Approximation(TopOpeBRepTool_APPROX);
section.Build();

Handle(AIS_Shape) asection=new AIS_Shape(section.Shape());
myAISContext->SetDisplayMode(asection ,0,Standard_False);
myAISContext->SetColor(asection,Quantity_NOC_WHITE,Standard_False); 
myAISContext->Display(asection,Standard_False);
Fit();

   TCollection_AsciiString Message ("\
		\n\
TopoDS_Shape theTorus = BRepPrimAPI_MakeTorus(60.,20.); \n\
 \n\
gp_Pln P(1,2,1,-15); \n\
 \n\
TopoDS_Shape Psection = BRepAlgoAPI_Section(theTorus,P);  \n\
\n");

	PocessTextInDialog("Compute the plane section ", Message);

}

void CTopologyOperationsDoc::OnBlend() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

TopoDS_Shape Box = BRepPrimAPI_MakeBox(gp_Pnt(-400,0,0),200,230,180);
Handle(AIS_Shape) ais1 = new AIS_Shape(Box);
myAISContext->SetColor(ais1,Quantity_NOC_YELLOW,Standard_False); 
myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False); 
myAISContext->Display(ais1,Standard_False);
myAISContext->SetCurrentObject(ais1,Standard_False);
Fit();
Sleep(500);

BRepFilletAPI_MakeFillet fillet(Box);

for (TopExp_Explorer ex(Box,TopAbs_EDGE); ex.More(); ex.Next()) {
	TopoDS_Edge Edge =TopoDS::Edge(ex.Current());
	fillet.Add(20,Edge);
}

myAISContext->Remove(ais1,Standard_False);

TopoDS_Shape blendedBox = fillet.Shape();
Handle(AIS_Shape) aBlendbox = new AIS_Shape(blendedBox);
myAISContext->SetColor(aBlendbox,Quantity_NOC_YELLOW,Standard_False); 
myAISContext->SetMaterial(aBlendbox,Graphic3d_NOM_PLASTIC,Standard_False); 
myAISContext->Display(aBlendbox,Standard_False);
myAISContext->SetCurrentObject(aBlendbox,Standard_False);
Fit();
Sleep(500);


gp_Pnt P1(250,150,75);
TopoDS_Shape S1 = BRepPrimAPI_MakeBox(300,200,200);
TopoDS_Shape S2 = BRepPrimAPI_MakeBox(P1,120,180,70);

TopoDS_Shape fusedShape = BRepAlgoAPI_Fuse(S1,S2);
Handle(AIS_Shape) ais2 = new AIS_Shape(fusedShape);
myAISContext->SetColor(ais2,Quantity_NOC_RED,Standard_False); 
myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);  
myAISContext->Display(ais2,Standard_False);
myAISContext->SetCurrentObject(ais2,Standard_False);
Fit();

BRepFilletAPI_MakeFillet fill(fusedShape);

for (TopExp_Explorer ex1(fusedShape,TopAbs_EDGE); ex1.More(); ex1.Next()) {
	TopoDS_Edge E =TopoDS::Edge(ex1.Current());
	fill.Add(E);
}

for (Standard_Integer i = 1;i<=fill.NbContours();i++) {
	Standard_Real longueur(fill.Length(i));
	Standard_Real Rad(0.15*longueur);
	fill.SetRadius(Rad,i, 1);
}

TopoDS_Shape blendedFusedSolids = fill.Shape();

Handle(AIS_Shape) aBlend = new AIS_Shape(blendedFusedSolids);
myAISContext->SetColor(aBlend,Quantity_NOC_RED,Standard_False); 
myAISContext->SetMaterial(aBlend,Graphic3d_NOM_PLASTIC,Standard_False);  
myAISContext->Display(aBlend,Standard_False);

myAISContext->Remove(ais2,Standard_False);
Fit();


 TCollection_AsciiString Message ("\
		\n\
//THE YELLOW BOX\n\
TopoDS_Shape Box = BRepPrimAPI_MakeBox(gp_Pnt(-400,0,0),200,230,180);\n\
\n\
BRepPrimAPI_MakeFillet fillet(Box);\n\
\n\
for (TopExp_Explorer ex(Box,TopAbs_EDGE); ex.More(); ex.Next()) {\n\
	TopoDS_Edge Edge =TopoDS::Edge(ex.Current());\n\
	fillet.Add(20,Edge);\n\
}\n\
TopoDS_Shape blendedBox = fillet.Shape();\n\
\n\
////////////////////////////////////////////////////////////////////////\n\
\n\
//THE RED SOLID\n\
 \n\
//Warning : On the acute angles of the boxes a fillet is created. \n\
On the angles of fusion a blend is created. \n\
\n\
gp_Pnt P1(150,150,75);\n\
TopoDS_Shape S1 = BRepPrimAPI_MakeBox(300,200,200);\n\
TopoDS_Shape S2 = BRepPrimAPI_MakeBox(P1,100,200,70);\n\
\n\
TopoDS_Shape fusedShape = BRepAlgoAPI_Fuse(S1,S2);\n\
BRepPrimAPI_MakeFillet fill(fusedShape);\n\
\n\
for (TopExp_Explorer ex1(fusedShape,TopAbs_EDGE); ex1.More(); ex1.Next()) {\n\
	TopoDS_Edge E =TopoDS::Edge(ex1.Current());\n\
	fill.Add(E);\n\
}\n\
\n\
for (Standard_Integer i = 1;i<=fill.NbContours();i++) {\n\
	Standard_Real longueur(fill.Length(i));\n\
	Standard_Real Rad(0.2*longueur);\n\
	fill.SetRadius(Rad,i);\n\
}\n\
\n\
TopoDS_Shape blendedFusedSolids = fill.Shape(); \n");

	PocessTextInDialog("Compute the blend on the edges ", Message);
}

void CTopologyOperationsDoc::OnEvolvedblend() 
{

	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

TopoDS_Shape theBox = BRepPrimAPI_MakeBox(200,200,200);
Handle(AIS_Shape) ais1 = new AIS_Shape(theBox);
myAISContext->SetColor(ais1,Quantity_NOC_BROWN,Standard_False); 
myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False); 
myAISContext->Display(ais1,Standard_False);
myAISContext->SetCurrentObject(ais1,Standard_False);
Fit();
Sleep(500);

BRepFilletAPI_MakeFillet Rake(theBox);

TopExp_Explorer ex(theBox,TopAbs_EDGE);
ex.Next();
ex.Next();
ex.Next();
ex.Next();
Rake.Add(8,50,TopoDS::Edge(ex.Current()));
Rake.Build();
if (Rake.IsDone() ){
	TopoDS_Shape evolvedBox = Rake.Shape();
	ais1->Set(evolvedBox);
	myAISContext->Redisplay(ais1,Standard_False);
	myAISContext->SetCurrentObject(ais1,Standard_False);
	Fit();
	Sleep(500);

}

TopoDS_Shape theCylinder = BRepPrimAPI_MakeCylinder(gp_Ax2(gp_Pnt(-300,0,0),gp_Dir(0,0,1)),100,200);
Handle(AIS_Shape) ais3 = new AIS_Shape(theCylinder);
myAISContext->SetColor(ais3,Quantity_NOC_GREEN,Standard_False); 
myAISContext->SetMaterial(ais3,Graphic3d_NOM_PLASTIC,Standard_False);    
myAISContext->Display(ais3,Standard_False);
myAISContext->SetCurrentObject(ais3,Standard_False);
Fit();
Sleep(500);

BRepFilletAPI_MakeFillet fillet(theCylinder);

TColgp_Array1OfPnt2d TabPoint2(1,20);

for (Standard_Integer i=0; i<=19; i++) {
	gp_Pnt2d Point2d(i*2*PI/19,60*cos(i*PI/19-PI/2)+10);
	TabPoint2.SetValue(i+1,Point2d);
}

TopExp_Explorer exp2(theCylinder,TopAbs_EDGE);
fillet.Add(TabPoint2,TopoDS::Edge(exp2.Current()));
fillet.Build();
if (fillet.IsDone() ){
	TopoDS_Shape LawEvolvedCylinder = fillet.Shape();
	ais3->Set(LawEvolvedCylinder);
	myAISContext->Redisplay(ais3,Standard_False);
	myAISContext->SetCurrentObject(ais3,Standard_False);
	Fit();
	Sleep(500);
}

gp_Pnt P(350,0,0);
TopoDS_Shape theBox2 = BRepPrimAPI_MakeBox(P,200,200,200);
Handle(AIS_Shape) ais2 = new AIS_Shape(theBox2);
myAISContext->SetColor(ais2,Quantity_NOC_RED,Standard_False); 
myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);    
myAISContext->Display(ais2,Standard_False);
myAISContext->SetCurrentObject(ais2,Standard_False);
Fit();
Sleep(500);


BRepFilletAPI_MakeFillet afillet(theBox2);

TColgp_Array1OfPnt2d TabPoint(1,6);

gp_Pnt2d P1(0.,8.);
gp_Pnt2d P2(0.2,16.);
gp_Pnt2d P3(0.4,25.);
gp_Pnt2d P4(0.6,55.);
gp_Pnt2d P5(0.8,28.);
gp_Pnt2d P6(1.,20.);
TabPoint.SetValue(1,P1);
TabPoint.SetValue(2,P2);
TabPoint.SetValue(3,P3);
TabPoint.SetValue(4,P4);
TabPoint.SetValue(5,P5);
TabPoint.SetValue(6,P6);

TopExp_Explorer exp(theBox2,TopAbs_EDGE);
exp.Next();
exp.Next();
exp.Next();
exp.Next();

afillet.Add(TabPoint, TopoDS::Edge(exp.Current()));

afillet.Build();
if (afillet.IsDone() ){
	TopoDS_Shape LawevolvedBox = afillet.Shape();
	ais2->Set(LawevolvedBox);
	myAISContext->Redisplay(ais2,Standard_False);
	myAISContext->SetCurrentObject(ais2,Standard_False);
	Fit();
	
}

   TCollection_AsciiString Message ("\
		\n\
//THE BROWN BOX \n\
\n\
TopoDS_Shape theBox = BRepPrimAPI_MakeBox(200,200,200);	\n\
	\n\
BRepPrimAPI_MakeFillet Rake(theBox);	\n\
ChFi3d_FilletShape FSh = ChFi3d_Rational;	\n\
Rake.SetFilletShape(FSh);	\n\
	\n\
TopExp_Explorer ex(theBox,TopAbs_EDGE);	\n\
ex.Next();   //in order to recover the front edge	\n\
ex.Next();	\n\
ex.Next();	\n\
ex.Next();	\n\
Rake.Add(8,50,TopoDS::Edge(ex.Current()));	\n\
 	\n\
Rake.Build();  \n\
if (Rake.IsDone() )  \n\
	TopoDS_Shape theBrownBox = Rake.Shape();	\n\
	\n\
//////////////////////////////////////////////////////////	\n\
	\n\
//THE GREEN CYLINDER	\n\
	\n\
TopoDS_Shape theCylinder = BRepPrimAPI_MakeCylinder(gp_Ax2(gp_Pnt(-300,0,0),gp_Dir(0,0,1)),100,200);	\n\
	\n\
BRepPrimAPI_MakeFillet fillet(theCylinder);	\n\
	\n\
TColgp_Array1OfPnt2d TabPoint2(1,20);	\n\
	\n\
for (Standard_Integer i=0; i<=19; i++) {	\n\
	gp_Pnt2d Point2d(i*2*PI/19,60*cos(i*PI/19-PI/2)+10);	\n\
	TabPoint2.SetValue(i+1,Point2d);	\n\
}	\n\
	\n\
TopExp_Explorer exp2(theCylinder,TopAbs_EDGE);	\n\
fillet.Add(TabPoint2,TopoDS::Edge(exp2.Current()));	\n\
 	\n\
fillet.Build();  \n\
if (fillet.IsDone() )  \n\
	TopoDS_Shape LawEvolvedCylinder = fillet.Shape();	\n\
	\n\
////////////////////////////////////////////////////////////	\n\
	\n\
	//THE RED BOX \n\
 \n\
gp_Pnt P(350,0,0);	\n\
TopoDS_Shape theBox2 = BRepPrimAPI_MakeBox(P,200,200,200);	\n\
	\n\
BRepPrimAPI_MakeFillet fill(theBox2);	\n\
	\n\
TColgp_Array1OfPnt2d TabPoint(1,6);	\n\
gp_Pnt2d P1(0,8);	\n\
gp_Pnt2d P2(0.2,16);	\n\
gp_Pnt2d P3(0.4,25);	\n\
gp_Pnt2d P4(0.6,55);	\n\
gp_Pnt2d P5(0.8,28);	\n\
gp_Pnt2d P6(1,20);	\n\
TabPoint.SetValue(1,P1);	\n\
TabPoint.SetValue(2,P2);	\n\
TabPoint.SetValue(3,P3);	\n\
TabPoint.SetValue(4,P4);	\n\
TabPoint.SetValue(5,P5);	\n\
TabPoint.SetValue(6,P6);	\n\
	\n\
TopExp_Explorer exp(theBox2,TopAbs_EDGE);	\n\
exp.Next();  //in order to trcover the front edge	\n\
exp.Next();	\n\
exp.Next();	\n\
exp.Next();	\n\
fill.Add(TabPoint,TopoDS::Edge(exp.Current()));	\n\
 	\n\
fill.Build();   \n\
if (fillet.IsDone() )  \n\
	TopoDS_Shape theRedBox = fill.Shape();	\n\
\n");

	PocessTextInDialog("Compute evolutiv blend on an edge ", Message);

}

void CTopologyOperationsDoc::OnChamf() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

TopoDS_Shape theBox = BRepPrimAPI_MakeBox(60,200,70);
Handle(AIS_Shape) ais1 = new AIS_Shape(theBox);
myAISContext->SetColor(ais1,Quantity_NOC_YELLOW,Standard_False); 
myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);    
myAISContext->Display(ais1,Standard_False);
myAISContext->SetCurrentObject(ais1,Standard_False);
Fit();
Sleep(500);

BRepFilletAPI_MakeChamfer MC(theBox);
// add all the edges to chamfer
TopTools_IndexedDataMapOfShapeListOfShape M;
TopExp::MapShapesAndAncestors(theBox,TopAbs_EDGE,TopAbs_FACE,M);
for (Standard_Integer i = 1;i<=M.Extent();i++) {
	TopoDS_Edge E = TopoDS::Edge(M.FindKey(i));
	TopoDS_Face F = TopoDS::Face(M.FindFromIndex(i).First());
	MC.Add(5,5,E,F);
	}

TopoDS_Shape ChanfrenedBox = MC.Shape();
Handle(AIS_Shape) aBlendedBox = new AIS_Shape(ChanfrenedBox);
myAISContext->SetColor(aBlendedBox,Quantity_NOC_YELLOW,Standard_False); 
myAISContext->SetMaterial(aBlendedBox,Graphic3d_NOM_PLASTIC,Standard_False);    
myAISContext->Display(aBlendedBox,Standard_False);
myAISContext->SetCurrentObject(aBlendedBox,Standard_False);
Fit();
Sleep(500);

myAISContext->Erase(ais1,Standard_True,Standard_False);

   TCollection_AsciiString Message ("\
		\n\
TopoDS_Shape theBox = BRepPrimAPI_MakeBox(130,200,170); \n\
BRepFilletAPI_MakeChamfer MC(theBox); \n\
TopTools_IndexedDataMapOfShapeListOfShape M; \n\
TopExp::MapShapesAndAncestors(theBox,TopAbs_EDGE,TopAbs_FACE,M); \n\
for (Standar1d_Integer i;i<M.Extent();i++) { \n\
	TopoDS_Edge E = TopoDS::Edge(M.FindKey(i)); \n\
	TopoDS_Face F = TopoDS::Face(M.FindFromIndex(i).First()); \n\
	MC.Add(15,15,E,F); \n\
	} \n\
TopoDS_Shape ChanfrenedBox = MC.Shape();  \n");

	PocessTextInDialog("Compute the chamfers on all the edges ", Message);
}

