// PlateDoc.cpp : implementation of the CPlateDoc class
//

#include "stdafx.h"

#include "PlateDoc.h"

#include <OCC_MainFrame.h>
#include "PlateApp.h"
#include <GeoAlgo_Sol.hxx>
#include "State.h"

#include <AIS_ListOfInteractive.hxx>
#include <AIS_ListIteratorOfListOfInteractive.hxx>

Handle(AIS_Shape) AIS1;
TopoDS_Face F1,F2;
TopoDS_Edge E1,E2;

/////////////////////////////////////////////////////////////////////////////
// CPlateDoc

IMPLEMENT_DYNCREATE(CPlateDoc, CDocument)

BEGIN_MESSAGE_MAP(CPlateDoc, OCC_3dBaseDoc)
	//{{AFX_MSG_MAP(CPlateDoc)
	ON_COMMAND(ID_Create_Sol, OnCreateSol)
	ON_COMMAND(ID_BUTTON_ERASE, OnButtonErase)
	ON_COMMAND(ID_BUTTON_FILL, OnButtonFill)
	ON_COMMAND(ID_STOP_STOP, OnStopStop)
	ON_COMMAND(ID_FILLWITHTANG, OnFillwithtang)
	ON_COMMAND(ID_RESET, OnReset)
	ON_UPDATE_COMMAND_UI(ID_FILLWITHTANG, OnUpdateFillwithtang)
	ON_UPDATE_COMMAND_UI(ID_BUTTON_FILL, OnUpdateButtonFill)
	ON_UPDATE_COMMAND_UI(ID_Create_Sol, OnUpdateCreateSol)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPlateDoc construction/destruction

CPlateDoc::CPlateDoc()
{
	// TODO: add one-time construction code here
	myState = -1;
	myAISContext->DefaultDrawer()->SetDeviationCoefficient(0.005);

}

/////////////////////////////////////////////////////////////////////////////
// CPlateDoc commands



//-----------------------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------------------
void CPlateDoc::InputEvent(const Standard_Integer  x     ,
				                   const Standard_Integer  y     ,
                                   const Handle(V3d_View)& aView ) 
{
    myAISContext->Select();
	if (myState == SELECT_EDGE_PLATE_TGTES_1) {
		myAISContext->InitSelected();
 		if (myAISContext->MoreSelected()) {
 			E1 = TopoDS::Edge(myAISContext->SelectedShape());
 			myAISContext->CloseLocalContext();
 			myState = SELECT_EDGE_PLATE_TGTES_2;
 			
			AIS_ListOfInteractive aLI;
			myAISContext->DisplayedObjects(aLI);
			if(aLI.Extent() == 2){
				myState = SELECT_EDGE_PLATE_TGTES_2;
				if (myAISContext->IsCurrent(aLI.First()))
					myAISContext->SetCurrentObject(aLI.Last());
				else
					myAISContext->SetCurrentObject(aLI.First());
				myAISContext->InitCurrent();
				Handle(AIS_Shape) ashape = Handle(AIS_Shape)::DownCast(myAISContext->Current());
 				F2 = TopoDS::Face(ashape->Shape());
				myAISContext->OpenLocalContext();
				myAISContext->Activate(ashape,2);
				myState = SELECT_EDGE_PLATE_TGTES_3;
				((OCC_MainFrame*)AfxGetMainWnd())->SetStatusMessage("Select an edge on the second face");
				return;
			}
			
			((OCC_MainFrame*)AfxGetMainWnd())->SetStatusMessage("Select second face");
			AIS_ListOfInteractive LI;
			myAISContext->DisplayedObjects(LI);
			if(LI.Extent() == 1){
				if(OnFileImportBrep_WithInitDir("TangentSurface") == 1)
				return;
			}
 		}
 		else
 			AfxMessageBox("Select an edge on the face!");
 
 	}
 	else if (myState == SELECT_EDGE_PLATE_TGTES_2) {
 		myAISContext->InitCurrent();
 		if (myAISContext->MoreCurrent()) {
 			Handle(AIS_Shape) ashape = Handle(AIS_Shape)::DownCast(myAISContext->Current());
 			F2 = TopoDS::Face(ashape->Shape());
			myAISContext->OpenLocalContext();
			myAISContext->Activate(ashape,2);
			myState = SELECT_EDGE_PLATE_TGTES_3;
			((OCC_MainFrame*)AfxGetMainWnd())->SetStatusMessage("Select an edge on the second face");
		}
		else 
			AfxMessageBox("Select the second face!");
	}
	else if (myState == SELECT_EDGE_PLATE_TGTES_3) {
		myAISContext->InitSelected();
		if (myAISContext->MoreSelected()) {
			E2 = TopoDS::Edge(myAISContext->SelectedShape());
			myAISContext->CloseLocalContext();

			Standard_Integer i, nbPntsOnFaces=10;
			Standard_Real u,First, Last, Delta, Tol=0.001, TolProj;
			Plate_Plate aPlate;
			gp_Vec V1,V2,W1,W2;
			gp_Pnt2d P2d;
			gp_Pnt P, PP;

			//get the pcurve, curve and surface
			BRepAdaptor_Curve   Curve3d1(E1), Curve3d2(E2);
			BRepAdaptor_Curve2d Curve2d1(E1,F1), Curve2d2(E2,F2);
			BRepAdaptor_Surface Surf1(F1), Surf2(F2);

			//compute the average plane : initial surface
			Handle(TColgp_HArray1OfPnt) theTanPoints = new
				TColgp_HArray1OfPnt (1,2*nbPntsOnFaces );

			Delta = (Curve3d1.LastParameter()-Curve3d1.FirstParameter())/(nbPntsOnFaces-1);
			for (u=Curve3d1.FirstParameter(),i=1;i<=nbPntsOnFaces; i++,u+=Delta)
				theTanPoints->SetValue(i,Curve3d1.Value(u));

			Delta = (Curve3d2.LastParameter()-Curve3d2.FirstParameter())/(nbPntsOnFaces-1);
			for (u=Curve3d2.FirstParameter(),i=1;i<=nbPntsOnFaces; i++,u+=Delta)
				theTanPoints->SetValue(nbPntsOnFaces+i,Curve3d2.Value(u));

			//Building an initial plane
			GeomPlate_BuildAveragePlane aMkPlane (theTanPoints,int(Tol),1,1,1);
			Handle(Geom_Plane) aPlane = aMkPlane.Plane();
			gp_Pln aPln = aPlane->Pln();
			gp_XYZ aNormale = aPln.Axis().Direction().XYZ();
			gp_Trsf aTrsf; // to compute the U and V of the points
			aTrsf.SetTransformation(aPln.Position());

			aPlane->D1(0,0,P,W1,W2); // extract plane DU & DV

			// 1st surface tangencies constraints
			Delta = (Curve3d1.LastParameter()-Curve3d1.FirstParameter())/(nbPntsOnFaces-1);
			for (u=Curve3d1.FirstParameter(),i=1; i<=nbPntsOnFaces; i++,u+=Delta) {
				P = Curve3d1.Value(u).Transformed(aTrsf);
				gp_XY UV(P.X(),P.Y());
				aPlate.Load(Plate_PinpointConstraint(UV,aNormale*P.Z()));
				Curve2d1.D0(u,P2d);
				Surf1.D1(P2d.X(),P2d.Y(),P,V1,V2);  // extract surface UV of the point
				aPlate.Load(Plate_GtoCConstraint(UV,
												 Plate_D1(W1.XYZ(),W2.XYZ()),
												 Plate_D1(V1.XYZ(),V2.XYZ())));
			}
			// 2nd surface 
			Delta = (Curve3d2.LastParameter()-Curve3d2.FirstParameter())/(nbPntsOnFaces-1);
			for (u=Curve3d2.FirstParameter(),i=1; i<=nbPntsOnFaces; i++,u+=Delta) {
				P = Curve3d2.Value(u).Transformed(aTrsf);
				gp_XY UV(P.X(),P.Y());
				aPlate.Load(Plate_PinpointConstraint(UV,aNormale*P.Z()));

				Curve2d2.D0(u,P2d);
				Surf2.D1(P2d.X(),P2d.Y(),P,V1,V2); 
				aPlate.Load(Plate_GtoCConstraint(UV,
												 Plate_D1(W1.XYZ(),W2.XYZ()),
												 Plate_D1(V1.XYZ()*-1,V2.XYZ()*-1)));
			}

			((OCC_MainFrame*)AfxGetMainWnd())->SetStatusMessage("Select a file with passing points");
			//Some passing points
			CFileDialog dlg(TRUE,
					NULL,
					NULL,
					OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
					"Points Files (*.pass)|*.pass; |All Files (*.*)|*.*||", 
					NULL );

			CString initdir(((OCC_BaseApp*) AfxGetApp())->GetInitDataDir());
			initdir += "\\Data\\TangentSurface";

			dlg.m_ofn.lpstrInitialDir = initdir;

			if (dlg.DoModal() == IDOK) 
			{
				((OCC_MainFrame*)AfxGetMainWnd())->SetStatusMessage("Building the tangent surface...");
				SetCursor(AfxGetApp()->LoadStandardCursor(IDC_WAIT));
				CString filename = dlg.GetPathName();
				filebuf fic;
				istream in(&fic);  
				if (!fic.open((Standard_CString)(LPCTSTR)filename,ios::in))
					MessageBox(0,"Error : Unable to open file","CasCade Error",MB_ICONERROR);
				Standard_Real x,y,z;
				BRep_Builder B;
				TopoDS_Compound C;
				B.MakeCompound(C);
				while (!in.fail()|| !in.eof()){
					if (in >> x && in >> y && in >> z){
						PP = gp_Pnt(x, y, z);
						P = PP.Transformed(aTrsf);
						aPlate.Load(Plate_PinpointConstraint(gp_XY(P.X(),P.Y()),
															aNormale*P.Z()));
						BRepBuilderAPI_MakeVertex V(PP);
						B.Add(C,V.Vertex());	    
					}
				}
				fic.close();
 				Handle(AIS_Shape) anAISCompound = new AIS_Shape(C);
				myAISContext->Display(anAISCompound, Standard_False);
				Fit();
				Sleep(500);
			}
			SetCursor(AfxGetApp()->LoadStandardCursor(IDC_WAIT));
			((OCC_MainFrame*)AfxGetMainWnd())->SetStatusMessage("Building the tangent surface...");
			//Solving ... 
			Standard_Integer Order = 3; // constraints continuity + 2
			aPlate.SolveTI(Order,1.);
			if (!aPlate.IsDone()){
				MessageBox(0,"Error : Build plate not valid!","CasCade Error",MB_ICONERROR);
				return;
			}
			//Plate Surface creation 
			Handle(GeomPlate_Surface) aPlateSurface = new GeomPlate_Surface(aPlane,aPlate);
			//BSplineSurface approximation 
			GeomPlate_MakeApprox aMkSurf(aPlateSurface,Tol,1,8,0.1,1);
			Handle(Geom_Surface) theSurface =aMkSurf.Surface();

			// Face building ... 
			Handle(Geom2d_Curve)C1,C2,C3,C4;
			Handle(Geom_Curve)C;
			C = BRep_Tool::Curve(E1,First,Last);
			TolProj = 0.01;
			C1 = GeomProjLib::Curve2d(C,First,Last,theSurface,TolProj);
			TopoDS_Edge Ed1 = BRepBuilderAPI_MakeEdge(C1,theSurface).Edge();

			C = BRep_Tool::Curve(E2,First,Last);
			TolProj = 0.01;
			C3 = GeomProjLib::Curve2d(C,First,Last,theSurface,TolProj);
			TopoDS_Edge Ed3 = BRepBuilderAPI_MakeEdge(C3,theSurface).Edge();
			
			C2 = GCE2d_MakeSegment(C1->Value(C1->FirstParameter()),
								C3->Value(C3->FirstParameter()));
			TopoDS_Edge Ed2 = BRepBuilderAPI_MakeEdge(C2,theSurface).Edge();
			C4 = GCE2d_MakeSegment(C1->Value(C1->LastParameter()),
								C3->Value(C3->LastParameter()));
			TopoDS_Edge Ed4 = BRepBuilderAPI_MakeEdge(C4,theSurface).Edge();
			Ed2.Reverse();
			Ed3.Reverse();
			TopoDS_Wire theWire = BRepBuilderAPI_MakeWire(Ed1,Ed2,Ed3,Ed4);
			TopoDS_Face theFace = BRepBuilderAPI_MakeFace(theWire);
			BRepLib::BuildCurves3d(theFace);
			if (!BRepAlgo::IsValid(theFace)){
				C2 = GCE2d_MakeSegment(C1->Value(C1->LastParameter()),
										C3->Value(C3->FirstParameter()));
				TopoDS_Edge Ed2 = BRepBuilderAPI_MakeEdge(C2,theSurface).Edge();
				C4 = GCE2d_MakeSegment(C3->Value(C3->LastParameter()),
								C1->Value(C1->FirstParameter()));
				TopoDS_Edge Ed4 = BRepBuilderAPI_MakeEdge(C4,theSurface).Edge();
				Ed3.Reverse();
				theWire = BRepBuilderAPI_MakeWire(Ed1,Ed2,Ed3,Ed4);
				theFace = BRepBuilderAPI_MakeFace(theWire);
				BRepLib::BuildCurves3d(theFace);
				if (!BRepAlgo::IsValid(theFace))
					MessageBox(AfxGetApp()->m_pMainWnd->m_hWnd,"Error : The plate surface is not valid!!!","CasCade Error",MB_ICONERROR);
			}

			Handle_AIS_Shape anAISShape=new AIS_Shape(theFace);
			myAISContext->SetColor(anAISShape,Quantity_NOC_BLUE1); 
			myAISContext->SetMaterial(anAISShape,Graphic3d_NOM_SILVER);                                  
			myAISContext->SetDisplayMode(anAISShape,1);                     
			myAISContext->Display(anAISShape);	
			myState = -1;
		}
		else
			AfxMessageBox("Select an edge on the second face!");
		((OCC_MainFrame*)AfxGetMainWnd())->SetStatusMessage("");

	}
}

//-----------------------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------------------
void  CPlateDoc::Popup(const Standard_Integer  x,
							   const Standard_Integer  y ,
                               const Handle(V3d_View)& aView   ) 
{
  Standard_Integer PopupMenuNumber=0;
  myAISContext->InitCurrent();
  if (myState == SELECT_EDGE_PLATE) 
    PopupMenuNumber=2;
  else if (myAISContext->MoreCurrent())
    PopupMenuNumber=1;

  CMenu menu;
  VERIFY(menu.LoadMenu(IDR_Popup3D));
  CMenu* pPopup = menu.GetSubMenu(PopupMenuNumber);
  ASSERT(pPopup != NULL);

  if (PopupMenuNumber == 1) // more than 1 object.
  {
    bool OneOrMoreInShading = false;
	for (myAISContext->InitCurrent();myAISContext->MoreCurrent ();myAISContext->NextCurrent ())
    if (myAISContext->IsDisplayed(myAISContext->Current(),1)) OneOrMoreInShading=true;
	if(!OneOrMoreInShading)
   	pPopup->EnableMenuItem(5, MF_BYPOSITION | MF_DISABLED | MF_GRAYED);
   }

 
  POINT winCoord = { x , y };
  Handle(WNT_Window) aWNTWindow=
  Handle(WNT_Window)::DownCast(aView->Window());
  ClientToScreen ( (HWND)(aWNTWindow->HWindow()),&winCoord);
  pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON , winCoord.x, winCoord.y , 
                         AfxGetMainWnd());
}

void CPlateDoc::OnCreateSol() 
{
	// TODO: Add your command handler code here
 // Creation d'un sol
	CFileDialog dlg(TRUE,
                  NULL,
                  NULL,
                  OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
                  "Points Files (*.dat)|*.dat; |All Files (*.*)|*.*||", 
                  NULL );

	CString initdir(((OCC_BaseApp*) AfxGetApp())->GetInitDataDir());
	initdir += "\\Data\\SurfaceFromPoints";

	dlg.m_ofn.lpstrInitialDir = initdir;

	if (dlg.DoModal() == IDOK) 
	{
		SetCursor(AfxGetApp()->LoadStandardCursor(IDC_WAIT));
		CString filename = dlg.GetPathName();

		filebuf fic;
		istream in(&fic);  
		if (!fic.open((Standard_CString)(LPCTSTR)filename,ios::in))
			MessageBox(AfxGetApp()->m_pMainWnd->m_hWnd,"Error : Unable to open file","CasCade Error",MB_ICONERROR);
		TColgp_SequenceOfXYZ seqOfXYZ;
		gp_XYZ pntXYZ;
		Standard_Integer nbPnt=0;
		Standard_Real x,y,z;
		BRep_Builder B;
		TopoDS_Compound C;
		B.MakeCompound(C);
		while (!in.fail()|| !in.eof()){
			if (in >> x && in >> y && in >> z){
				pntXYZ.SetX(x);
				pntXYZ.SetY(y);
				pntXYZ.SetZ(z);
				nbPnt++;
				seqOfXYZ.Append(pntXYZ);
				BRepBuilderAPI_MakeVertex V(gp_Pnt(x, y, z));
				B.Add(C,V.Vertex());	    
			}
		}
		fic.close();
 		Handle(AIS_Shape) anAISCompound = new AIS_Shape(C);
		myAISContext->Display(anAISCompound, Standard_False);
		Fit();
		Sleep(1000);
		GeoAlgo_Sol sol;
		sol.Build(seqOfXYZ);
  
		if (sol.IsDone() == Standard_True){
			Handle(Geom_BSplineSurface) GeomSol = sol.Surface();
			TopoDS_Face aface = BRepBuilderAPI_MakeFace(GeomSol);
			if (!BRepAlgo::IsValid(aface))
				MessageBox(AfxGetApp()->m_pMainWnd->m_hWnd,"Error : The plate surface is not valid!","CasCade Error",MB_ICONERROR);
			Handle_AIS_Shape anAISShape=new AIS_Shape(aface);
			myAISContext->Display(anAISShape, Standard_False);
			Fit();
		}   
		else
		   MessageBox(AfxGetApp()->m_pMainWnd->m_hWnd,"Error : Computation has failed","CasCade Error",MB_ICONERROR);
	}
}

void CPlateDoc::OnButtonErase() 
{
	// TODO: Add your command handler code here

	myAISContext->EraseAll(Standard_False);
}



void CPlateDoc::OnButtonFill() 
{
	// TODO: Add your command handler code here
	myAISContext->InitCurrent();
	if (myAISContext->MoreCurrent()) {
		AIS1 = Handle(AIS_Shape)::DownCast(myAISContext->Current());
		myAISContext->OpenLocalContext();
		myAISContext->Unhilight(AIS1);
		myAISContext->Activate(AIS1,2);
		myState = SELECT_EDGE_PLATE;
		((OCC_MainFrame*)AfxGetMainWnd())->SetStatusMessage("Select hole contour edges and then press right mouse button");	}
	else {
		AIS_ListOfInteractive LI;
		myAISContext->DisplayedObjects(LI);
		if(LI.IsEmpty()){
			if(OnFileImportBrep_WithInitDir("HoleFilling") == 1)
				return;
		myAISContext->DisplayedObjects(LI);
		myAISContext->SetCurrentObject(LI.First());	
			OnButtonFill();
			return;
		}
	AfxMessageBox("Select a shape before!");
	}
}

void CPlateDoc::OnStopStop() 
{
	// TODO: Add your command handler code here
	// Stop selection
	if (myState == SELECT_EDGE_PLATE ) {
		Standard_Integer nbedges = 0;
		for (myAISContext->InitSelected(); myAISContext->MoreSelected();
		     myAISContext->NextSelected()) {
			nbedges++;
			
		}
		Handle(GeomPlate_HArray1OfHCurveOnSurface) Fronts =
			new GeomPlate_HArray1OfHCurveOnSurface(1,nbedges);
		Handle(TColStd_HArray1OfInteger) Tang = 
			new TColStd_HArray1OfInteger(1,nbedges);
		Handle(TColStd_HArray1OfInteger) NbPtsCur = 
			new TColStd_HArray1OfInteger(1,nbedges);
		Standard_Integer i = 0;
		TopoDS_Shape S1 = AIS1->Shape();
		TopTools_IndexedDataMapOfShapeListOfShape M;
		TopExp::MapShapesAndAncestors(S1, TopAbs_EDGE, TopAbs_FACE, M);

		for (myAISContext->InitSelected(); myAISContext->MoreSelected();myAISContext->NextSelected()) {
			i++;
			Tang->SetValue(i,1);
			NbPtsCur->SetValue(i,10);
			TopoDS_Edge E = TopoDS::Edge(myAISContext->SelectedShape());
			TopoDS_Face F = TopoDS::Face(M.FindFromKey(E).First());

			BRepAdaptor_Surface S(F);
			GeomAdaptor_Surface aGAS = S.Surface();
			Handle(GeomAdaptor_HSurface) aHGAS = new GeomAdaptor_HSurface(aGAS);

			Handle(BRepAdaptor_HCurve2d) C = new BRepAdaptor_HCurve2d();
			C->ChangeCurve2d().Initialize(E,F);

			Adaptor3d_CurveOnSurface ConS(C,aHGAS);

			Handle (Adaptor3d_HCurveOnSurface) HConS = new Adaptor3d_HCurveOnSurface(ConS);
			Fronts->SetValue(i,HConS);
		}
		GeomPlate_BuildPlateSurface abuildplate(NbPtsCur,Fronts,Tang,3);
		abuildplate.Perform();
		if (!abuildplate.IsDone()){ // New in 2.0
			MessageBox(AfxGetApp()->m_pMainWnd->m_hWnd,"Error : Build plate not valid!","CasCade Error",MB_ICONERROR);
			return;
		}
		Handle(GeomPlate_Surface) aplate = abuildplate.Surface();

		GeomPlate_MakeApprox aMKS(aplate, Precision::Approximation(), 4, 7, 0.001, 1);
		Handle(Geom_BSplineSurface) support = aMKS.Surface();
		BRepBuilderAPI_MakeWire MW;
		TopTools_Array1OfShape tab(1,nbedges);
		for (i=1 ; i<=nbedges ; i++) {
			if (abuildplate.Sense()->Value(abuildplate.Order()->Value(i))==1) {
				BRepBuilderAPI_MakeEdge ME(abuildplate.Curves2d()->Value(abuildplate.Order()->Value(i)),
									support,
									Fronts->Value(abuildplate.Order()->Value(i))->LastParameter(),
									Fronts->Value(abuildplate.Order()->Value(i))->FirstParameter());
				TopoDS_Edge E = ME.Edge();
				BRepLib::BuildCurves3d(E);
				tab(abuildplate.Order()->Value(i)) = E;
				//MW.Add(E);
			}
			else {
				BRepBuilderAPI_MakeEdge ME(abuildplate.Curves2d()->Value(abuildplate.Order()->Value(i)),
									support,
									Fronts->Value(abuildplate.Order()->Value(i))->FirstParameter(),
									Fronts->Value(abuildplate.Order()->Value(i))->LastParameter());
				TopoDS_Edge E = ME.Edge();
				BRepLib::BuildCurves3d(E);
				tab(abuildplate.Order()->Value(i)) = E;
			}	
		}
		for (i=1 ; i<=nbedges ; i++) 
			MW.Add(TopoDS::Edge(tab(i)));
		TopoDS_Wire W;
		try{
		W=MW.Wire();
		}
		
		catch(StdFail_NotDone)
		{
			AfxMessageBox("Can't build wire!");
			return;
		}

		if (!(W.Closed())){
			AfxMessageBox("Wire is not closed!");
			return;
			//Standard_Failure::Raise("Wire is not closed");
			
		}
		BRepBuilderAPI_MakeFace MF(support,W,Standard_True);
		TopoDS_Face aface;
		aface = MF.Face();
		BRepTopAdaptor_FClass2d clas2d(aface,Precision::Confusion());
		if (clas2d.PerformInfinitePoint() == TopAbs_IN) {
			W.Reverse();
			BRepBuilderAPI_MakeFace MF1(support,W,Standard_True);
			aface = MF1.Face();
		}
		if (!BRepAlgo::IsValid(aface))
			MessageBox(AfxGetApp()->m_pMainWnd->m_hWnd,"Error : The plate face is not valid!","CasCade Error",MB_ICONERROR);
		myAISContext->CloseLocalContext();
		myState = -1;
		Handle_AIS_Shape anAISShape = new AIS_Shape(aface);
		myAISContext->SetColor(anAISShape,Quantity_NOC_AZURE); 
		myAISContext->SetMaterial(anAISShape,Graphic3d_NOM_SILVER);                                  
        myAISContext->SetDisplayMode(anAISShape,1);                                    
		myAISContext->Display(anAISShape);		    
	}                            	
}

void CPlateDoc::OnFillwithtang() 
{
	static BOOL flag = 0;
	if (flag == 1){
		flag = 0;
		Handle(AIS_InteractiveObject) aObject;
		myAISContext ->InitCurrent();
		if(myAISContext->MoreCurrent())
			aObject = myAISContext->Current();
		((OCC_MainFrame*)AfxGetMainWnd())->SetStatusMessage("Select a file with second face");
		if(OnFileImportBrep_WithInitDir("TangentSurface") == 1){
			((OCC_MainFrame*)AfxGetMainWnd())->SetStatusMessage("");
				AIS_ListOfInteractive aList;
				myAISContext->DisplayedObjects(aList);
				AIS_ListIteratorOfListOfInteractive aListIterator;
				for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
					myAISContext->Remove(aListIterator.Value());
				}
				return;
			}
		myAISContext->SetCurrentObject(aObject);
	}

	myAISContext->InitCurrent();
	if (myAISContext->MoreCurrent()) {
		Handle(AIS_Shape) ashape = Handle(AIS_Shape)::DownCast(myAISContext->Current());
		try {
			F1 = TopoDS::Face(ashape->Shape());
		}
	    catch(Standard_Failure){}
		if (F1.IsNull())
                {
                    AfxMessageBox("Current object is not a face!\n\
Please, select a face to continue\nthe creation of a tangent surface.");
                    return;
                }
		myAISContext->OpenLocalContext();
		myAISContext->Activate(ashape,2);
		myState = SELECT_EDGE_PLATE_TGTES_1;
		
		((OCC_MainFrame*)AfxGetMainWnd())->SetStatusMessage("Select an edge on the first face");
	}
	else {
		AIS_ListOfInteractive LI;
		myAISContext->DisplayedObjects(LI);
		if(LI.IsEmpty()){
			((OCC_MainFrame*)AfxGetMainWnd())->SetStatusMessage("Select a file with first face");
			if(OnFileImportBrep_WithInitDir("TangentSurface") == 1){
				((OCC_MainFrame*)AfxGetMainWnd())->SetStatusMessage("");
				AIS_ListOfInteractive aList;
				myAISContext->DisplayedObjects(aList);
				AIS_ListIteratorOfListOfInteractive aListIterator;
				for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
					myAISContext->Remove(aListIterator.Value());
				}

				return;
			}
			((OCC_MainFrame*)AfxGetMainWnd())->SetStatusMessage("");
			myAISContext->DisplayedObjects(LI);
			myAISContext->SetCurrentObject(LI.First());	
			Sleep(700);
			flag = 1;
			OnFillwithtang();
			return;
		}
		AfxMessageBox("Select a face before");
	}
}

void CPlateDoc::OnReset() 
{
	myAISContext->CloseLocalContext();
	myState = -1;	
}

void CPlateDoc::OnUpdateFillwithtang(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(myState == SELECT_EDGE_PLATE_TGTES_1 ||
					 myState == SELECT_EDGE_PLATE_TGTES_2 ||
					 myState == SELECT_EDGE_PLATE_TGTES_3
				 );	
	pCmdUI->Enable (myState != SELECT_EDGE_PLATE);
}

void CPlateDoc::OnUpdateButtonFill(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable  (!(myState == SELECT_EDGE_PLATE_TGTES_1 ||
					 myState == SELECT_EDGE_PLATE_TGTES_2 ||
					 myState == SELECT_EDGE_PLATE_TGTES_3)
					 );	
	pCmdUI->SetCheck(myState == SELECT_EDGE_PLATE);

}

void CPlateDoc::OnUpdateCreateSol(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable  (!(myState == SELECT_EDGE_PLATE_TGTES_1 ||
					 myState == SELECT_EDGE_PLATE_TGTES_2 ||
					 myState == SELECT_EDGE_PLATE_TGTES_3,
					 myState == SELECT_EDGE_PLATE)
					 );	

}
